/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk.network;

import android.net.Uri;
import android.webkit.URLUtil;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.embrace.android.embracesdk.logging.InternalStaticEmbraceLogger;
import io.embrace.android.embracesdk.network.http.HttpMethod;
import java.util.EnumSet;
import java.util.Locale;

public class EmbraceNetworkRequest {
    private static final EnumSet<HttpMethod> allowedMethods = EnumSet.of(HttpMethod.GET, HttpMethod.PUT, HttpMethod.POST, HttpMethod.DELETE, HttpMethod.PATCH);
    private final String url;
    private final HttpMethod httpMethod;
    private final Long startTime;
    private final Long endTime;
    private final Long bytesReceived;
    private final Long bytesSent;
    private final Integer responseCode;
    private final Throwable error;
    private final String traceId;

    EmbraceNetworkRequest(Builder builder) {
        this.url = builder.urlString;
        this.httpMethod = builder.httpMethod;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.bytesReceived = builder.bytesReceived;
        this.bytesSent = builder.bytesSent;
        this.responseCode = builder.responseCode;
        this.error = builder.error;
        this.traceId = builder.traceId;
    }

    static boolean validateMethod(HttpMethod method) {
        if (method == null) {
            InternalStaticEmbraceLogger.logError("Method cannot be null");
            return false;
        }
        if (!allowedMethods.contains((Object)method)) {
            InternalStaticEmbraceLogger.logError("Not a valid method: " + method.name());
            return false;
        }
        return true;
    }

    @NonNull
    public static Builder newBuilder() {
        return new Builder();
    }

    public boolean canSend() {
        if (this.url == null) {
            InternalStaticEmbraceLogger.logError("Request must contain URL");
            return false;
        }
        if (this.httpMethod == null) {
            InternalStaticEmbraceLogger.logError("Request must contain method");
            return false;
        }
        if (this.startTime == null) {
            InternalStaticEmbraceLogger.logError("Request must contain startTime");
            return false;
        }
        if (this.endTime == null) {
            InternalStaticEmbraceLogger.logError("Request must contain endTime");
            return false;
        }
        if ((this.responseCode == null || this.responseCode == -1) && this.error == null) {
            InternalStaticEmbraceLogger.logError("Request must either have responseCode or error set");
            return false;
        }
        return true;
    }

    @NonNull
    public String getUrl() {
        return this.url;
    }

    @NonNull
    public String getHttpMethod() {
        return this.httpMethod != null ? this.httpMethod.name().toUpperCase() : null;
    }

    @NonNull
    public Long getStartTime() {
        return this.startTime;
    }

    @Nullable
    public Long getEndTime() {
        return this.endTime;
    }

    @NonNull
    public Long getBytesIn() {
        return this.bytesReceived == null ? 0L : this.bytesReceived;
    }

    @NonNull
    public Long getBytesOut() {
        return this.bytesSent == null ? 0L : this.bytesSent;
    }

    @Nullable
    public Integer getResponseCode() {
        return this.responseCode;
    }

    @Nullable
    public Throwable getError() {
        return this.error;
    }

    @Nullable
    public String getTraceId() {
        return this.traceId;
    }

    @NonNull
    public String description() {
        return "<" + this + ": " + this + " URL = " + this.url + " Method = " + (Object)((Object)this.httpMethod) + " Start = " + this.startTime + ">";
    }

    public static final class Builder {
        String urlString;
        HttpMethod httpMethod;
        Long startTime;
        Long endTime;
        Long bytesReceived;
        Long bytesSent;
        Integer responseCode;
        Throwable error;
        String traceId;

        Builder() {
        }

        public void withUrl(@NonNull String urlString) {
            this.urlString = urlString;
        }

        public void withHttpMethod(@NonNull HttpMethod httpMethod) {
            this.httpMethod = httpMethod;
        }

        public void withStartTime(@NonNull Long startTime) {
            this.startTime = startTime;
        }

        public void withEndTime(@NonNull Long date) {
            if (date == null) {
                InternalStaticEmbraceLogger.logError("End time cannot be null");
                return;
            }
            if (date <= this.startTime) {
                InternalStaticEmbraceLogger.logError("End time cannot be before the start time");
                return;
            }
            this.endTime = date;
        }

        @Deprecated
        public void withByteIn(@NonNull Long byteReceived) {
            this.withBytesIn(byteReceived);
        }

        public void withBytesIn(@NonNull Long bytesReceived) {
            if (bytesReceived < 0L) {
                InternalStaticEmbraceLogger.logError("bytesReceived must be a positive long");
                return;
            }
            this.bytesReceived = bytesReceived;
        }

        @Deprecated
        public void withByteOut(@NonNull Long bytesSent) {
            this.withBytesOut(bytesSent);
        }

        public void withBytesOut(@NonNull Long bytesSent) {
            if (bytesSent < 0L) {
                InternalStaticEmbraceLogger.logError("BytesOut must be a positive long");
                return;
            }
            this.bytesSent = bytesSent;
        }

        public void withResponseCode(@NonNull Integer responseCode) {
            if (responseCode < 100 || responseCode > 599) {
                InternalStaticEmbraceLogger.logError(String.format(Locale.getDefault(), "Invalid responseCode: %d", responseCode));
                return;
            }
            this.responseCode = responseCode;
        }

        public void withError(@NonNull Throwable error) {
            if (error == null) {
                InternalStaticEmbraceLogger.logError("Ignoring null error");
                return;
            }
            this.error = error;
        }

        public void withTraceId(@NonNull String traceId) {
            this.traceId = traceId;
        }

        @NonNull
        public EmbraceNetworkRequest build() {
            Uri url2;
            try {
                url2 = Uri.parse((String)this.urlString);
            }
            catch (NullPointerException ex) {
                InternalStaticEmbraceLogger.logError("Invalid URL: " + this.urlString);
                return null;
            }
            if (url2 == null || url2.getScheme() == null || url2.getHost() == null) {
                InternalStaticEmbraceLogger.logError("Invalid URL: " + this.urlString);
                return null;
            }
            if (!URLUtil.isHttpsUrl((String)this.urlString) && !URLUtil.isHttpUrl((String)this.urlString)) {
                InternalStaticEmbraceLogger.logError("Only http and https schemes are supported: " + this.urlString);
                return null;
            }
            if (!EmbraceNetworkRequest.validateMethod(this.httpMethod)) {
                return null;
            }
            if (this.startTime == null) {
                InternalStaticEmbraceLogger.logError("Start time cannot be null");
                return null;
            }
            return new EmbraceNetworkRequest(this);
        }
    }
}

