/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk.network;

import android.net.Uri;
import android.webkit.URLUtil;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.embrace.android.embracesdk.logging.InternalStaticEmbraceLogger;
import io.embrace.android.embracesdk.network.http.HttpMethod;
import java.util.EnumSet;
import java.util.Locale;

public class EmbraceNetworkRequestV2 {
    private static final EnumSet<HttpMethod> allowedMethods = EnumSet.of(HttpMethod.GET, HttpMethod.PUT, HttpMethod.POST, HttpMethod.DELETE, HttpMethod.PATCH);
    private final String url;
    private final HttpMethod httpMethod;
    private final Long startTime;
    private final Long endTime;
    private final Long bytesReceived;
    private final Long bytesSent;
    private final Integer responseCode;
    private final Throwable error;
    private final String traceId;

    EmbraceNetworkRequestV2(Builder builder) {
        this.url = builder.urlString;
        this.httpMethod = builder.httpMethod;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.bytesReceived = builder.bytesIn;
        this.bytesSent = builder.bytesOut;
        this.responseCode = builder.responseCode;
        this.error = builder.error;
        this.traceId = builder.traceId;
    }

    static boolean validateMethod(HttpMethod method) {
        if (method == null) {
            InternalStaticEmbraceLogger.logError("Method cannot be null");
            return false;
        }
        if (!allowedMethods.contains((Object)method)) {
            InternalStaticEmbraceLogger.logError("Not a valid method: " + method.name());
            return false;
        }
        return true;
    }

    public boolean canSend() {
        if (this.url == null) {
            InternalStaticEmbraceLogger.logError("Request must contain URL");
            return false;
        }
        if (this.httpMethod == null) {
            InternalStaticEmbraceLogger.logError("Request must contain method");
            return false;
        }
        if (this.startTime == null) {
            InternalStaticEmbraceLogger.logError("Request must contain startTime");
            return false;
        }
        if (this.endTime == null) {
            InternalStaticEmbraceLogger.logError("Request must contain endTime");
            return false;
        }
        if ((this.responseCode == null || this.responseCode == -1) && this.error == null) {
            InternalStaticEmbraceLogger.logError("Request must either have responseCode or error set");
            return false;
        }
        return true;
    }

    @NonNull
    public String getUrl() {
        return this.url;
    }

    @NonNull
    public String getHttpMethod() {
        return this.httpMethod != null ? this.httpMethod.name().toUpperCase() : null;
    }

    @NonNull
    public Long getStartTime() {
        return this.startTime;
    }

    @Nullable
    public Long getEndTime() {
        return this.endTime;
    }

    @NonNull
    public Long getBytesIn() {
        return this.bytesReceived == null ? 0L : this.bytesReceived;
    }

    @NonNull
    public Long getBytesOut() {
        return this.bytesSent == null ? 0L : this.bytesSent;
    }

    @Nullable
    public Integer getResponseCode() {
        return this.responseCode;
    }

    @Nullable
    public Throwable getError() {
        return this.error;
    }

    @Nullable
    public String getTraceId() {
        return this.traceId;
    }

    @NonNull
    public String description() {
        return "<" + this + ": " + this + " URL = " + this.url + " Method = " + (Object)((Object)this.httpMethod) + " Start = " + this.startTime + ">";
    }

    @NonNull
    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        String urlString;
        HttpMethod httpMethod;
        Long startTime;
        Long endTime;
        Long bytesIn;
        Long bytesOut;
        Integer responseCode;
        Throwable error;
        String traceId;

        Builder() {
        }

        @NonNull
        public Builder withUrl(@NonNull String urlString) {
            this.urlString = urlString;
            return this;
        }

        @NonNull
        public Builder withHttpMethod(@NonNull HttpMethod httpMethod) {
            this.httpMethod = httpMethod;
            return this;
        }

        @NonNull
        public Builder withHttpMethod(int httpMethod) {
            this.httpMethod = HttpMethod.fromInt(httpMethod);
            return this;
        }

        @NonNull
        public Builder withStartTime(@NonNull Long startTime) {
            this.startTime = startTime;
            return this;
        }

        @NonNull
        public Builder withEndTime(@NonNull Long date) {
            if (date == null) {
                InternalStaticEmbraceLogger.logError("End time cannot be null");
                return this;
            }
            if (date <= this.startTime) {
                InternalStaticEmbraceLogger.logError("End time cannot be before the start time");
                return this;
            }
            this.endTime = date;
            return this;
        }

        @Deprecated
        @NonNull
        public Builder withByteIn(@NonNull Long bytesReceived) {
            return this.withBytesIn(bytesReceived);
        }

        @NonNull
        public Builder withBytesIn(int bytesReceived) {
            return this.withBytesIn(Long.valueOf(bytesReceived));
        }

        @NonNull
        public Builder withBytesIn(@NonNull Long bytesReceived) {
            if (bytesReceived < 0L) {
                InternalStaticEmbraceLogger.logError("bytesReceived must be a positive long");
                return this;
            }
            this.bytesIn = bytesReceived;
            return this;
        }

        @Deprecated
        @NonNull
        public Builder withByteOut(@NonNull Long bytesSent) {
            return this.withBytesOut(bytesSent);
        }

        @NonNull
        public Builder withBytesOut(int bytesSent) {
            return this.withBytesOut(Long.valueOf(bytesSent));
        }

        @NonNull
        public Builder withBytesOut(@NonNull Long bytesSent) {
            if (bytesSent < 0L) {
                InternalStaticEmbraceLogger.logError("BytesOut must be a positive long");
                return this;
            }
            this.bytesOut = bytesSent;
            return this;
        }

        @NonNull
        public Builder withResponseCode(@NonNull Integer responseCode) {
            if (responseCode < 100 || responseCode > 599) {
                InternalStaticEmbraceLogger.logError(String.format(Locale.getDefault(), "Invalid responseCode: %d", responseCode));
                return this;
            }
            this.responseCode = responseCode;
            return this;
        }

        @NonNull
        public Builder withError(@NonNull Throwable error) {
            if (error == null) {
                InternalStaticEmbraceLogger.logError("Ignoring null error");
                return this;
            }
            this.error = error;
            return this;
        }

        @NonNull
        public Builder withTraceId(@NonNull String traceId) {
            this.traceId = traceId;
            return this;
        }

        @NonNull
        public EmbraceNetworkRequestV2 build() {
            Uri url2;
            try {
                url2 = Uri.parse((String)this.urlString);
            }
            catch (NullPointerException ex) {
                InternalStaticEmbraceLogger.logError("Failed to parse URL " + this.urlString);
                return null;
            }
            if (url2 == null || url2.getScheme() == null || url2.getHost() == null) {
                InternalStaticEmbraceLogger.logError("Invalid URL: " + this.urlString);
                return null;
            }
            if (!URLUtil.isHttpsUrl((String)this.urlString) && !URLUtil.isHttpUrl((String)this.urlString)) {
                InternalStaticEmbraceLogger.logError("Only http and https schemes are supported: " + this.urlString);
                return null;
            }
            if (!EmbraceNetworkRequestV2.validateMethod(this.httpMethod)) {
                return null;
            }
            if (this.startTime == null) {
                InternalStaticEmbraceLogger.logError("Start time cannot be null");
                return null;
            }
            return new EmbraceNetworkRequestV2(this);
        }
    }
}

