/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk.network;

import android.os.Build;
import io.embrace.android.embracesdk.InternalApi;
import io.embrace.android.embracesdk.logging.InternalStaticEmbraceLogger;
import io.embrace.android.embracesdk.network.http.EmbraceHttpUrlStreamHandler;
import io.embrace.android.embracesdk.network.http.EmbraceHttpsUrlStreamHandler;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.HashMap;
import java.util.Map;

@InternalApi
public final class EmbraceUrlStreamHandlerFactory
implements URLStreamHandlerFactory {
    private static final String PROTOCOL_HTTP = "http";
    private static final String PROTOCOL_HTTPS = "https";
    private static final String CLASS_HTTP_LIBCORE_STREAM_HANDLER = "libcore.net.http.HttpHandler";
    private static final String CLASS_HTTP_OKHTTP_STREAM_HANDLER = "com.android.okhttp.HttpHandler";
    private static final String CLASS_HTTPS_LIBCORE_STREAM_HANDLER = "libcore.net.http.HttpsHandler";
    private static final String CLASS_HTTPS_OKHTTP_STREAM_HANDLER = "com.android.okhttp.HttpsHandler";
    private static final Map<String, URLStreamHandler> handlers = new HashMap<String, URLStreamHandler>();

    private static URLStreamHandler newUrlStreamHandler(String className) {
        try {
            return (URLStreamHandler)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public URLStreamHandler createURLStreamHandler(String protocol) {
        return protocol != null ? handlers.get(protocol) : null;
    }

    static {
        try {
            if (Build.VERSION.SDK_INT < 19) {
                handlers.put(PROTOCOL_HTTP, new EmbraceHttpUrlStreamHandler(EmbraceUrlStreamHandlerFactory.newUrlStreamHandler(CLASS_HTTP_LIBCORE_STREAM_HANDLER)));
                handlers.put(PROTOCOL_HTTPS, new EmbraceHttpsUrlStreamHandler(EmbraceUrlStreamHandlerFactory.newUrlStreamHandler(CLASS_HTTPS_LIBCORE_STREAM_HANDLER)));
            } else {
                handlers.put(PROTOCOL_HTTP, new EmbraceHttpUrlStreamHandler(EmbraceUrlStreamHandlerFactory.newUrlStreamHandler(CLASS_HTTP_OKHTTP_STREAM_HANDLER)));
                handlers.put(PROTOCOL_HTTPS, new EmbraceHttpsUrlStreamHandler(EmbraceUrlStreamHandlerFactory.newUrlStreamHandler(CLASS_HTTPS_OKHTTP_STREAM_HANDLER)));
            }
        }
        catch (Exception ex) {
            InternalStaticEmbraceLogger.logError("Failed initialize EmbraceUrlStreamHandlerFactory", ex);
        }
    }
}

