/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk.network.http;

import androidx.annotation.NonNull;
import io.embrace.android.embracesdk.utils.Consumer;
import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicLong;

final class CountingInputStreamWithCallback
extends FilterInputStream {
    private volatile long streamMark = -1L;
    private final Consumer<Long, byte[]> callback;
    private volatile boolean callbackCompleted;
    private final AtomicLong count = new AtomicLong(0L);
    private final boolean shouldCaptureBody;
    ByteArrayOutputStream os = new ByteArrayOutputStream();

    CountingInputStreamWithCallback(InputStream in, boolean shouldCaptureBody, @NonNull Consumer<Long, byte[]> callback) {
        super(in);
        this.callback = callback;
        this.shouldCaptureBody = shouldCaptureBody;
    }

    public long getCount() {
        return this.count.longValue();
    }

    @Override
    public int read() throws IOException {
        int result2 = this.in.read();
        if (result2 != -1) {
            this.count.incrementAndGet();
            byte[] resultByte = new byte[]{Integer.valueOf(result2).byteValue()};
            this.conditionallyCaptureBody(resultByte, 0, 1);
        } else if (!this.callbackCompleted) {
            this.notifyCallback();
        }
        return result2;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int result2 = this.in.read(b, off, len);
        if (result2 != -1) {
            this.count.addAndGet(result2);
            this.conditionallyCaptureBody(b, off, result2);
        } else if (!this.callbackCompleted) {
            this.notifyCallback();
        }
        return result2;
    }

    @Override
    public long skip(long n) throws IOException {
        long result2 = this.in.skip(n);
        this.count.addAndGet(result2);
        return result2;
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.in.mark(readlimit);
        this.streamMark = this.count.longValue();
    }

    @Override
    public synchronized void reset() throws IOException {
        if (!this.in.markSupported()) {
            throw new IOException("Mark not supported");
        }
        if (this.streamMark == -1L) {
            throw new IOException("Mark not set");
        }
        this.in.reset();
        this.count.set(this.streamMark);
        this.callbackCompleted = false;
    }

    private void conditionallyCaptureBody(byte[] b, int off, int len) {
        if (!this.shouldCaptureBody) {
            return;
        }
        if (b != null) {
            this.os.write(b, off, len);
        }
    }

    private void notifyCallback() {
        this.callbackCompleted = true;
        this.callback.accept(this.count.longValue(), this.os.toByteArray());
    }
}

