/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk.network.http;

import io.embrace.android.embracesdk.InternalApi;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

@InternalApi
public class CountingOutputStream
extends FilterOutputStream {
    private long count;
    ByteArrayOutputStream os = new ByteArrayOutputStream();

    public CountingOutputStream(OutputStream out) {
        super(out);
    }

    public long getCount() {
        return this.count;
    }

    byte[] getRequestBody() {
        return this.os.toByteArray();
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
        this.count += (long)len;
        if (b != null) {
            this.os.write(b, off, len);
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
        ++this.count;
        this.os.write(b);
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }
}

