/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk.network.http;

import android.annotation.TargetApi;
import android.os.Build;
import io.embrace.android.embracesdk.InternalApi;
import io.embrace.android.embracesdk.network.http.EmbraceUrlConnectionOverride;
import io.embrace.android.embracesdk.network.http.EmbraceUrlConnectionService;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLConnection;
import java.security.Permission;
import java.util.List;
import java.util.Map;

@InternalApi
public class EmbraceHttpUrlConnection<T extends HttpURLConnection>
extends HttpURLConnection {
    private final EmbraceUrlConnectionService embraceConnectionService;

    public EmbraceHttpUrlConnection(T connection, boolean enableWrapIoStreams) {
        super(((URLConnection)connection).getURL());
        this.embraceConnectionService = new EmbraceUrlConnectionOverride<T>(connection, enableWrapIoStreams);
    }

    @Override
    public void addRequestProperty(String key, String value) {
        this.embraceConnectionService.addRequestProperty(key, value);
    }

    @Override
    public void connect() throws IOException {
        this.embraceConnectionService.connect();
    }

    @Override
    public void disconnect() {
        this.embraceConnectionService.disconnect();
    }

    @Override
    public boolean getAllowUserInteraction() {
        return this.embraceConnectionService.getAllowUserInteraction();
    }

    @Override
    public void setAllowUserInteraction(boolean allowUserInteraction) {
        this.embraceConnectionService.setAllowUserInteraction(allowUserInteraction);
    }

    @Override
    public int getConnectTimeout() {
        return this.embraceConnectionService.getConnectTimeout();
    }

    @Override
    public void setConnectTimeout(int timeout) {
        this.embraceConnectionService.setConnectTimeout(timeout);
    }

    @Override
    public Object getContent() throws IOException {
        return this.embraceConnectionService.getContent();
    }

    public Object getContent(Class[] classes) throws IOException {
        return this.embraceConnectionService.getContent(classes);
    }

    @Override
    public String getContentEncoding() {
        return this.embraceConnectionService.getContentEncoding();
    }

    @Override
    public int getContentLength() {
        return this.embraceConnectionService.getContentLength();
    }

    @Override
    @TargetApi(value=24)
    public long getContentLengthLong() {
        return this.embraceConnectionService.getContentLengthLong();
    }

    @Override
    public String getContentType() {
        return this.embraceConnectionService.getContentType();
    }

    @Override
    public long getDate() {
        return this.embraceConnectionService.getDate();
    }

    @Override
    public boolean getDefaultUseCaches() {
        return this.embraceConnectionService.getDefaultUseCaches();
    }

    @Override
    public void setDefaultUseCaches(boolean defaultUseCaches) {
        this.embraceConnectionService.setDefaultUseCaches(defaultUseCaches);
    }

    @Override
    public boolean getDoInput() {
        return this.embraceConnectionService.getDoInput();
    }

    @Override
    public void setDoInput(boolean doInput) {
        this.embraceConnectionService.setDoInput(doInput);
    }

    @Override
    public boolean getDoOutput() {
        return this.embraceConnectionService.getDoOutput();
    }

    @Override
    public void setDoOutput(boolean doOutput) {
        this.embraceConnectionService.setDoOutput(doOutput);
    }

    @Override
    public InputStream getErrorStream() {
        return this.embraceConnectionService.getErrorStream();
    }

    @Override
    public String getHeaderField(int n) {
        return this.embraceConnectionService.getHeaderField(n);
    }

    @Override
    public String getHeaderField(String name) {
        return this.embraceConnectionService.getHeaderField(name);
    }

    @Override
    public long getHeaderFieldDate(String name, long defaultValue) {
        return this.embraceConnectionService.getHeaderFieldDate(name, defaultValue);
    }

    @Override
    public int getHeaderFieldInt(String name, int defaultValue) {
        return this.embraceConnectionService.getHeaderFieldInt(name, defaultValue);
    }

    @Override
    public String getHeaderFieldKey(int n) {
        return this.embraceConnectionService.getHeaderFieldKey(n);
    }

    @Override
    @TargetApi(value=24)
    public long getHeaderFieldLong(String name, long defaultValue) {
        return this.embraceConnectionService.getHeaderFieldLong(name, defaultValue);
    }

    @Override
    public Map<String, List<String>> getHeaderFields() {
        return this.embraceConnectionService.getHeaderFields();
    }

    @Override
    public long getIfModifiedSince() {
        return this.embraceConnectionService.getIfModifiedSince();
    }

    @Override
    public void setIfModifiedSince(long ifModifiedSince) {
        this.embraceConnectionService.setIfModifiedSince(ifModifiedSince);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.embraceConnectionService.getInputStream();
    }

    @Override
    public boolean getInstanceFollowRedirects() {
        return this.embraceConnectionService.getInstanceFollowRedirects();
    }

    @Override
    public void setInstanceFollowRedirects(boolean followRedirects) {
        this.embraceConnectionService.setInstanceFollowRedirects(followRedirects);
    }

    @Override
    public long getLastModified() {
        return this.embraceConnectionService.getLastModified();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.embraceConnectionService.getOutputStream();
    }

    @Override
    public Permission getPermission() throws IOException {
        return this.embraceConnectionService.getPermission();
    }

    @Override
    public int getReadTimeout() {
        return this.embraceConnectionService.getReadTimeout();
    }

    @Override
    public void setReadTimeout(int timeout) {
        this.embraceConnectionService.setReadTimeout(timeout);
    }

    @Override
    public String getRequestMethod() {
        return this.embraceConnectionService.getRequestMethod();
    }

    @Override
    public void setRequestMethod(String method) throws ProtocolException {
        this.embraceConnectionService.setRequestMethod(method);
    }

    @Override
    public Map<String, List<String>> getRequestProperties() {
        return this.embraceConnectionService.getRequestProperties();
    }

    @Override
    public String getRequestProperty(String key) {
        return this.embraceConnectionService.getRequestProperty(key);
    }

    @Override
    public int getResponseCode() throws IOException {
        return this.embraceConnectionService.getResponseCode();
    }

    @Override
    public String getResponseMessage() throws IOException {
        return this.embraceConnectionService.getResponseMessage();
    }

    @Override
    public URL getURL() {
        return this.embraceConnectionService.getUrl();
    }

    @Override
    public boolean getUseCaches() {
        return this.embraceConnectionService.getUseCaches();
    }

    @Override
    public void setUseCaches(boolean useCaches) {
        this.embraceConnectionService.setUseCaches(useCaches);
    }

    @Override
    public void setChunkedStreamingMode(int chunkLen) {
        this.embraceConnectionService.setChunkedStreamingMode(chunkLen);
    }

    @Override
    public void setFixedLengthStreamingMode(int contentLength) {
        this.embraceConnectionService.setFixedLengthStreamingMode(contentLength);
    }

    @Override
    @TargetApi(value=19)
    public void setFixedLengthStreamingMode(long contentLength) {
        if (Build.VERSION.SDK_INT >= 19) {
            this.embraceConnectionService.setFixedLengthStreamingMode(contentLength);
        }
    }

    @Override
    public void setRequestProperty(String key, String value) {
        this.embraceConnectionService.setRequestProperty(key, value);
    }

    @Override
    public String toString() {
        return this.embraceConnectionService.toString();
    }

    @Override
    public boolean usingProxy() {
        return this.embraceConnectionService.usingProxy();
    }
}

