/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk.network.http;

import io.embrace.android.embracesdk.HttpPathOverrideRequest;
import io.embrace.android.embracesdk.InternalApi;
import io.embrace.android.embracesdk.logging.InternalStaticEmbraceLogger;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;

@InternalApi
public class EmbraceHttpUrlConnectionOverride
implements HttpPathOverrideRequest {
    private final HttpURLConnection connection;

    EmbraceHttpUrlConnectionOverride(HttpURLConnection connection) {
        this.connection = connection;
    }

    @Override
    public String getHeaderByName(String name) {
        return this.connection.getRequestProperty(name);
    }

    @Override
    public String getOverriddenURL(String pathOverride) {
        try {
            return new URL(this.connection.getURL().getProtocol(), this.connection.getURL().getHost(), this.connection.getURL().getPort(), pathOverride).toString();
        }
        catch (MalformedURLException e) {
            InternalStaticEmbraceLogger.logError("Failed to override path of " + this.connection.getURL() + " with " + pathOverride);
            return this.connection.getURL().toString();
        }
    }

    @Override
    public String getURLString() {
        return this.connection.getURL().toString();
    }
}

