/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk.network.http;

import io.embrace.android.embracesdk.InternalApi;
import io.embrace.android.embracesdk.network.EmbraceUrlStreamHandler;
import io.embrace.android.embracesdk.network.http.EmbraceHttpUrlConnection;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;

@InternalApi
public final class EmbraceHttpUrlStreamHandler
extends EmbraceUrlStreamHandler {
    static final int PORT = 80;

    public EmbraceHttpUrlStreamHandler(URLStreamHandler handler) {
        super(handler);
    }

    @Override
    public final int getDefaultPort() {
        return 80;
    }

    @Override
    protected Method getMethodOpenConnection(Class<URL> url2) throws NoSuchMethodException {
        Method method = this.handler.getClass().getDeclaredMethod("openConnection", url2);
        method.setAccessible(true);
        return method;
    }

    @Override
    protected Method getMethodOpenConnection(Class<URL> url2, Class<Proxy> proxy) throws NoSuchMethodException {
        Method method = this.handler.getClass().getDeclaredMethod("openConnection", url2, proxy);
        method.setAccessible(true);
        return method;
    }

    @Override
    protected URLConnection newEmbraceUrlConnection(URLConnection connection) {
        if (!(connection instanceof HttpURLConnection)) {
            return connection;
        }
        if (enableRequestSizeCapture.booleanValue() && !connection.getRequestProperties().containsKey("Accept-Encoding")) {
            connection.setRequestProperty("Accept-Encoding", "gzip");
            return new EmbraceHttpUrlConnection<HttpURLConnection>((HttpURLConnection)connection, true);
        }
        return new EmbraceHttpUrlConnection<HttpURLConnection>((HttpURLConnection)connection, false);
    }
}

