/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk.network.http;

import android.annotation.TargetApi;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.embrace.android.embracesdk.Embrace;
import io.embrace.android.embracesdk.InternalApi;
import io.embrace.android.embracesdk.logging.InternalStaticEmbraceLogger;
import io.embrace.android.embracesdk.network.http.CountingInputStreamWithCallback;
import io.embrace.android.embracesdk.network.http.CountingOutputStream;
import io.embrace.android.embracesdk.network.http.EmbraceHttpPathOverride;
import io.embrace.android.embracesdk.network.http.EmbraceHttpUrlConnectionOverride;
import io.embrace.android.embracesdk.network.http.EmbraceSslUrlConnectionService;
import io.embrace.android.embracesdk.network.http.EmbraceUrlConnectionService;
import io.embrace.android.embracesdk.network.http.HttpMethod;
import io.embrace.android.embracesdk.network.http.NetworkCaptureData;
import io.embrace.android.embracesdk.utils.exceptions.Unchecked;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLConnection;
import java.security.Permission;
import java.security.Principal;
import java.security.cert.Certificate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSocketFactory;
import kotlin.jvm.functions.Function0;

@InternalApi
class EmbraceUrlConnectionOverride<T extends HttpURLConnection>
implements EmbraceUrlConnectionService,
EmbraceSslUrlConnectionService {
    private static final String CONTENT_ENCODING = "Content-Encoding";
    private static final String CONTENT_LENGTH = "Content-Length";
    private final T connection;
    private final long createdTime;
    private final boolean enableWrapIoStreams;
    private volatile InputStream inputStream;
    private volatile CountingOutputStream outputStream;
    private volatile boolean didLogNetworkCall = false;
    private volatile Long endTime;
    private volatile Long startTime;
    private volatile String traceId;
    private volatile HashMap<String, String> requestHeaders;
    private volatile boolean isIoException;

    public EmbraceUrlConnectionOverride(@NonNull T connection, boolean enableWrapIoStreams) {
        this.connection = connection;
        this.createdTime = System.currentTimeMillis();
        this.enableWrapIoStreams = enableWrapIoStreams;
    }

    @Override
    public void addRequestProperty(@NonNull String key, @Nullable String value) {
        ((URLConnection)this.connection).addRequestProperty(key, value);
    }

    @Override
    public void connect() throws IOException {
        this.identifyTraceId();
        ((URLConnection)this.connection).connect();
    }

    @Override
    public void disconnect() {
        this.identifyTraceId();
        this.logNetworkCall(this.createdTime);
        ((HttpURLConnection)this.connection).disconnect();
    }

    @Override
    public boolean getAllowUserInteraction() {
        return ((URLConnection)this.connection).getAllowUserInteraction();
    }

    @Override
    public void setAllowUserInteraction(boolean allowUserInteraction) {
        ((URLConnection)this.connection).setAllowUserInteraction(allowUserInteraction);
    }

    @Override
    public int getConnectTimeout() {
        return ((URLConnection)this.connection).getConnectTimeout();
    }

    @Override
    public void setConnectTimeout(int timeout) {
        ((URLConnection)this.connection).setConnectTimeout(timeout);
    }

    @Override
    @Nullable
    public Object getContent() throws IOException {
        this.identifyTraceId();
        return ((URLConnection)this.connection).getContent();
    }

    @Override
    @Nullable
    public Object getContent(@NonNull Class<?>[] classes) throws IOException {
        this.identifyTraceId();
        return ((URLConnection)this.connection).getContent(classes);
    }

    @Override
    @Nullable
    public String getContentEncoding() {
        return this.shouldUncompressGzip() ? null : ((URLConnection)this.connection).getContentEncoding();
    }

    @Override
    public int getContentLength() {
        return this.shouldUncompressGzip() ? -1 : ((URLConnection)this.connection).getContentLength();
    }

    @Override
    @TargetApi(value=24)
    public long getContentLengthLong() {
        return this.shouldUncompressGzip() || Build.VERSION.SDK_INT < 24 ? -1L : ((URLConnection)this.connection).getContentLengthLong();
    }

    @Override
    @Nullable
    public String getContentType() {
        return ((URLConnection)this.connection).getContentType();
    }

    @Override
    public long getDate() {
        return ((URLConnection)this.connection).getDate();
    }

    @Override
    public boolean getDefaultUseCaches() {
        return ((URLConnection)this.connection).getDefaultUseCaches();
    }

    @Override
    public void setDefaultUseCaches(boolean defaultUseCaches) {
        ((URLConnection)this.connection).setDefaultUseCaches(defaultUseCaches);
    }

    @Override
    public boolean getDoInput() {
        return ((URLConnection)this.connection).getDoInput();
    }

    @Override
    public void setDoInput(boolean doInput) {
        ((URLConnection)this.connection).setDoInput(doInput);
    }

    @Override
    public boolean getDoOutput() {
        return ((URLConnection)this.connection).getDoOutput();
    }

    @Override
    public void setDoOutput(boolean doOutput) {
        ((URLConnection)this.connection).setDoOutput(doOutput);
    }

    @Override
    @Nullable
    public InputStream getErrorStream() {
        return this.getWrappedInputStream(((HttpURLConnection)this.connection).getErrorStream());
    }

    @Override
    public boolean shouldInterceptHeaderRetrieval(@Nullable String key) {
        return this.shouldUncompressGzip() && key != null && (key.equalsIgnoreCase(CONTENT_ENCODING) || key.equalsIgnoreCase(CONTENT_LENGTH));
    }

    @Override
    @Nullable
    public String getHeaderField(int n) {
        String key = ((HttpURLConnection)this.connection).getHeaderFieldKey(n);
        return this.retrieveHeaderField(key, null, () -> ((HttpURLConnection)this.connection).getHeaderField(n));
    }

    @Override
    @Nullable
    public String getHeaderField(@Nullable String name) {
        return this.retrieveHeaderField(name, null, () -> ((URLConnection)this.connection).getHeaderField(name));
    }

    @Override
    @Nullable
    public String getHeaderFieldKey(int n) {
        String key = ((HttpURLConnection)this.connection).getHeaderFieldKey(n);
        return this.retrieveHeaderField(key, null, () -> key);
    }

    @Override
    public long getHeaderFieldDate(@NonNull String name, long defaultValue) {
        Long result2 = this.retrieveHeaderField(name, defaultValue, () -> ((HttpURLConnection)this.connection).getHeaderFieldDate(name, defaultValue));
        return result2 != null ? result2 : defaultValue;
    }

    @Override
    public int getHeaderFieldInt(@NonNull String name, int defaultValue) {
        Integer result2 = this.retrieveHeaderField(name, defaultValue, () -> ((URLConnection)this.connection).getHeaderFieldInt(name, defaultValue));
        return result2 != null ? result2 : defaultValue;
    }

    @Override
    @TargetApi(value=24)
    public long getHeaderFieldLong(@NonNull String name, long defaultValue) {
        Long result2 = this.retrieveHeaderField(name, defaultValue, () -> Build.VERSION.SDK_INT < 24 ? -1L : ((URLConnection)this.connection).getHeaderFieldLong(name, defaultValue));
        return result2 != null ? result2 : defaultValue;
    }

    @Override
    @Nullable
    public Map<String, List<String>> getHeaderFields() {
        long startTime = System.currentTimeMillis();
        if (!this.enableWrapIoStreams) {
            return ((URLConnection)this.connection).getHeaderFields();
        }
        HashMap<String, List<String>> headerFields = new HashMap<String, List<String>>(((URLConnection)this.connection).getHeaderFields());
        headerFields.remove(CONTENT_ENCODING);
        headerFields.remove(CONTENT_LENGTH);
        this.logNetworkCall(startTime);
        return headerFields;
    }

    private <R> R retrieveHeaderField(@Nullable String name, R defaultValue, Function0<R> action) {
        if (name == null) {
            return null;
        }
        long startTime = System.currentTimeMillis();
        if (this.shouldInterceptHeaderRetrieval(name)) {
            return defaultValue;
        }
        Object result2 = action.invoke();
        this.logNetworkCall(startTime);
        return (R)result2;
    }

    @Override
    public long getIfModifiedSince() {
        return ((URLConnection)this.connection).getIfModifiedSince();
    }

    @Override
    public void setIfModifiedSince(long ifModifiedSince) {
        ((URLConnection)this.connection).setIfModifiedSince(ifModifiedSince);
    }

    @Override
    @Nullable
    public InputStream getInputStream() throws IOException {
        try {
            return this.getWrappedInputStream(((URLConnection)this.connection).getInputStream());
        }
        catch (IOException e) {
            this.isIoException = true;
            throw e;
        }
    }

    @Override
    public boolean getInstanceFollowRedirects() {
        return ((HttpURLConnection)this.connection).getInstanceFollowRedirects();
    }

    @Override
    public void setInstanceFollowRedirects(boolean followRedirects) {
        ((HttpURLConnection)this.connection).setInstanceFollowRedirects(followRedirects);
    }

    @Override
    public long getLastModified() {
        return ((URLConnection)this.connection).getLastModified();
    }

    @Override
    @Nullable
    public OutputStream getOutputStream() throws IOException {
        this.identifyTraceId();
        OutputStream out = ((URLConnection)this.connection).getOutputStream();
        if (this.enableWrapIoStreams && this.outputStream == null && out != null) {
            this.outputStream = new CountingOutputStream(out);
            return this.outputStream;
        }
        return out;
    }

    @Override
    @Nullable
    public Permission getPermission() throws IOException {
        return ((HttpURLConnection)this.connection).getPermission();
    }

    @Override
    public int getReadTimeout() {
        return ((URLConnection)this.connection).getReadTimeout();
    }

    @Override
    public void setReadTimeout(int timeout) {
        ((URLConnection)this.connection).setReadTimeout(timeout);
    }

    @Override
    @NonNull
    public String getRequestMethod() {
        return ((HttpURLConnection)this.connection).getRequestMethod();
    }

    @Override
    public void setRequestMethod(@NonNull String method) throws ProtocolException {
        ((HttpURLConnection)this.connection).setRequestMethod(method);
    }

    @Override
    @Nullable
    public Map<String, List<String>> getRequestProperties() {
        return ((URLConnection)this.connection).getRequestProperties();
    }

    @Override
    @Nullable
    public String getRequestProperty(@NonNull String key) {
        return ((URLConnection)this.connection).getRequestProperty(key);
    }

    @Override
    public int getResponseCode() throws IOException {
        this.identifyTraceId();
        long startTime = System.currentTimeMillis();
        int responseCode = ((HttpURLConnection)this.connection).getResponseCode();
        this.logNetworkCall(startTime);
        return responseCode;
    }

    @Override
    @Nullable
    public String getResponseMessage() throws IOException {
        this.identifyTraceId();
        long startTime = System.currentTimeMillis();
        String responseMsg = ((HttpURLConnection)this.connection).getResponseMessage();
        this.logNetworkCall(startTime);
        return responseMsg;
    }

    @Override
    @Nullable
    public URL getUrl() {
        return ((URLConnection)this.connection).getURL();
    }

    @Override
    public boolean getUseCaches() {
        return ((URLConnection)this.connection).getUseCaches();
    }

    @Override
    public void setUseCaches(boolean useCaches) {
        ((URLConnection)this.connection).setUseCaches(useCaches);
    }

    @Override
    public void setChunkedStreamingMode(int chunkLen) {
        ((HttpURLConnection)this.connection).setChunkedStreamingMode(chunkLen);
    }

    @Override
    public void setFixedLengthStreamingMode(int contentLength) {
        ((HttpURLConnection)this.connection).setFixedLengthStreamingMode(contentLength);
    }

    @Override
    @TargetApi(value=19)
    public void setFixedLengthStreamingMode(long contentLength) {
        if (Build.VERSION.SDK_INT >= 19) {
            ((HttpURLConnection)this.connection).setFixedLengthStreamingMode(contentLength);
        }
    }

    @Override
    public void setRequestProperty(@NonNull String key, @Nullable String value) {
        ((URLConnection)this.connection).setRequestProperty(key, value);
        if (this.hasNetworkCaptureRules()) {
            this.requestHeaders = this.getProcessedHeaders(this.getRequestProperties());
        }
    }

    @Override
    @NonNull
    public String toString() {
        return ((URLConnection)this.connection).toString();
    }

    @Override
    public boolean usingProxy() {
        return ((HttpURLConnection)this.connection).usingProxy();
    }

    synchronized void logNetworkCall(long startTime) {
        this.logNetworkCall(startTime, System.currentTimeMillis(), false, null, false, null);
    }

    synchronized void logNetworkCall(long startTime, long endTime, boolean overwrite, Long bytesIn, boolean shouldCaptureBody, byte[] responseBody) {
        if (!this.didLogNetworkCall || overwrite) {
            this.didLogNetworkCall = true;
            this.startTime = startTime;
            this.endTime = endTime;
            String url2 = EmbraceHttpPathOverride.getURLString(new EmbraceHttpUrlConnectionOverride((HttpURLConnection)this.connection));
            NetworkCaptureData networkCaptureData = null;
            if (this.hasNetworkCaptureRules() && (shouldCaptureBody || this.isIoException)) {
                HashMap<String, String> requestHeaders = this.requestHeaders;
                String requestQueryParams = ((URLConnection)this.connection).getURL().getQuery();
                byte[] requestBody = this.outputStream != null ? this.outputStream.getRequestBody() : null;
                HashMap<String, String> responseHeaders = this.getProcessedHeaders(this.getHeaderFields());
                networkCaptureData = new NetworkCaptureData(requestHeaders, requestQueryParams, requestBody, responseHeaders, responseBody, null);
            }
            try {
                long bytesOut = this.outputStream == null ? 0L : Math.max(this.outputStream.getCount(), 0L);
                long contentLength = bytesIn == null ? (long)Math.max(((URLConnection)this.connection).getContentLength(), 0) : bytesIn;
                Embrace.getInstance().logNetworkCall(url2, HttpMethod.fromString(this.getRequestMethod()), this.getResponseCode(), startTime, endTime, bytesOut, contentLength, this.traceId, networkCaptureData);
            }
            catch (Exception e) {
                String className = e.getClass().getCanonicalName();
                String message = e.getMessage();
                Embrace.getInstance().logNetworkClientError(url2, HttpMethod.fromString(this.getRequestMethod()), startTime, endTime, className != null ? className : "", message != null ? message : "", this.traceId, networkCaptureData);
            }
        }
    }

    @Nullable
    private HashMap<String, String> getProcessedHeaders(@Nullable Map<String, List<String>> properties) {
        if (properties == null) {
            return null;
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        for (Map.Entry<String, List<String>> h : properties.entrySet()) {
            StringBuilder builder = new StringBuilder();
            for (String value : h.getValue()) {
                if (value == null) continue;
                builder.append(value);
            }
            headers.put(h.getKey(), builder.toString());
        }
        return headers;
    }

    private CountingInputStreamWithCallback countingInputStream(InputStream inputStream) {
        return new CountingInputStreamWithCallback(inputStream, this.hasNetworkCaptureRules(), (bytesCount, responseBody) -> {
            if (this.startTime != null && this.endTime != null) {
                this.logNetworkCall(this.startTime, this.endTime, true, (Long)bytesCount, true, (byte[])responseBody);
            }
        });
    }

    private boolean shouldUncompressGzip() {
        String contentEncoding = ((URLConnection)this.connection).getContentEncoding();
        return this.enableWrapIoStreams && contentEncoding != null && contentEncoding.equalsIgnoreCase("gzip");
    }

    private void identifyTraceId() {
        if (this.traceId == null) {
            try {
                this.traceId = this.getRequestProperty(Embrace.getInstance().getTraceIdHeader());
            }
            catch (Exception e) {
                InternalStaticEmbraceLogger.logDebug("Failed to retrieve actual trace id header. Current: " + this.traceId);
            }
        }
    }

    @Override
    @Nullable
    public String getCipherSuite() {
        if (this.connection instanceof HttpsURLConnection) {
            return ((HttpsURLConnection)this.connection).getCipherSuite();
        }
        return null;
    }

    @Override
    @Nullable
    public Certificate[] getLocalCertificates() {
        if (this.connection instanceof HttpsURLConnection) {
            return ((HttpsURLConnection)this.connection).getLocalCertificates();
        }
        return new Certificate[0];
    }

    @Override
    @Nullable
    public Certificate[] getServerCertificates() throws SSLPeerUnverifiedException {
        if (this.connection instanceof HttpsURLConnection) {
            return ((HttpsURLConnection)this.connection).getServerCertificates();
        }
        return new Certificate[0];
    }

    @Override
    @Nullable
    public SSLSocketFactory getSslSocketFactory() {
        if (this.connection instanceof HttpsURLConnection) {
            return ((HttpsURLConnection)this.connection).getSSLSocketFactory();
        }
        return null;
    }

    @Override
    public void setSslSocketFactory(@NonNull SSLSocketFactory factory) {
        if (this.connection instanceof HttpsURLConnection) {
            ((HttpsURLConnection)this.connection).setSSLSocketFactory(factory);
        }
    }

    @Override
    @Nullable
    public HostnameVerifier getHostnameVerifier() {
        if (this.connection instanceof HttpsURLConnection) {
            return ((HttpsURLConnection)this.connection).getHostnameVerifier();
        }
        return null;
    }

    @Override
    public void setHostnameVerifier(@NonNull HostnameVerifier verifier) {
        if (this.connection instanceof HttpsURLConnection) {
            ((HttpsURLConnection)this.connection).setHostnameVerifier(verifier);
        }
    }

    @Override
    @Nullable
    public Principal getLocalPrincipal() {
        if (this.connection instanceof HttpsURLConnection) {
            return ((HttpsURLConnection)this.connection).getLocalPrincipal();
        }
        return null;
    }

    @Override
    @Nullable
    public Principal getPeerPrincipal() throws SSLPeerUnverifiedException {
        if (this.connection instanceof HttpsURLConnection) {
            return ((HttpsURLConnection)this.connection).getPeerPrincipal();
        }
        return null;
    }

    @Nullable
    private InputStream getWrappedInputStream(InputStream connectionInputStream) {
        this.identifyTraceId();
        long startTime = System.currentTimeMillis();
        InputStream in = null;
        if (this.shouldUncompressGzip()) {
            try {
                in = this.countingInputStream(new BufferedInputStream(Unchecked.wrap(() -> new GZIPInputStream(connectionInputStream))));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (in == null) {
            in = this.enableWrapIoStreams ? this.countingInputStream(new BufferedInputStream(connectionInputStream)) : connectionInputStream;
        }
        this.logNetworkCall(startTime);
        return in;
    }

    private boolean hasNetworkCaptureRules() {
        if (((URLConnection)this.connection).getURL() == null) {
            return false;
        }
        String url2 = ((URLConnection)this.connection).getURL().toString();
        String method = ((HttpURLConnection)this.connection).getRequestMethod();
        return Embrace.getInstance().shouldCaptureNetworkBody(url2, method);
    }
}

