/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk.utils.optional;

import androidx.annotation.Nullable;
import io.embrace.android.embracesdk.InternalApi;
import io.embrace.android.embracesdk.utils.Preconditions;
import io.embrace.android.embracesdk.utils.optional.Absent;
import io.embrace.android.embracesdk.utils.optional.Present;
import java.io.Serializable;
import java.util.Set;

@InternalApi
public abstract class Optional<T>
implements Serializable {
    private static final long serialVersionUID = 0L;

    Optional() {
    }

    public static <T> Optional<T> absent() {
        return Absent.withType();
    }

    public static <T> Optional<T> of(T reference) {
        return new Present<T>(Preconditions.checkNotNull(reference));
    }

    public static <T> Optional<T> fromNullable(@Nullable T nullableReference) {
        return nullableReference == null ? Optional.absent() : new Present<T>(nullableReference);
    }

    public abstract boolean isPresent();

    public abstract T get();

    public abstract T or(T var1);

    public abstract Optional<T> or(Optional<? extends T> var1);

    @Nullable
    public abstract T orNull();

    public abstract Set<T> asSet();

    public abstract boolean equals(@Nullable Object var1);

    public abstract int hashCode();

    public abstract String toString();
}

