/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk.worker;

import android.os.Process;
import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.logging.InternalStaticEmbraceLogger;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\u000bB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\f"}, d2={"Lio/embrace/android/embracesdk/worker/WorkerUtils;", "", "()V", "createThreadFactory", "Ljava/util/concurrent/ThreadFactory;", "name", "", "shutdownHook", "", "service", "Ljava/util/concurrent/ExecutorService;", "PriorityRunnable", "embrace-android-sdk_release"})
public final class WorkerUtils {
    @NotNull
    public static final WorkerUtils INSTANCE;

    @NotNull
    public final ThreadFactory createThreadFactory(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return new ThreadFactory(name){
            final /* synthetic */ String $name;

            public final Thread newThread(@NotNull Runnable runnable2) {
                Intrinsics.checkNotNullParameter((Object)runnable2, (String)"runnable");
                Thread thread = Executors.defaultThreadFactory().newThread(runnable2);
                boolean bl = false;
                boolean bl2 = false;
                Thread $this$apply = thread;
                boolean bl3 = false;
                Thread thread2 = $this$apply;
                Intrinsics.checkNotNullExpressionValue((Object)thread2, (String)"this");
                thread2.setName("Embrace " + this.$name);
                return thread;
            }
            {
                this.$name = string2;
            }
        };
    }

    public final void shutdownHook(@NotNull ExecutorService service, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Runtime.getRuntime().addShutdownHook(new Thread((Runnable)new PriorityRunnable(service){
            final /* synthetic */ ExecutorService $service;

            public void runWithPriority() {
                try {
                    InternalStaticEmbraceLogger.Companion companion = InternalStaticEmbraceLogger.Companion;
                    String msg$iv = "Shutdown hook for executor called";
                    Throwable throwable$iv = null;
                    boolean $i$f$logDebug = false;
                    companion.log(msg$iv, EmbraceLogger.Severity.DEBUG, throwable$iv, true);
                    this.$service.shutdown();
                    if (!this.$service.awaitTermination(4L, TimeUnit.SECONDS)) {
                        companion = InternalStaticEmbraceLogger.Companion;
                        msg$iv = "Executor did not shut down in time, shutting down immediately";
                        throwable$iv = null;
                        $i$f$logDebug = false;
                        companion.log(msg$iv, EmbraceLogger.Severity.DEBUG, throwable$iv, true);
                        this.$service.shutdownNow();
                    }
                }
                catch (InterruptedException ex) {
                    InternalStaticEmbraceLogger.Companion companion = InternalStaticEmbraceLogger.Companion;
                    String msg$iv = "Interrupted whilst attempting to shut down.";
                    Throwable throwable$iv = null;
                    boolean $i$f$logDebug = false;
                    companion.log(msg$iv, EmbraceLogger.Severity.DEBUG, throwable$iv, true);
                    this.$service.shutdownNow();
                    Thread.currentThread().interrupt();
                }
            }
            {
                this.$service = $captured_local_variable$0;
            }
        }, "Embrace Shutdown Hook for Worker: " + name));
    }

    private WorkerUtils() {
    }

    static {
        WorkerUtils workerUtils;
        INSTANCE = workerUtils = new WorkerUtils();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\"\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\b\u0010\u0005\u001a\u00020\u0004H&\u00a8\u0006\u0006"}, d2={"Lio/embrace/android/embracesdk/worker/WorkerUtils$PriorityRunnable;", "Ljava/lang/Runnable;", "()V", "run", "", "runWithPriority", "embrace-android-sdk_release"})
    private static abstract class PriorityRunnable
    implements Runnable {
        @Override
        public void run() {
            Process.setThreadPriority((int)10);
        }

        public abstract void runWithPriority();
    }
}

