/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.annotation.SuppressLint;
import android.content.Context;
import android.webkit.ConsoleMessage;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.embrace.android.embracesdk.EmbraceImpl;
import io.embrace.android.embracesdk.FlutterInternalInterface;
import io.embrace.android.embracesdk.ReactNativeInternalInterface;
import io.embrace.android.embracesdk.Severity;
import io.embrace.android.embracesdk.UnityInternalInterface;
import io.embrace.android.embracesdk.annotation.InternalApi;
import io.embrace.android.embracesdk.config.ConfigService;
import io.embrace.android.embracesdk.internal.EmbraceInternalInterface;
import io.embrace.android.embracesdk.internal.Systrace;
import io.embrace.android.embracesdk.internal.api.EmbraceAndroidApi;
import io.embrace.android.embracesdk.internal.api.EmbraceApi;
import io.embrace.android.embracesdk.internal.api.LogsApi;
import io.embrace.android.embracesdk.internal.api.MomentsApi;
import io.embrace.android.embracesdk.internal.api.NetworkRequestApi;
import io.embrace.android.embracesdk.internal.api.OTelApi;
import io.embrace.android.embracesdk.internal.api.SdkStateApi;
import io.embrace.android.embracesdk.internal.api.SessionApi;
import io.embrace.android.embracesdk.internal.api.UserApi;
import io.embrace.android.embracesdk.network.EmbraceNetworkRequest;
import io.embrace.android.embracesdk.spans.EmbraceSpan;
import io.embrace.android.embracesdk.spans.EmbraceSpanEvent;
import io.embrace.android.embracesdk.spans.ErrorCode;
import io.embrace.android.embracesdk.spans.TracingApi;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.sdk.logs.export.LogRecordExporter;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.util.List;
import java.util.Map;
import kotlin.jvm.functions.Function0;

@SuppressLint(value={"EmbracePublicApiPackageRule"})
public final class Embrace
implements LogsApi,
MomentsApi,
NetworkRequestApi,
SessionApi,
UserApi,
TracingApi,
EmbraceApi,
EmbraceAndroidApi,
SdkStateApi,
OTelApi {
    @NonNull
    private static final Embrace embrace = new Embrace();
    private static EmbraceImpl impl = (EmbraceImpl)Systrace.traceSynchronous("embrace-impl-init", EmbraceImpl::new);
    static final String NULL_PARAMETER_ERROR_MESSAGE_TEMPLATE = " cannot be invoked because it contains null parameters";

    @NonNull
    public static Embrace getInstance() {
        return embrace;
    }

    @NonNull
    static EmbraceImpl getImpl() {
        return impl;
    }

    static void setImpl(@Nullable EmbraceImpl instance) {
        impl = instance;
    }

    Embrace() {
    }

    @Override
    public void start(@NonNull Context context2) {
        if (this.verifyNonNullParameters("start", context2)) {
            this.start(context2, AppFramework.NATIVE);
        }
    }

    @Override
    public void start(@NonNull Context context2, @NonNull AppFramework appFramework2) {
        if (this.verifyNonNullParameters("start", new Object[]{context2, appFramework2})) {
            impl.start(context2, appFramework2, (Function0<? extends ConfigService>)((Function0)() -> null));
        }
    }

    @Override
    @Deprecated
    public void start(@NonNull Context context2, boolean isDevMode) {
        if (this.verifyNonNullParameters("start", context2)) {
            this.start(context2);
        }
    }

    @Override
    @Deprecated
    public void start(@NonNull Context context2, boolean isDevMode, @NonNull AppFramework appFramework2) {
        if (this.verifyNonNullParameters("start", new Object[]{context2, appFramework2})) {
            impl.start(context2, appFramework2, (Function0<? extends ConfigService>)((Function0)() -> null));
        }
    }

    @Override
    public boolean isStarted() {
        return impl.isStarted();
    }

    @Override
    public boolean setAppId(@NonNull String appId2) {
        if (this.verifyNonNullParameters("setAppId", appId2)) {
            return impl.setAppId(appId2);
        }
        return false;
    }

    @Override
    public void setUserIdentifier(@Nullable String userId) {
        impl.setUserIdentifier(userId);
    }

    @Override
    public void clearUserIdentifier() {
        impl.clearUserIdentifier();
    }

    @Override
    public void setUserEmail(@Nullable String email) {
        impl.setUserEmail(email);
    }

    @Override
    public void clearUserEmail() {
        impl.clearUserEmail();
    }

    @Override
    public void setUserAsPayer() {
        impl.setUserAsPayer();
    }

    @Override
    public void clearUserAsPayer() {
        impl.clearUserAsPayer();
    }

    @Override
    public void addUserPersona(@NonNull String persona) {
        if (this.verifyNonNullParameters("addUserPersona", persona)) {
            impl.addUserPersona(persona);
        }
    }

    @Override
    public void clearUserPersona(@NonNull String persona) {
        if (this.verifyNonNullParameters("clearUserPersona", persona)) {
            impl.clearUserPersona(persona);
        }
    }

    @Override
    public void clearAllUserPersonas() {
        impl.clearAllUserPersonas();
    }

    @Override
    public boolean addSessionProperty(@NonNull String key, @NonNull String value, boolean permanent) {
        if (this.verifyNonNullParameters("addSessionProperty", key, value)) {
            return impl.addSessionProperty(key, value, permanent);
        }
        return false;
    }

    @Override
    public boolean removeSessionProperty(@NonNull String key) {
        if (this.verifyNonNullParameters("removeSessionProperty", key)) {
            return impl.removeSessionProperty(key);
        }
        return false;
    }

    @Override
    @Nullable
    public Map<String, String> getSessionProperties() {
        return impl.getSessionProperties();
    }

    @Override
    public void setUsername(@Nullable String username) {
        impl.setUsername(username);
    }

    @Override
    public void clearUsername() {
        impl.clearUsername();
    }

    @Override
    public void startMoment(@NonNull String name) {
        if (this.verifyNonNullParameters("startMoment", name)) {
            this.startMoment(name, null);
        }
    }

    @Override
    public void startMoment(@NonNull String name, @Nullable String identifier) {
        if (this.verifyNonNullParameters("startMoment", name)) {
            this.startMoment(name, identifier, (Map<String, ?>)null);
        }
    }

    public void startMoment(@NonNull String name, @Nullable String identifier, @Nullable Map<String, ?> properties) {
        if (this.verifyNonNullParameters("startMoment", name)) {
            impl.startMoment(name, identifier, properties);
        }
    }

    @Override
    public void endMoment(@NonNull String name) {
        if (this.verifyNonNullParameters("endMoment", name)) {
            this.endMoment(name, (String)null, (Map<String, ?>)null);
        }
    }

    @Override
    public void endMoment(@NonNull String name, @Nullable String identifier) {
        if (this.verifyNonNullParameters("endMoment", name)) {
            this.endMoment(name, identifier, (Map<String, ?>)null);
        }
    }

    public void endMoment(@NonNull String name, @Nullable Map<String, ?> properties) {
        if (this.verifyNonNullParameters("endMoment", name)) {
            this.endMoment(name, (String)null, properties);
        }
    }

    public void endMoment(@NonNull String name, @Nullable String identifier, @Nullable Map<String, ?> properties) {
        if (this.verifyNonNullParameters("endMoment", name)) {
            impl.endMoment(name, identifier, properties);
        }
    }

    @Override
    public void endAppStartup() {
        impl.endAppStartup();
    }

    public void endAppStartup(@NonNull Map<String, ?> properties) {
        if (this.verifyNonNullParameters("endAppStartup", properties)) {
            impl.endAppStartup(properties);
        }
    }

    @Override
    @NonNull
    public String getTraceIdHeader() {
        return impl.getTraceIdHeader();
    }

    @Override
    @NonNull
    public String generateW3cTraceparent() {
        return impl.generateW3cTraceparent();
    }

    @Override
    public void recordNetworkRequest(@NonNull EmbraceNetworkRequest networkRequest) {
        if (this.verifyNonNullParameters("recordNetworkRequest", networkRequest)) {
            impl.recordNetworkRequest(networkRequest);
        }
    }

    @Override
    public void logInfo(@NonNull String message) {
        if (this.verifyNonNullParameters("logInfo", message)) {
            impl.logInfo(message);
        }
    }

    @Override
    public void logWarning(@NonNull String message) {
        if (this.verifyNonNullParameters("logWarning", message)) {
            impl.logWarning(message);
        }
    }

    @Override
    public void logError(@NonNull String message) {
        if (this.verifyNonNullParameters("logError", message)) {
            impl.logError(message);
        }
    }

    @Override
    public void addBreadcrumb(@NonNull String message) {
        if (this.verifyNonNullParameters("addBreadcrumb", message)) {
            impl.addBreadcrumb(message);
        }
    }

    @Override
    public void logMessage(@NonNull String message, @NonNull Severity severity) {
        if (this.verifyNonNullParameters("logMessage", new Object[]{message, severity})) {
            impl.logMessage(message, severity);
        }
    }

    public void logMessage(@NonNull String message, @NonNull Severity severity, @Nullable Map<String, ?> properties) {
        if (this.verifyNonNullParameters("logMessage", new Object[]{message, severity})) {
            impl.logMessage(message, severity, properties);
        }
    }

    @Override
    public void logException(@NonNull Throwable throwable) {
        if (this.verifyNonNullParameters("logException", throwable)) {
            impl.logException(throwable);
        }
    }

    @Override
    public void logException(@NonNull Throwable throwable, @NonNull Severity severity) {
        if (this.verifyNonNullParameters("logException", new Object[]{throwable, severity})) {
            impl.logException(throwable, severity);
        }
    }

    public void logException(@NonNull Throwable throwable, @NonNull Severity severity, @Nullable Map<String, ?> properties) {
        if (this.verifyNonNullParameters("logException", new Object[]{throwable, severity})) {
            impl.logException(throwable, severity, properties);
        }
    }

    public void logException(@NonNull Throwable throwable, @NonNull Severity severity, @Nullable Map<String, ?> properties, @Nullable String message) {
        if (this.verifyNonNullParameters("logException", new Object[]{throwable, severity})) {
            impl.logException(throwable, severity, properties, message);
        }
    }

    @Override
    public void logCustomStacktrace(@NonNull StackTraceElement[] stacktraceElements) {
        if (this.verifyNonNullParameters("logCustomStacktrace", new Object[]{stacktraceElements})) {
            impl.logCustomStacktrace(stacktraceElements);
        }
    }

    @Override
    public void logCustomStacktrace(@NonNull StackTraceElement[] stacktraceElements, @NonNull Severity severity) {
        if (this.verifyNonNullParameters("logCustomStacktrace", new Object[]{stacktraceElements, severity})) {
            impl.logCustomStacktrace(stacktraceElements, severity);
        }
    }

    public void logCustomStacktrace(@NonNull StackTraceElement[] stacktraceElements, @NonNull Severity severity, @Nullable Map<String, ?> properties) {
        if (this.verifyNonNullParameters("logCustomStacktrace", new Object[]{stacktraceElements, severity})) {
            impl.logCustomStacktrace(stacktraceElements, severity, properties);
        }
    }

    public void logCustomStacktrace(@NonNull StackTraceElement[] stacktraceElements, @NonNull Severity severity, @Nullable Map<String, ?> properties, @Nullable String message) {
        if (this.verifyNonNullParameters("logCustomStacktrace", new Object[]{stacktraceElements, severity})) {
            impl.logCustomStacktrace(stacktraceElements, severity, properties, message);
        }
    }

    @Override
    public synchronized void endSession() {
        this.endSession(false);
    }

    @Override
    public synchronized void endSession(boolean clearUserInfo) {
        impl.endSession(clearUserInfo);
    }

    @Override
    @NonNull
    public String getDeviceId() {
        return impl.getDeviceId();
    }

    @Override
    public boolean startView(@NonNull String name) {
        if (this.verifyNonNullParameters("startView", name)) {
            return impl.startView(name);
        }
        return false;
    }

    @Override
    public boolean endView(@NonNull String name) {
        if (this.verifyNonNullParameters("endView", name)) {
            return impl.endView(name);
        }
        return false;
    }

    @Override
    public boolean isTracingAvailable() {
        return impl.isTracingAvailable();
    }

    @Override
    @Nullable
    public EmbraceSpan createSpan(@NonNull String name) {
        if (this.verifyNonNullParameters("createSpan", name)) {
            return impl.createSpan(name);
        }
        return null;
    }

    @Override
    @Nullable
    public EmbraceSpan createSpan(@NonNull String name, @Nullable EmbraceSpan parent) {
        if (this.verifyNonNullParameters("createSpan", name)) {
            return impl.createSpan(name, parent);
        }
        return null;
    }

    @Override
    @Nullable
    public EmbraceSpan startSpan(@NonNull String name) {
        return this.startSpan(name, null, null);
    }

    @Override
    @Nullable
    public EmbraceSpan startSpan(@NonNull String name, @Nullable EmbraceSpan parent) {
        return this.startSpan(name, parent, null);
    }

    @Override
    @Nullable
    public EmbraceSpan startSpan(@NonNull String name, @Nullable EmbraceSpan parent, @Nullable Long startTimeMs) {
        if (this.verifyNonNullParameters("startSpan", name)) {
            return impl.startSpan(name, parent, startTimeMs);
        }
        return null;
    }

    @Override
    public <T> T recordSpan(@NonNull String name, @NonNull Function0<? extends T> code) {
        return this.recordSpan(name, null, null, null, code);
    }

    @Override
    public <T> T recordSpan(@NonNull String name, @Nullable EmbraceSpan parent, @NonNull Function0<? extends T> code) {
        return this.recordSpan(name, parent, null, null, code);
    }

    @Override
    public <T> T recordSpan(@NonNull String name, @Nullable Map<String, String> attributes, @Nullable List<EmbraceSpanEvent> events, @NonNull Function0<? extends T> code) {
        return this.recordSpan(name, null, attributes, events, code);
    }

    @Override
    public <T> T recordSpan(@NonNull String name, @Nullable EmbraceSpan parent, @Nullable Map<String, String> attributes, @Nullable List<EmbraceSpanEvent> events, @NonNull Function0<? extends T> code) {
        if (this.verifyNonNullParameters("recordSpan", name, code)) {
            return impl.recordSpan(name, parent, attributes, events, code);
        }
        return (T)(code != null ? code.invoke() : null);
    }

    @Override
    public boolean recordCompletedSpan(@NonNull String name, long startTimeMs, long endTimeMs, @Nullable ErrorCode errorCode, @Nullable EmbraceSpan parent, @Nullable Map<String, String> attributes, @Nullable List<EmbraceSpanEvent> events) {
        if (this.verifyNonNullParameters("recordCompletedSpan", name)) {
            return impl.recordCompletedSpan(name, startTimeMs, endTimeMs, errorCode, parent, attributes, events);
        }
        return false;
    }

    @Override
    public boolean recordCompletedSpan(@NonNull String name, long startTimeMs, long endTimeMs) {
        return this.recordCompletedSpan(name, startTimeMs, endTimeMs, null, null, null, null);
    }

    @Override
    public boolean recordCompletedSpan(@NonNull String name, long startTimeMs, long endTimeMs, @Nullable ErrorCode errorCode) {
        return this.recordCompletedSpan(name, startTimeMs, endTimeMs, errorCode, null, null, null);
    }

    @Override
    public boolean recordCompletedSpan(@NonNull String name, long startTimeMs, long endTimeMs, @Nullable EmbraceSpan parent) {
        return this.recordCompletedSpan(name, startTimeMs, endTimeMs, null, parent, null, null);
    }

    @Override
    public boolean recordCompletedSpan(@NonNull String name, long startTimeMs, long endTimeMs, @Nullable ErrorCode errorCode, @Nullable EmbraceSpan parent) {
        return this.recordCompletedSpan(name, startTimeMs, endTimeMs, errorCode, parent, null, null);
    }

    @Override
    public boolean recordCompletedSpan(@NonNull String name, long startTimeMs, long endTimeMs, @Nullable Map<String, String> attributes, @Nullable List<EmbraceSpanEvent> events) {
        return this.recordCompletedSpan(name, startTimeMs, endTimeMs, null, null, attributes, events);
    }

    @Override
    @Nullable
    public EmbraceSpan getSpan(@NonNull String spanId) {
        if (this.verifyNonNullParameters("getSpan", spanId)) {
            return impl.getSpan(spanId);
        }
        return null;
    }

    @Override
    public void addSpanExporter(@NonNull SpanExporter spanExporter) {
        if (this.verifyNonNullParameters("addSpanExporter", spanExporter)) {
            impl.addSpanExporter(spanExporter);
        }
    }

    @Override
    @NonNull
    public OpenTelemetry getOpenTelemetry() {
        return impl.getOpenTelemetry();
    }

    @Override
    public void addLogRecordExporter(@NonNull LogRecordExporter logRecordExporter) {
        if (this.verifyNonNullParameters("addLogRecordExporter", logRecordExporter)) {
            impl.addLogRecordExporter(logRecordExporter);
        }
    }

    @Override
    public void logPushNotification(@Nullable String title, @Nullable String body, @Nullable String topic, @Nullable String id, @Nullable Integer notificationPriority, @NonNull Integer messageDeliveredPriority, @NonNull Boolean isNotification, @NonNull Boolean hasData) {
        if (this.verifyNonNullParameters("logPushNotification", messageDeliveredPriority, isNotification, hasData)) {
            impl.logPushNotification(title, body, topic, id, notificationPriority, messageDeliveredPriority, isNotification, hasData);
        }
    }

    @Override
    public void trackWebViewPerformance(@NonNull String tag, @NonNull ConsoleMessage consoleMessage) {
        if (this.verifyNonNullParameters("trackWebViewPerformance", tag, consoleMessage) && consoleMessage.message() != null) {
            this.trackWebViewPerformance(tag, consoleMessage.message());
        }
    }

    @Override
    public void trackWebViewPerformance(@NonNull String tag, @NonNull String message) {
        if (this.verifyNonNullParameters("trackWebViewPerformance", tag, message)) {
            impl.trackWebViewPerformance(tag, message);
        }
    }

    @Override
    @Nullable
    public String getCurrentSessionId() {
        return impl.getCurrentSessionId();
    }

    @Override
    @NonNull
    public LastRunEndState getLastRunEndState() {
        return impl.getLastRunEndState();
    }

    @InternalApi
    @NonNull
    public EmbraceInternalInterface getInternalInterface() {
        return impl.getEmbraceInternalInterface();
    }

    @InternalApi
    @Nullable
    public ReactNativeInternalInterface getReactNativeInternalInterface() {
        return impl.getReactNativeInternalInterface();
    }

    @InternalApi
    @Nullable
    public UnityInternalInterface getUnityInternalInterface() {
        return impl.getUnityInternalInterface();
    }

    @InternalApi
    @Nullable
    public FlutterInternalInterface getFlutterInternalInterface() {
        return impl.getFlutterInternalInterface();
    }

    private boolean verifyNonNullParameters(@NonNull String functionName, Object ... params) {
        for (Object param : params) {
            if (param != null) continue;
            String errorMessage = functionName + NULL_PARAMETER_ERROR_MESSAGE_TEMPLATE;
            if (this.isStarted()) {
                impl.getEmbraceInternalInterface().logInternalError(new IllegalArgumentException(errorMessage));
            }
            return false;
        }
        return true;
    }

    public static enum AppFramework {
        NATIVE(1),
        REACT_NATIVE(2),
        UNITY(3),
        FLUTTER(4);

        private final int value;

        private AppFramework(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum LastRunEndState {
        INVALID(0),
        CRASH(1),
        CLEAN_EXIT(2);

        private final int value;

        private LastRunEndState(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

