/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.Application;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.widget.Toast;
import io.embrace.android.embracesdk.Embrace;
import io.embrace.android.embracesdk.EmbraceAutomaticVerification;
import io.embrace.android.embracesdk.R;
import io.embrace.android.embracesdk.capture.internal.errors.InternalErrorService;
import io.embrace.android.embracesdk.capture.metadata.MetadataService;
import io.embrace.android.embracesdk.samples.AutomaticVerificationChecker;
import io.embrace.android.embracesdk.samples.VerificationActions;
import io.embrace.android.embracesdk.samples.VerifyIntegrationException;
import io.embrace.android.embracesdk.session.lifecycle.ActivityTracker;
import io.embrace.android.embracesdk.session.lifecycle.ProcessStateListener;
import io.embrace.android.embracesdk.session.lifecycle.ProcessStateService;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0003\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\b\u0000\u0018\u0000 C2\u00020\u0001:\u0001CB\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\"\u001a\u00020#H\u0002J\b\u0010$\u001a\u00020#H\u0002J\u0010\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020&H\u0002J\u0010\u0010(\u001a\u00020#2\u0006\u0010)\u001a\u00020&H\u0002J\u0010\u0010*\u001a\u00020#2\u0006\u0010)\u001a\u00020&H\u0002J\u001c\u0010+\u001a\u00020#2\u0006\u0010,\u001a\u00020-2\n\b\u0002\u0010)\u001a\u0004\u0018\u00010&H\u0002J\u0010\u0010.\u001a\u00020#2\u0006\u0010)\u001a\u00020&H\u0002J\u0018\u0010/\u001a\u00020#2\u0006\u00100\u001a\u00020\u00122\u0006\u00101\u001a\u000202H\u0016J\u0006\u00103\u001a\u00020#J\u0006\u00104\u001a\u00020#J\b\u00105\u001a\u00020#H\u0002J\u0018\u00106\u001a\u00020#2\u0006\u00107\u001a\u0002082\u0006\u0010'\u001a\u00020&H\u0002J\u0006\u00109\u001a\u00020#J\u0019\u0010:\u001a\u00020#2\n\b\u0002\u0010'\u001a\u0004\u0018\u00010;H\u0002\u00a2\u0006\u0002\u0010<J\b\u0010=\u001a\u00020#H\u0002J\u0018\u0010>\u001a\u00020#2\u0006\u00107\u001a\u0002082\u0006\u0010)\u001a\u00020&H\u0002J\u0006\u0010?\u001a\u00020#J\b\u0010@\u001a\u00020\u0012H\u0002J\u0006\u0010A\u001a\u00020#J\b\u0010B\u001a\u00020#H\u0002R\u001a\u0010\u0005\u001a\u00020\u0006X\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\u00020\u0017X\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001c\u001a\u00020\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!\u00a8\u0006D"}, d2={"Lio/embrace/android/embracesdk/EmbraceAutomaticVerification;", "Lio/embrace/android/embracesdk/session/lifecycle/ProcessStateListener;", "scheduledExecutorService", "Ljava/util/concurrent/ScheduledExecutorService;", "(Ljava/util/concurrent/ScheduledExecutorService;)V", "activityLifecycleTracker", "Lio/embrace/android/embracesdk/session/lifecycle/ActivityTracker;", "getActivityLifecycleTracker$embrace_android_sdk_release", "()Lio/embrace/android/embracesdk/session/lifecycle/ActivityTracker;", "setActivityLifecycleTracker$embrace_android_sdk_release", "(Lio/embrace/android/embracesdk/session/lifecycle/ActivityTracker;)V", "automaticVerificationChecker", "Lio/embrace/android/embracesdk/samples/AutomaticVerificationChecker;", "getAutomaticVerificationChecker", "()Lio/embrace/android/embracesdk/samples/AutomaticVerificationChecker;", "setAutomaticVerificationChecker", "(Lio/embrace/android/embracesdk/samples/AutomaticVerificationChecker;)V", "foregroundEventTriggered", "", "handler", "Landroid/os/Handler;", "isResultDisplayed", "processStateService", "Lio/embrace/android/embracesdk/session/lifecycle/ProcessStateService;", "getProcessStateService$embrace_android_sdk_release", "()Lio/embrace/android/embracesdk/session/lifecycle/ProcessStateService;", "setProcessStateService$embrace_android_sdk_release", "(Lio/embrace/android/embracesdk/session/lifecycle/ProcessStateService;)V", "verificationActions", "Lio/embrace/android/embracesdk/samples/VerificationActions;", "getVerificationActions", "()Lio/embrace/android/embracesdk/samples/VerificationActions;", "setVerificationActions", "(Lio/embrace/android/embracesdk/samples/VerificationActions;)V", "clearUserData", "", "displayResult", "generateErrorLog", "", "errorMessage", "logError", "message", "logInfo", "logInternalError", "t", "", "logWarning", "onForeground", "coldStart", "timestamp", "", "restartAppFromPendingIntent", "runEndSession", "runVerifyIntegration", "sendErrorLog", "activity", "Landroid/app/Activity;", "setActivityListener", "showDialogWithError", "", "(Ljava/lang/Integer;)V", "showSuccessDialog", "showToast", "startVerification", "verifyIfInitializerIsDisabled", "verifyIntegration", "verifyLifecycle", "Companion", "embrace-android-sdk_release"})
public final class EmbraceAutomaticVerification
implements ProcessStateListener {
    private final Handler handler;
    private boolean foregroundEventTriggered;
    public ActivityTracker activityLifecycleTracker;
    public ProcessStateService processStateService;
    @NotNull
    private AutomaticVerificationChecker automaticVerificationChecker;
    @NotNull
    private VerificationActions verificationActions;
    private boolean isResultDisplayed;
    private final ScheduledExecutorService scheduledExecutorService;
    @NotNull
    public static final String TAG = "[EmbraceVerification]";
    private static final long ON_FOREGROUND_DELAY = 5000L;
    private static final String EMBRACE_CONTACT_EMAIL = "support@embrace.io";
    private static final long VERIFY_INTEGRATION_DELAY = 200L;
    private static final long ON_FOREGROUND_TIMEOUT = 5000L;
    @NotNull
    private static final EmbraceAutomaticVerification instance;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public final ActivityTracker getActivityLifecycleTracker$embrace_android_sdk_release() {
        ActivityTracker activityTracker = this.activityLifecycleTracker;
        if (activityTracker == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"activityLifecycleTracker");
        }
        return activityTracker;
    }

    public final void setActivityLifecycleTracker$embrace_android_sdk_release(@NotNull ActivityTracker activityTracker) {
        Intrinsics.checkNotNullParameter((Object)activityTracker, (String)"<set-?>");
        this.activityLifecycleTracker = activityTracker;
    }

    @NotNull
    public final ProcessStateService getProcessStateService$embrace_android_sdk_release() {
        ProcessStateService processStateService2 = this.processStateService;
        if (processStateService2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"processStateService");
        }
        return processStateService2;
    }

    public final void setProcessStateService$embrace_android_sdk_release(@NotNull ProcessStateService processStateService2) {
        Intrinsics.checkNotNullParameter((Object)processStateService2, (String)"<set-?>");
        this.processStateService = processStateService2;
    }

    @NotNull
    public final AutomaticVerificationChecker getAutomaticVerificationChecker() {
        return this.automaticVerificationChecker;
    }

    public final void setAutomaticVerificationChecker(@NotNull AutomaticVerificationChecker automaticVerificationChecker) {
        Intrinsics.checkNotNullParameter((Object)automaticVerificationChecker, (String)"<set-?>");
        this.automaticVerificationChecker = automaticVerificationChecker;
    }

    @NotNull
    public final VerificationActions getVerificationActions() {
        return this.verificationActions;
    }

    public final void setVerificationActions(@NotNull VerificationActions verificationActions) {
        Intrinsics.checkNotNullParameter((Object)verificationActions, (String)"<set-?>");
        this.verificationActions = verificationActions;
    }

    public final void verifyIntegration() {
        instance.setActivityListener();
        instance.runVerifyIntegration();
    }

    public final void setActivityListener() {
        boolean bl;
        boolean bl2;
        Closeable closeable;
        if (this.activityLifecycleTracker == null) {
            closeable = Embrace.getImpl().getActivityLifecycleTracker();
            bl2 = false;
            bl = false;
            if (closeable == null) {
                String string = "Required value was null.";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            this.activityLifecycleTracker = closeable;
        }
        if (this.processStateService == null) {
            closeable = Embrace.getImpl().getActivityService();
            bl2 = false;
            bl = false;
            if (closeable == null) {
                String string = "Required value was null.";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            this.processStateService = closeable;
        }
        ProcessStateService processStateService2 = this.processStateService;
        if (processStateService2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"processStateService");
        }
        processStateService2.addListener(this);
    }

    private final void runVerifyIntegration() {
        try {
            this.scheduledExecutorService.schedule(new Runnable(this){
                final /* synthetic */ EmbraceAutomaticVerification this$0;

                public final void run() {
                    this.this$0.startVerification();
                }
                {
                    this.this$0 = embraceAutomaticVerification;
                }
            }, 200L, TimeUnit.MILLISECONDS);
        }
        catch (RejectedExecutionException e) {
            this.logInternalError(e, "Start verification rejected");
        }
    }

    public final void startVerification() {
        block6: {
            Activity activity;
            ActivityTracker activityTracker = this.activityLifecycleTracker;
            if (activityTracker == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"activityLifecycleTracker");
            }
            if ((activity = activityTracker.getForegroundActivity()) != null) {
                try {
                    if (this.automaticVerificationChecker.createFile(activity)) {
                        String string2 = activity.getString(R.string.automatic_verification_started);
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"activity.getString(R.str\u2026tic_verification_started)");
                        this.showToast(activity, string2);
                        this.verificationActions.runActions();
                        break block6;
                    }
                    this.logInfo("Verification almost ready...");
                    this.handler.postDelayed(new Runnable(this){
                        final /* synthetic */ EmbraceAutomaticVerification this$0;

                        public final void run() {
                            EmbraceAutomaticVerification.access$verifyLifecycle(this.this$0);
                        }
                        {
                            this.this$0 = embraceAutomaticVerification;
                        }
                    }, 5000L);
                }
                catch (IOException e) {
                    this.logInternalError(e, "Embrace SDK cannot run the verification in this moment");
                    String string3 = activity.getString(R.string.automatic_verification_not_started);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"activity.getString(R.str\u2026verification_not_started)");
                    this.showToast(activity, string3);
                }
            } else {
                this.logError("Embrace SDK cannot run the verification in this moment, Activity is not present");
            }
        }
    }

    private final void verifyLifecycle() {
        if (!this.foregroundEventTriggered) {
            this.logError("OnForeground event was not triggered");
            InternalErrorService internalErrorService2 = Embrace.getImpl().getInternalErrorService();
            boolean bl = false;
            boolean bl2 = false;
            if (internalErrorService2 == null) {
                String string2 = "Required value was null.";
                throw (Throwable)new IllegalStateException(string2.toString());
            }
            InternalErrorService exceptionsService = internalErrorService2;
            if (this.verifyIfInitializerIsDisabled()) {
                exceptionsService.handleInternalError(new VerifyIntegrationException("ProcessLifecycleInitializer disabled"));
                this.showDialogWithError(R.string.automatic_verification_no_initializer_message);
            } else {
                exceptionsService.handleInternalError(new VerifyIntegrationException("onForeground not invoked"));
                this.showDialogWithError(R.string.automatic_verification_lifecycle_error_message);
            }
        }
    }

    public final void runEndSession() {
        Embrace.getInstance().endSession();
        this.logInfo("End session manually");
    }

    private final boolean verifyIfInitializerIsDisabled() {
        this.logInfo("Trying to verify lifecycle annotations");
        try {
            EmbraceAutomaticVerification embraceAutomaticVerification;
            Class<?> appInitializerClass = null;
            try {
                appInitializerClass = Class.forName("androidx.startup.AppInitializer");
            }
            catch (ClassNotFoundException cnfe) {
                return false;
            }
            Application application2 = Embrace.getImpl().getApplication();
            if (application2 != null) {
                Application application3;
                Application app = application3 = application2;
                boolean bl = false;
                Method getInstance = appInitializerClass.getMethod("getInstance", Context.class);
                Method isEagerlyInitialized = appInitializerClass.getMethod("isEagerlyInitialized", Class.class);
                Class<?> lifecycleInitializerClass = Class.forName("androidx.lifecycle.ProcessLifecycleInitializer");
                Object appInitializer = getInstance.invoke(null, app);
                Object object = isEagerlyInitialized.invoke(appInitializer, lifecycleInitializerClass);
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Boolean");
                }
                boolean result = (Boolean)object;
                return !result;
            }
            EmbraceAutomaticVerification $this$run = embraceAutomaticVerification = this;
            boolean bl = false;
            return false;
        }
        catch (Exception e) {
            this.logWarning("Could not verify if lifecycle annotations are working: " + e);
            return false;
        }
    }

    public final void restartAppFromPendingIntent() {
        Activity activity;
        int exitStatus = 2;
        ActivityTracker activityTracker = this.activityLifecycleTracker;
        if (activityTracker == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"activityLifecycleTracker");
        }
        if ((activity = activityTracker.getForegroundActivity()) != null) {
            Intent intent = activity.getIntent();
            intent.addFlags(0x10008000);
            intent.putExtra("from_verification", true);
            Activity $this$with = activity;
            boolean bl = false;
            $this$with.finish();
            $this$with.startActivity(intent);
            System.exit(exitStatus);
            throw (Throwable)new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
        this.logError("Cannot restart app, activity is not present");
    }

    @Override
    public void onForeground(boolean coldStart, long timestamp) {
        Activity activity;
        this.foregroundEventTriggered = true;
        ActivityTracker activityTracker = this.activityLifecycleTracker;
        if (activityTracker == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"activityLifecycleTracker");
        }
        if ((activity = activityTracker.getForegroundActivity()) != null) {
            boolean fromVerification = activity.getIntent().getBooleanExtra("from_verification", false);
            if (!fromVerification) {
                return;
            }
            if (this.isResultDisplayed) {
                this.logInfo("onForeground called but the result was already displayed");
                return;
            }
            this.handler.postDelayed(new Runnable(this){
                final /* synthetic */ EmbraceAutomaticVerification this$0;

                public final void run() {
                    this.this$0.runEndSession();
                    EmbraceAutomaticVerification.access$displayResult(this.this$0);
                    EmbraceAutomaticVerification.access$clearUserData(this.this$0);
                    this.this$0.getAutomaticVerificationChecker().deleteFile();
                }
                {
                    this.this$0 = embraceAutomaticVerification;
                }
            }, 5000L);
        } else {
            this.logError("Cannot restart app, activity is not present");
        }
    }

    private final void clearUserData() {
        Embrace.getInstance().clearUserEmail();
        Embrace.getInstance().clearUsername();
        Embrace.getInstance().clearAllUserPersonas();
        Embrace.getInstance().clearUserIdentifier();
        Embrace.getInstance().clearUserAsPayer();
    }

    private final void displayResult() {
        block6: {
            Boolean bl;
            block5: {
                this.isResultDisplayed = true;
                bl = this.automaticVerificationChecker.isVerificationCorrect();
                if (bl == null) break block5;
                Boolean bl2 = bl;
                boolean isCorrect = bl2;
                boolean bl3 = false;
                if (isCorrect) {
                    this.logInfo("Successful - Embrace is ready to go! \ud83c\udf89");
                    this.showSuccessDialog();
                } else {
                    this.logError("Error - Something is wrong with the Embrace Configuration \u26a0\ufe0f");
                    EmbraceAutomaticVerification.showDialogWithError$default(this, null, 1, null);
                }
                if ((bl = bl2) != null) break block6;
            }
            this.logError("Cannot display end message");
            bl = Unit.INSTANCE;
        }
    }

    private final void showToast(Activity activity, String message) {
        activity.runOnUiThread(new Runnable(activity, message){
            final /* synthetic */ Activity $activity;
            final /* synthetic */ String $message;

            public final void run() {
                Toast.makeText((Context)((Context)this.$activity), (CharSequence)this.$message, (int)1).show();
            }
            {
                this.$activity = activity;
                this.$message = string2;
            }
        });
    }

    private final void showSuccessDialog() {
        Activity activity;
        ActivityTracker activityTracker = this.activityLifecycleTracker;
        if (activityTracker == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"activityLifecycleTracker");
        }
        if ((activity = activityTracker.getForegroundActivity()) != null) {
            AlertDialog.Builder dialogBuilder = new AlertDialog.Builder((Context)activity);
            dialogBuilder.setTitle((CharSequence)activity.getString(R.string.automatic_verification_success_title)).setMessage((CharSequence)activity.getString(R.string.automatic_verification_success_message)).setCancelable(true).setPositiveButton((CharSequence)activity.getString(R.string.got_it), (DialogInterface.OnClickListener)showSuccessDialog.1.INSTANCE);
            dialogBuilder.create().show();
        } else {
            this.logInfo("Verification success!");
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void showDialogWithError(Integer errorMessage) {
        Activity activity;
        ActivityTracker activityTracker = this.activityLifecycleTracker;
        if (activityTracker == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"activityLifecycleTracker");
        }
        if ((activity = activityTracker.getForegroundActivity()) != null) {
            String string2;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = this.automaticVerificationChecker.getExceptions();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Throwable throwable = (Throwable)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String string3 = it.getMessage();
                collection.add(string3);
            }
            List exceptions = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
            if (errorMessage != null) {
                exceptions.add(activity.getString(errorMessage.intValue()));
            }
            if (!($i$f$map = (Collection)exceptions).isEmpty()) {
                String string4 = activity.getString(R.string.embrace_verification_errors);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"activity.getString(R.str\u2026race_verification_errors)");
                string2 = StringsKt.replace$default((String)string4, (String)"[X]", (String)CollectionsKt.joinToString$default((Iterable)exceptions, (CharSequence)"\n\ud83d\udc49 ", (CharSequence)"\ud83d\udc49 ", null, (int)0, null, null, (int)60, null), (boolean)false, (int)4, null);
            } else {
                String string5 = activity.getString(R.string.automatic_verification_default_error_message);
                string2 = string5;
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"activity.getString(R.str\u2026on_default_error_message)");
            }
            String errorString = string2;
            AlertDialog.Builder dialogBuilder = new AlertDialog.Builder((Context)activity);
            dialogBuilder.setTitle((CharSequence)activity.getString(R.string.automatic_verification_error_title)).setMessage((CharSequence)errorString).setCancelable(true).setNegativeButton((CharSequence)activity.getString(R.string.send_error_log), new DialogInterface.OnClickListener(this, activity, errorString){
                final /* synthetic */ EmbraceAutomaticVerification this$0;
                final /* synthetic */ Activity $activity;
                final /* synthetic */ String $errorString;

                public final void onClick(DialogInterface dialog, int $noName_1) {
                    EmbraceAutomaticVerification.access$sendErrorLog(this.this$0, this.$activity, this.$errorString);
                    dialog.dismiss();
                }
                {
                    this.this$0 = embraceAutomaticVerification;
                    this.$activity = activity;
                    this.$errorString = string2;
                }
            }).setPositiveButton((CharSequence)activity.getString(R.string.close), (DialogInterface.OnClickListener)showDialogWithError.2.INSTANCE);
            dialogBuilder.create().show();
        } else {
            this.logError("Verification error - Cannot display popup");
        }
    }

    static /* synthetic */ void showDialogWithError$default(EmbraceAutomaticVerification embraceAutomaticVerification, Integer n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = null;
        }
        embraceAutomaticVerification.showDialogWithError(n);
    }

    private final void sendErrorLog(Activity activity, String errorMessage) {
        Intent intent;
        String errorLog = this.generateErrorLog(errorMessage);
        Intent intent2 = new Intent("android.intent.action.SENDTO").setData(Uri.parse((String)"mailto:support@embrace.io"));
        Intrinsics.checkNotNullExpressionValue((Object)intent2, (String)"Intent(Intent.ACTION_SEN\u2026$EMBRACE_CONTACT_EMAIL\"))");
        Intent selectorIntent = intent2;
        Intent $this$apply = intent = new Intent("android.intent.action.SEND");
        boolean bl = false;
        $this$apply.putExtra("android.intent.extra.EMAIL", new String[]{EMBRACE_CONTACT_EMAIL});
        $this$apply.putExtra("android.intent.extra.SUBJECT", "Android Verification Log");
        $this$apply.putExtra("android.intent.extra.TEXT", errorLog);
        $this$apply.setSelector(selectorIntent);
        Intent emailIntent = intent;
        activity.startActivity(Intent.createChooser((Intent)emailIntent, (CharSequence)"Send Email"));
    }

    private final String generateErrorLog(String errorMessage) {
        MetadataService metadataService2 = Embrace.getImpl().getMetadataService();
        MetadataService metadataService3 = Embrace.getImpl().getMetadataService();
        String errorLog = "App ID: " + (metadataService2 != null ? metadataService2.getAppId() : null) + '\n' + "App Version: " + (metadataService3 != null ? metadataService3.getAppVersionName() : null);
        errorLog = errorLog + "\n\n-----------------\n\n";
        errorLog = errorLog + errorMessage;
        return errorLog;
    }

    private final void logInfo(String message) {
        Embrace embrace = Embrace.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)embrace, (String)"Embrace.getInstance()");
        embrace.getInternalInterface().logInfo("[EmbraceVerification] " + message, null);
    }

    private final void logWarning(String message) {
        Embrace embrace = Embrace.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)embrace, (String)"Embrace.getInstance()");
        embrace.getInternalInterface().logWarning("[EmbraceVerification] " + message, null, null);
    }

    private final void logError(String message) {
        Embrace embrace = Embrace.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)embrace, (String)"Embrace.getInstance()");
        embrace.getInternalInterface().logError("[EmbraceVerification] " + message, null, null, false);
    }

    private final void logInternalError(Throwable t, String message) {
        String string2 = message;
        if (string2 != null) {
            String string3;
            String it = string3 = string2;
            boolean bl = false;
            this.logError(message);
        }
        Embrace embrace = Embrace.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)embrace, (String)"Embrace.getInstance()");
        embrace.getInternalInterface().logInternalError(t);
    }

    static /* synthetic */ void logInternalError$default(EmbraceAutomaticVerification embraceAutomaticVerification, Throwable throwable, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        embraceAutomaticVerification.logInternalError(throwable, string);
    }

    public EmbraceAutomaticVerification(@NotNull ScheduledExecutorService scheduledExecutorService) {
        Intrinsics.checkNotNullParameter((Object)scheduledExecutorService, (String)"scheduledExecutorService");
        this.scheduledExecutorService = scheduledExecutorService;
        this.handler = new Handler(Looper.getMainLooper());
        this.automaticVerificationChecker = new AutomaticVerificationChecker();
        Embrace embrace = Embrace.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)embrace, (String)"Embrace.getInstance()");
        this.verificationActions = new VerificationActions(embrace, this.automaticVerificationChecker);
    }

    public /* synthetic */ EmbraceAutomaticVerification(ScheduledExecutorService scheduledExecutorService, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            ScheduledExecutorService scheduledExecutorService2 = Executors.newSingleThreadScheduledExecutor();
            Intrinsics.checkNotNullExpressionValue((Object)scheduledExecutorService2, (String)"Executors.newSingleThreadScheduledExecutor()");
            scheduledExecutorService = scheduledExecutorService2;
        }
        this(scheduledExecutorService);
    }

    public EmbraceAutomaticVerification() {
        this(null, 1, null);
    }

    static {
        Companion = new Companion(null);
        instance = new EmbraceAutomaticVerification(null, 1, null);
    }

    @Override
    public void onBackground(long timestamp) {
        ProcessStateListener.DefaultImpls.onBackground(this, timestamp);
    }

    public static final /* synthetic */ void access$verifyLifecycle(EmbraceAutomaticVerification $this) {
        $this.verifyLifecycle();
    }

    public static final /* synthetic */ void access$displayResult(EmbraceAutomaticVerification $this) {
        $this.displayResult();
    }

    public static final /* synthetic */ void access$clearUserData(EmbraceAutomaticVerification $this) {
        $this.clearUserData();
    }

    public static final /* synthetic */ void access$sendErrorLog(EmbraceAutomaticVerification $this, Activity activity, String errorMessage) {
        $this.sendErrorLog(activity, errorMessage);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lio/embrace/android/embracesdk/EmbraceAutomaticVerification$Companion;", "", "()V", "EMBRACE_CONTACT_EMAIL", "", "ON_FOREGROUND_DELAY", "", "ON_FOREGROUND_TIMEOUT", "TAG", "VERIFY_INTEGRATION_DELAY", "instance", "Lio/embrace/android/embracesdk/EmbraceAutomaticVerification;", "getInstance$embrace_android_sdk_release", "()Lio/embrace/android/embracesdk/EmbraceAutomaticVerification;", "embrace-android-sdk_release"})
    public static final class Companion {
        @NotNull
        public final EmbraceAutomaticVerification getInstance$embrace_android_sdk_release() {
            return instance;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

