/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.view.View;
import androidx.annotation.NonNull;
import io.embrace.android.embracesdk.Embrace;
import io.embrace.android.embracesdk.annotation.InternalApi;
import io.embrace.android.embracesdk.payload.TapBreadcrumb;
import kotlin.Pair;

@InternalApi
public final class ViewSwazzledHooks {
    private static final String UNKNOWN_ELEMENT_NAME = "Unknown element";

    private ViewSwazzledHooks() {
    }

    static void logOnClickEvent(View view, TapBreadcrumb.TapBreadcrumbType breadcrumbType) {
        try {
            String viewName = "";
            try {
                viewName = view.getResources().getResourceName(view.getId());
            }
            catch (Exception e) {
                viewName = UNKNOWN_ELEMENT_NAME;
            }
            Pair point = null;
            try {
                point = new Pair((Object)Float.valueOf(view.getX()), (Object)Float.valueOf(view.getY()));
            }
            catch (Exception e) {
                point = new Pair((Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.0f));
            }
            Embrace.getImpl().logTap((Pair<Float, Float>)point, viewName, breadcrumbType);
        }
        catch (NoSuchMethodError error) {
            ViewSwazzledHooks.logError(error);
        }
        catch (Exception exception) {
            ViewSwazzledHooks.logError(exception);
        }
    }

    private static void logError(@NonNull Throwable throwable) {
        Embrace.getInstance().getInternalInterface().logInternalError(throwable);
    }

    @InternalApi
    public static final class OnLongClickListener {
        private OnLongClickListener() {
        }

        public static void _preOnLongClick(View.OnLongClickListener thiz, View view) {
            if (thiz != null) {
                ViewSwazzledHooks.logOnClickEvent(view, TapBreadcrumb.TapBreadcrumbType.LONG_PRESS);
            }
        }
    }

    @InternalApi
    public static final class OnClickListener {
        private OnClickListener() {
        }

        public static void _preOnClick(View.OnClickListener thiz, View view) {
            ViewSwazzledHooks.logOnClickEvent(view, TapBreadcrumb.TapBreadcrumbType.TAP);
        }
    }
}

