/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk.anr;

import android.os.Looper;
import androidx.annotation.VisibleForTesting;
import io.embrace.android.embracesdk.anr.AnrService;
import io.embrace.android.embracesdk.anr.AnrStacktraceSampler;
import io.embrace.android.embracesdk.anr.BlockedThreadListener;
import io.embrace.android.embracesdk.anr.detection.LivenessCheckScheduler;
import io.embrace.android.embracesdk.anr.detection.ThreadMonitoringState;
import io.embrace.android.embracesdk.anr.detection.UnbalancedCallDetector;
import io.embrace.android.embracesdk.capture.internal.errors.InternalErrorType;
import io.embrace.android.embracesdk.config.ConfigService;
import io.embrace.android.embracesdk.internal.ThreadEnforcementCheckKt;
import io.embrace.android.embracesdk.internal.clock.Clock;
import io.embrace.android.embracesdk.logging.EmbLogger;
import io.embrace.android.embracesdk.payload.AnrInterval;
import io.embrace.android.embracesdk.session.MemoryCleanerListener;
import io.embrace.android.embracesdk.session.lifecycle.ProcessStateListener;
import io.embrace.android.embracesdk.worker.ScheduledWorker;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\t\b\u0000\u0018\u0000 >2\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004:\u0001>BK\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014\u00a2\u0006\u0002\u0010\u0016J\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u0004H\u0016J\b\u0010*\u001a\u00020(H\u0016J\b\u0010+\u001a\u00020(H\u0016J\u0010\u0010,\u001a\u00020(2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010-\u001a\u00020(H\u0016J\u000e\u0010.\u001a\b\u0012\u0004\u0012\u0002000/H\u0016J\u0010\u00101\u001a\u00020(2\u0006\u00102\u001a\u000203H\u0016J\u0018\u00104\u001a\u00020(2\u0006\u00105\u001a\u0002062\u0006\u00102\u001a\u000203H\u0016J\u0018\u00107\u001a\u00020(2\u0006\u00108\u001a\u00020\u00152\u0006\u00102\u001a\u000203H\u0016J\u0018\u00109\u001a\u00020(2\u0006\u00108\u001a\u00020\u00152\u0006\u00102\u001a\u000203H\u0016J\u0018\u0010:\u001a\u00020(2\u0006\u00108\u001a\u00020\u00152\u0006\u00102\u001a\u000203H\u0016J\u0015\u0010;\u001a\u00020(2\u0006\u00102\u001a\u000203H\u0000\u00a2\u0006\u0002\b<J\b\u0010=\u001a\u00020(H\u0002R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\u00020\u00128\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u0017\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00040\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010!\u001a\u00020\"\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lio/embrace/android/embracesdk/anr/EmbraceAnrService;", "Lio/embrace/android/embracesdk/anr/AnrService;", "Lio/embrace/android/embracesdk/session/MemoryCleanerListener;", "Lio/embrace/android/embracesdk/session/lifecycle/ProcessStateListener;", "Lio/embrace/android/embracesdk/anr/BlockedThreadListener;", "configService", "Lio/embrace/android/embracesdk/config/ConfigService;", "looper", "Landroid/os/Looper;", "logger", "Lio/embrace/android/embracesdk/logging/EmbLogger;", "livenessCheckScheduler", "Lio/embrace/android/embracesdk/anr/detection/LivenessCheckScheduler;", "anrMonitorWorker", "Lio/embrace/android/embracesdk/worker/ScheduledWorker;", "state", "Lio/embrace/android/embracesdk/anr/detection/ThreadMonitoringState;", "clock", "Lio/embrace/android/embracesdk/internal/clock/Clock;", "anrMonitorThread", "Ljava/util/concurrent/atomic/AtomicReference;", "Ljava/lang/Thread;", "(Lio/embrace/android/embracesdk/config/ConfigService;Landroid/os/Looper;Lio/embrace/android/embracesdk/logging/EmbLogger;Lio/embrace/android/embracesdk/anr/detection/LivenessCheckScheduler;Lio/embrace/android/embracesdk/worker/ScheduledWorker;Lio/embrace/android/embracesdk/anr/detection/ThreadMonitoringState;Lio/embrace/android/embracesdk/internal/clock/Clock;Ljava/util/concurrent/atomic/AtomicReference;)V", "getClock", "()Lio/embrace/android/embracesdk/internal/clock/Clock;", "getConfigService", "()Lio/embrace/android/embracesdk/config/ConfigService;", "setConfigService", "(Lio/embrace/android/embracesdk/config/ConfigService;)V", "listeners", "Ljava/util/concurrent/CopyOnWriteArrayList;", "getListeners", "()Ljava/util/concurrent/CopyOnWriteArrayList;", "stacktraceSampler", "Lio/embrace/android/embracesdk/anr/AnrStacktraceSampler;", "getStacktraceSampler", "()Lio/embrace/android/embracesdk/anr/AnrStacktraceSampler;", "targetThread", "targetThreadHeartbeatScheduler", "addBlockedThreadListener", "", "listener", "cleanCollections", "close", "finishInitialization", "forceAnrTrackingStopOnCrash", "getCapturedData", "", "Lio/embrace/android/embracesdk/payload/AnrInterval;", "onBackground", "timestamp", "", "onForeground", "coldStart", "", "onThreadBlocked", "thread", "onThreadBlockedInterval", "onThreadUnblocked", "processAnrTick", "processAnrTick$embrace_android_sdk_release", "startAnrCapture", "Companion", "embrace-android-sdk_release"})
public final class EmbraceAnrService
implements AnrService,
MemoryCleanerListener,
ProcessStateListener,
BlockedThreadListener {
    private final ThreadMonitoringState state;
    private final Thread targetThread;
    @NotNull
    private final AnrStacktraceSampler stacktraceSampler;
    private final EmbLogger logger;
    private final LivenessCheckScheduler targetThreadHeartbeatScheduler;
    @NotNull
    private final CopyOnWriteArrayList<BlockedThreadListener> listeners;
    @NotNull
    private ConfigService configService;
    private final ScheduledWorker anrMonitorWorker;
    @VisibleForTesting
    @NotNull
    private final Clock clock;
    private final AtomicReference<Thread> anrMonitorThread;
    private static final long MAX_DATA_WAIT_MS = 1000L;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final AnrStacktraceSampler getStacktraceSampler() {
        return this.stacktraceSampler;
    }

    @NotNull
    public final CopyOnWriteArrayList<BlockedThreadListener> getListeners() {
        return this.listeners;
    }

    private final void startAnrCapture() {
        this.anrMonitorWorker.submit(new Runnable(this){
            final /* synthetic */ EmbraceAnrService this$0;

            public final void run() {
                EmbraceAnrService.access$getTargetThreadHeartbeatScheduler$p(this.this$0).startMonitoringThread();
            }
            {
                this.this$0 = embraceAnrService;
            }
        });
    }

    @Override
    public void finishInitialization(@NotNull ConfigService configService2) {
        Intrinsics.checkNotNullParameter((Object)configService2, (String)"configService");
        this.configService = configService2;
        this.stacktraceSampler.setConfigService(configService2);
        this.targetThreadHeartbeatScheduler.setConfigService(configService2);
        this.startAnrCapture();
    }

    @Override
    public void addBlockedThreadListener(@NotNull BlockedThreadListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.listeners.add(listener);
    }

    @Override
    @NotNull
    public List<AnrInterval> getCapturedData() {
        List list;
        try {
            Callable callable2 = new Callable(this){
                final /* synthetic */ EmbraceAnrService this$0;

                public final List<AnrInterval> call() {
                    List<AnrInterval> list = this.this$0.getStacktraceSampler().getAnrIntervals(EmbraceAnrService.access$getState$p(this.this$0), this.this$0.getClock());
                    if (list == null) {
                        boolean bl = false;
                        String string2 = "ANR samples to be cached is null";
                        throw (Throwable)new IllegalStateException(string2.toString());
                    }
                    return list;
                }
                {
                    this.this$0 = embraceAnrService;
                }
            };
            Object t = this.anrMonitorWorker.submit(callable2).get(1000L, TimeUnit.MILLISECONDS);
            Intrinsics.checkNotNullExpressionValue(t, (String)"anrMonitorWorker.submit(\u2026S, TimeUnit.MILLISECONDS)");
            list = (List)t;
        }
        catch (Exception exc) {
            this.logger.logWarning("Failed to getAnrIntervals()", exc);
            this.logger.trackInternalError(InternalErrorType.ANR_DATA_FETCH, exc);
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Override
    public void forceAnrTrackingStopOnCrash() {
        this.anrMonitorWorker.submit(new Runnable(this){
            final /* synthetic */ EmbraceAnrService this$0;

            public final void run() {
                EmbraceAnrService.access$getTargetThreadHeartbeatScheduler$p(this.this$0).stopMonitoringThread();
            }
            {
                this.this$0 = embraceAnrService;
            }
        });
    }

    @Override
    public void close() {
    }

    @Override
    public void cleanCollections() {
        this.stacktraceSampler.cleanCollections();
    }

    @Override
    public void onThreadBlocked(@NotNull Thread thread, long timestamp) {
        Intrinsics.checkNotNullParameter((Object)thread, (String)"thread");
        ThreadEnforcementCheckKt.enforceThread(this.anrMonitorThread);
        for (BlockedThreadListener listener : this.listeners) {
            listener.onThreadBlocked(thread, timestamp);
        }
    }

    @Override
    public void onThreadBlockedInterval(@NotNull Thread thread, long timestamp) {
        Intrinsics.checkNotNullParameter((Object)thread, (String)"thread");
        ThreadEnforcementCheckKt.enforceThread(this.anrMonitorThread);
        this.processAnrTick$embrace_android_sdk_release(timestamp);
    }

    @Override
    public void onThreadUnblocked(@NotNull Thread thread, long timestamp) {
        Intrinsics.checkNotNullParameter((Object)thread, (String)"thread");
        ThreadEnforcementCheckKt.enforceThread(this.anrMonitorThread);
        for (BlockedThreadListener listener : this.listeners) {
            listener.onThreadUnblocked(thread, timestamp);
        }
    }

    public final void processAnrTick$embrace_android_sdk_release(long timestamp) {
        if (!this.configService.getAnrBehavior().isAnrCaptureEnabled()) {
            return;
        }
        for (BlockedThreadListener listener : this.listeners) {
            listener.onThreadBlockedInterval(this.targetThread, timestamp);
        }
    }

    @Override
    public void onForeground(boolean coldStart, long timestamp) {
        this.anrMonitorWorker.submit(new Runnable(this){
            final /* synthetic */ EmbraceAnrService this$0;

            public final void run() {
                ThreadEnforcementCheckKt.enforceThread(EmbraceAnrService.access$getAnrMonitorThread$p(this.this$0));
                EmbraceAnrService.access$getState$p(this.this$0).resetState();
                EmbraceAnrService.access$getTargetThreadHeartbeatScheduler$p(this.this$0).startMonitoringThread();
            }
            {
                this.this$0 = embraceAnrService;
            }
        });
    }

    @Override
    public void onBackground(long timestamp) {
        this.anrMonitorWorker.submit(new Runnable(this){
            final /* synthetic */ EmbraceAnrService this$0;

            public final void run() {
                EmbraceAnrService.access$getTargetThreadHeartbeatScheduler$p(this.this$0).stopMonitoringThread();
            }
            {
                this.this$0 = embraceAnrService;
            }
        });
    }

    @NotNull
    public final ConfigService getConfigService() {
        return this.configService;
    }

    public final void setConfigService(@NotNull ConfigService configService2) {
        Intrinsics.checkNotNullParameter((Object)configService2, (String)"<set-?>");
        this.configService = configService2;
    }

    @NotNull
    public final Clock getClock() {
        return this.clock;
    }

    public EmbraceAnrService(@NotNull ConfigService configService2, @NotNull Looper looper2, @NotNull EmbLogger logger2, @NotNull LivenessCheckScheduler livenessCheckScheduler2, @NotNull ScheduledWorker anrMonitorWorker, @NotNull ThreadMonitoringState state2, @NotNull Clock clock, @NotNull AtomicReference<Thread> anrMonitorThread) {
        Intrinsics.checkNotNullParameter((Object)configService2, (String)"configService");
        Intrinsics.checkNotNullParameter((Object)looper2, (String)"looper");
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)livenessCheckScheduler2, (String)"livenessCheckScheduler");
        Intrinsics.checkNotNullParameter((Object)anrMonitorWorker, (String)"anrMonitorWorker");
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter(anrMonitorThread, (String)"anrMonitorThread");
        this.configService = configService2;
        this.anrMonitorWorker = anrMonitorWorker;
        this.clock = clock;
        this.anrMonitorThread = anrMonitorThread;
        this.listeners = new CopyOnWriteArrayList();
        Thread thread = looper2.getThread();
        Intrinsics.checkNotNullExpressionValue((Object)thread, (String)"looper.thread");
        this.targetThread = thread;
        this.logger = logger2;
        this.state = state2;
        this.targetThreadHeartbeatScheduler = livenessCheckScheduler2;
        this.stacktraceSampler = new AnrStacktraceSampler(this.configService, this.clock, this.targetThread, this.anrMonitorThread, this.anrMonitorWorker);
        this.listeners.add(this.stacktraceSampler);
        this.listeners.add(new UnbalancedCallDetector(logger2));
        livenessCheckScheduler2.setListener(this);
    }

    public static final /* synthetic */ LivenessCheckScheduler access$getTargetThreadHeartbeatScheduler$p(EmbraceAnrService $this) {
        return $this.targetThreadHeartbeatScheduler;
    }

    public static final /* synthetic */ ThreadMonitoringState access$getState$p(EmbraceAnrService $this) {
        return $this.state;
    }

    public static final /* synthetic */ AtomicReference access$getAnrMonitorThread$p(EmbraceAnrService $this) {
        return $this.anrMonitorThread;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/embrace/android/embracesdk/anr/EmbraceAnrService$Companion;", "", "()V", "MAX_DATA_WAIT_MS", "", "embrace-android-sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

