/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk.anr.detection;

import android.os.Debug;
import io.embrace.android.embracesdk.anr.BlockedThreadListener;
import io.embrace.android.embracesdk.anr.detection.ThreadMonitoringState;
import io.embrace.android.embracesdk.config.ConfigService;
import io.embrace.android.embracesdk.internal.ThreadEnforcementCheckKt;
import io.embrace.android.embracesdk.internal.clock.Clock;
import io.embrace.android.embracesdk.logging.EmbLogger;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000f\u00a2\u0006\u0002\u0010\u0010J\u0015\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0000\u00a2\u0006\u0002\b\u001dJ\b\u0010\u001e\u001a\u00020\u001aH\u0002J\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010\u001b\u001a\u00020\u001cJ\u0015\u0010!\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0000\u00a2\u0006\u0002\b\"J\u000e\u0010#\u001a\u00020 2\u0006\u0010\u001b\u001a\u00020\u001cR\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lio/embrace/android/embracesdk/anr/detection/BlockedThreadDetector;", "", "configService", "Lio/embrace/android/embracesdk/config/ConfigService;", "clock", "Lio/embrace/android/embracesdk/internal/clock/Clock;", "listener", "Lio/embrace/android/embracesdk/anr/BlockedThreadListener;", "state", "Lio/embrace/android/embracesdk/anr/detection/ThreadMonitoringState;", "targetThread", "Ljava/lang/Thread;", "logger", "Lio/embrace/android/embracesdk/logging/EmbLogger;", "anrMonitorThread", "Ljava/util/concurrent/atomic/AtomicReference;", "(Lio/embrace/android/embracesdk/config/ConfigService;Lio/embrace/android/embracesdk/internal/clock/Clock;Lio/embrace/android/embracesdk/anr/BlockedThreadListener;Lio/embrace/android/embracesdk/anr/detection/ThreadMonitoringState;Ljava/lang/Thread;Lio/embrace/android/embracesdk/logging/EmbLogger;Ljava/util/concurrent/atomic/AtomicReference;)V", "getConfigService", "()Lio/embrace/android/embracesdk/config/ConfigService;", "setConfigService", "(Lio/embrace/android/embracesdk/config/ConfigService;)V", "getListener", "()Lio/embrace/android/embracesdk/anr/BlockedThreadListener;", "setListener", "(Lio/embrace/android/embracesdk/anr/BlockedThreadListener;)V", "isAnrDurationThresholdExceeded", "", "timestamp", "", "isAnrDurationThresholdExceeded$embrace_android_sdk_release", "isDebuggerEnabled", "onTargetThreadResponse", "", "shouldAttemptAnrSample", "shouldAttemptAnrSample$embrace_android_sdk_release", "updateAnrTracking", "embrace-android-sdk_release"})
public final class BlockedThreadDetector {
    @NotNull
    private ConfigService configService;
    private final Clock clock;
    @Nullable
    private BlockedThreadListener listener;
    private final ThreadMonitoringState state;
    private final Thread targetThread;
    private final EmbLogger logger;
    private final AtomicReference<Thread> anrMonitorThread;

    public final void onTargetThreadResponse(long timestamp) {
        block2: {
            ThreadEnforcementCheckKt.enforceThread(this.anrMonitorThread);
            this.state.setLastTargetThreadResponseMs(timestamp);
            if (this.isDebuggerEnabled()) {
                return;
            }
            if (!this.state.getAnrInProgress()) break block2;
            EmbLogger.DefaultImpls.logDebug$default(this.logger, "Main thread recovered from not responding for > 1s", null, 2, null);
            this.state.setAnrInProgress(false);
            BlockedThreadListener blockedThreadListener = this.listener;
            if (blockedThreadListener != null) {
                blockedThreadListener.onThreadUnblocked(this.targetThread, timestamp);
            }
        }
    }

    public final void updateAnrTracking(long timestamp) {
        ThreadEnforcementCheckKt.enforceThread(this.anrMonitorThread);
        if (this.isDebuggerEnabled()) {
            return;
        }
        if (!this.state.getAnrInProgress() && this.isAnrDurationThresholdExceeded$embrace_android_sdk_release(timestamp)) {
            EmbLogger.DefaultImpls.logDebug$default(this.logger, "Main thread not responding for > 1s", null, 2, null);
            this.state.setAnrInProgress(true);
            BlockedThreadListener blockedThreadListener = this.listener;
            if (blockedThreadListener != null) {
                blockedThreadListener.onThreadBlocked(this.targetThread, this.state.getLastTargetThreadResponseMs());
            }
        }
        if (this.state.getAnrInProgress() && this.shouldAttemptAnrSample$embrace_android_sdk_release(timestamp)) {
            BlockedThreadListener blockedThreadListener = this.listener;
            if (blockedThreadListener != null) {
                blockedThreadListener.onThreadBlockedInterval(this.targetThread, timestamp);
            }
            this.state.setLastSampleAttemptMs(this.clock.now());
        }
        this.state.setLastMonitorThreadResponseMs(this.clock.now());
    }

    public final boolean shouldAttemptAnrSample$embrace_android_sdk_release(long timestamp) {
        long intervalMs;
        long lastMonitorThreadResponseMs = this.state.getLastMonitorThreadResponseMs();
        long delta = timestamp - lastMonitorThreadResponseMs;
        return (double)delta > (double)(intervalMs = this.configService.getAnrBehavior().getSamplingIntervalMs()) * 0.5;
    }

    public final boolean isAnrDurationThresholdExceeded$embrace_android_sdk_release(long timestamp) {
        ThreadEnforcementCheckKt.enforceThread(this.anrMonitorThread);
        long monitorThreadLag = timestamp - this.state.getLastMonitorThreadResponseMs();
        long targetThreadLag = timestamp - this.state.getLastTargetThreadResponseMs();
        if (monitorThreadLag > 60000L) {
            long now = this.clock.now();
            this.state.setLastTargetThreadResponseMs(now);
            this.state.setLastMonitorThreadResponseMs(now);
            return false;
        }
        int minTriggerDuration = this.configService.getAnrBehavior().getMinDuration();
        return targetThreadLag > (long)minTriggerDuration;
    }

    private final boolean isDebuggerEnabled() {
        return Debug.isDebuggerConnected() || Debug.waitingForDebugger();
    }

    @NotNull
    public final ConfigService getConfigService() {
        return this.configService;
    }

    public final void setConfigService(@NotNull ConfigService configService2) {
        Intrinsics.checkNotNullParameter((Object)configService2, (String)"<set-?>");
        this.configService = configService2;
    }

    @Nullable
    public final BlockedThreadListener getListener() {
        return this.listener;
    }

    public final void setListener(@Nullable BlockedThreadListener blockedThreadListener) {
        this.listener = blockedThreadListener;
    }

    public BlockedThreadDetector(@NotNull ConfigService configService2, @NotNull Clock clock, @Nullable BlockedThreadListener listener, @NotNull ThreadMonitoringState state2, @NotNull Thread targetThread, @NotNull EmbLogger logger2, @NotNull AtomicReference<Thread> anrMonitorThread) {
        Intrinsics.checkNotNullParameter((Object)configService2, (String)"configService");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        Intrinsics.checkNotNullParameter((Object)targetThread, (String)"targetThread");
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        Intrinsics.checkNotNullParameter(anrMonitorThread, (String)"anrMonitorThread");
        this.configService = configService2;
        this.clock = clock;
        this.listener = listener;
        this.state = state2;
        this.targetThread = targetThread;
        this.logger = logger2;
        this.anrMonitorThread = anrMonitorThread;
    }

    public /* synthetic */ BlockedThreadDetector(ConfigService configService2, Clock clock, BlockedThreadListener blockedThreadListener, ThreadMonitoringState threadMonitoringState, Thread thread, EmbLogger embLogger, AtomicReference atomicReference, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            blockedThreadListener = null;
        }
        this(configService2, clock, blockedThreadListener, threadMonitoringState, thread, embLogger, atomicReference);
    }
}

