/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk.anr.detection;

import android.os.Handler;
import android.os.Message;
import android.os.Process;
import io.embrace.android.embracesdk.anr.BlockedThreadListener;
import io.embrace.android.embracesdk.anr.detection.BlockedThreadDetector;
import io.embrace.android.embracesdk.anr.detection.TargetThreadHandler;
import io.embrace.android.embracesdk.anr.detection.ThreadMonitoringState;
import io.embrace.android.embracesdk.capture.internal.errors.InternalErrorType;
import io.embrace.android.embracesdk.config.ConfigService;
import io.embrace.android.embracesdk.internal.ThreadEnforcementCheckKt;
import io.embrace.android.embracesdk.internal.clock.Clock;
import io.embrace.android.embracesdk.logging.EmbLogger;
import io.embrace.android.embracesdk.worker.ScheduledWorker;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001BM\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011\u00a2\u0006\u0002\u0010\u0013J\r\u0010#\u001a\u00020$H\u0000\u00a2\u0006\u0002\b%J\b\u0010&\u001a\u00020$H\u0002J\b\u0010'\u001a\u00020$H\u0002J\u0006\u0010(\u001a\u00020$J\b\u0010)\u001a\u00020*H\u0002J\u0006\u0010+\u001a\u00020$R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u00038F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R(\u0010\u001c\u001a\u0004\u0018\u00010\u001b2\b\u0010\u0014\u001a\u0004\u0018\u00010\u001b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010!\u001a\b\u0012\u0002\b\u0003\u0018\u00010\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lio/embrace/android/embracesdk/anr/detection/LivenessCheckScheduler;", "", "configService", "Lio/embrace/android/embracesdk/config/ConfigService;", "anrMonitorWorker", "Lio/embrace/android/embracesdk/worker/ScheduledWorker;", "clock", "Lio/embrace/android/embracesdk/internal/clock/Clock;", "state", "Lio/embrace/android/embracesdk/anr/detection/ThreadMonitoringState;", "targetThreadHandler", "Lio/embrace/android/embracesdk/anr/detection/TargetThreadHandler;", "blockedThreadDetector", "Lio/embrace/android/embracesdk/anr/detection/BlockedThreadDetector;", "logger", "Lio/embrace/android/embracesdk/logging/EmbLogger;", "anrMonitorThread", "Ljava/util/concurrent/atomic/AtomicReference;", "Ljava/lang/Thread;", "(Lio/embrace/android/embracesdk/config/ConfigService;Lio/embrace/android/embracesdk/worker/ScheduledWorker;Lio/embrace/android/embracesdk/internal/clock/Clock;Lio/embrace/android/embracesdk/anr/detection/ThreadMonitoringState;Lio/embrace/android/embracesdk/anr/detection/TargetThreadHandler;Lio/embrace/android/embracesdk/anr/detection/BlockedThreadDetector;Lio/embrace/android/embracesdk/logging/EmbLogger;Ljava/util/concurrent/atomic/AtomicReference;)V", "value", "getConfigService", "()Lio/embrace/android/embracesdk/config/ConfigService;", "setConfigService", "(Lio/embrace/android/embracesdk/config/ConfigService;)V", "intervalMs", "", "Lio/embrace/android/embracesdk/anr/BlockedThreadListener;", "listener", "getListener", "()Lio/embrace/android/embracesdk/anr/BlockedThreadListener;", "setListener", "(Lio/embrace/android/embracesdk/anr/BlockedThreadListener;)V", "monitorFuture", "Ljava/util/concurrent/ScheduledFuture;", "checkHeartbeat", "", "checkHeartbeat$embrace_android_sdk_release", "scheduleRegularHeartbeats", "sendHeartbeatMessage", "startMonitoringThread", "stopHeartbeatTask", "", "stopMonitoringThread", "embrace-android-sdk_release"})
public final class LivenessCheckScheduler {
    private long intervalMs;
    private ScheduledFuture<?> monitorFuture;
    private final ScheduledWorker anrMonitorWorker;
    private final Clock clock;
    private final ThreadMonitoringState state;
    private final TargetThreadHandler targetThreadHandler;
    private final BlockedThreadDetector blockedThreadDetector;
    private final EmbLogger logger;
    private final AtomicReference<Thread> anrMonitorThread;

    @NotNull
    public final ConfigService getConfigService() {
        return this.blockedThreadDetector.getConfigService();
    }

    public final void setConfigService(@NotNull ConfigService value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.blockedThreadDetector.setConfigService(value);
    }

    @Nullable
    public final BlockedThreadListener getListener() {
        return this.blockedThreadDetector.getListener();
    }

    public final void setListener(@Nullable BlockedThreadListener value) {
        this.blockedThreadDetector.setListener(value);
    }

    public final void startMonitoringThread() {
        ThreadEnforcementCheckKt.enforceThread(this.anrMonitorThread);
        if (!this.state.started.getAndSet(true)) {
            EmbLogger.DefaultImpls.logInfo$default(this.logger, "Start ANR detection...", null, 2, null);
            this.scheduleRegularHeartbeats();
        }
    }

    public final void stopMonitoringThread() {
        ThreadEnforcementCheckKt.enforceThread(this.anrMonitorThread);
        if (this.state.started.get() && this.stopHeartbeatTask()) {
            this.state.started.set(false);
        }
    }

    private final void scheduleRegularHeartbeats() {
        ThreadEnforcementCheckKt.enforceThread(this.anrMonitorThread);
        this.intervalMs = this.getConfigService().getAnrBehavior().getSamplingIntervalMs();
        Function0 function0 = (Function0)new Function0<Unit>(this){

            public final void invoke() {
                ((LivenessCheckScheduler)this.receiver).checkHeartbeat$embrace_android_sdk_release();
            }
        };
        Runnable runnable2 = new Runnable(function0){
            private final /* synthetic */ Function0 function;
            {
                this.function = function0;
            }

            public final /* synthetic */ void run() {
                Intrinsics.checkNotNullExpressionValue((Object)this.function.invoke(), (String)"invoke(...)");
            }
        };
        try {
            EmbLogger.DefaultImpls.logInfo$default(this.logger, "Starting ANR heartbeats with interval: " + this.intervalMs + "ms", null, 2, null);
            this.monitorFuture = this.anrMonitorWorker.scheduleAtFixedRate(runnable2, 0L, this.intervalMs, TimeUnit.MILLISECONDS);
        }
        catch (Exception exc) {
            String message = "ANR capture initialization failed";
            this.logger.logWarning(message, exc);
        }
    }

    private final boolean stopHeartbeatTask() {
        ThreadEnforcementCheckKt.enforceThread(this.anrMonitorThread);
        ScheduledFuture<?> scheduledFuture = this.monitorFuture;
        if (scheduledFuture != null) {
            ScheduledFuture<?> scheduledFuture2;
            ScheduledFuture<?> monitorTask = scheduledFuture2 = scheduledFuture;
            boolean bl = false;
            if (monitorTask.cancel(false)) {
                EmbLogger.DefaultImpls.logInfo$default(this.logger, "Stopped ANR detection...", null, 2, null);
                this.monitorFuture = null;
                return true;
            }
        }
        String message = "Scheduled heartbeat task could not be stopped." + (this.monitorFuture == null ? "Task is null." : "");
        IllegalStateException exc = new IllegalStateException(message);
        this.logger.logError(message, exc);
        this.logger.trackInternalError(InternalErrorType.ANR_HEARTBEAT_STOP_FAIL, exc);
        return false;
    }

    public final void checkHeartbeat$embrace_android_sdk_release() {
        ThreadEnforcementCheckKt.enforceThread(this.anrMonitorThread);
        try {
            int n;
            int $this$with = n = this.getConfigService().getAnrBehavior().getMonitorThreadPriority();
            boolean bl = false;
            Process.setThreadPriority((int)$this$with);
            if (this.intervalMs != this.getConfigService().getAnrBehavior().getSamplingIntervalMs()) {
                EmbLogger.DefaultImpls.logInfo$default(this.logger, "Different interval detected, scheduling a heartbeat restart", null, 2, null);
                this.anrMonitorWorker.submit(new Runnable(this){
                    final /* synthetic */ LivenessCheckScheduler this$0;

                    public final void run() {
                        if (LivenessCheckScheduler.access$stopHeartbeatTask(this.this$0)) {
                            LivenessCheckScheduler.access$scheduleRegularHeartbeats(this.this$0);
                        }
                    }
                    {
                        this.this$0 = livenessCheckScheduler2;
                    }
                });
            } else {
                long now = this.clock.now();
                if (!this.targetThreadHandler.hasMessages(34593)) {
                    this.sendHeartbeatMessage();
                }
                this.blockedThreadDetector.updateAnrTracking(now);
            }
        }
        catch (Exception exc) {
            this.logger.logError("Failed to process ANR monitor thread heartbeat", exc);
            this.logger.trackInternalError(InternalErrorType.ANR_HEARTBEAT_CHECK_FAIL, exc);
        }
    }

    private final void sendHeartbeatMessage() {
        Message heartbeatMessage = Message.obtain((Handler)this.targetThreadHandler, (int)34593);
        if (!this.targetThreadHandler.sendMessage(heartbeatMessage)) {
            this.logger.logWarning("Failed to send message to targetHandler, main thread likely shutting down.", new IllegalStateException("Failed to send message to targetHandler"));
        }
    }

    public LivenessCheckScheduler(@NotNull ConfigService configService2, @NotNull ScheduledWorker anrMonitorWorker, @NotNull Clock clock, @NotNull ThreadMonitoringState state2, @NotNull TargetThreadHandler targetThreadHandler2, @NotNull BlockedThreadDetector blockedThreadDetector2, @NotNull EmbLogger logger2, @NotNull AtomicReference<Thread> anrMonitorThread) {
        Intrinsics.checkNotNullParameter((Object)configService2, (String)"configService");
        Intrinsics.checkNotNullParameter((Object)anrMonitorWorker, (String)"anrMonitorWorker");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        Intrinsics.checkNotNullParameter((Object)((Object)targetThreadHandler2), (String)"targetThreadHandler");
        Intrinsics.checkNotNullParameter((Object)blockedThreadDetector2, (String)"blockedThreadDetector");
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        Intrinsics.checkNotNullParameter(anrMonitorThread, (String)"anrMonitorThread");
        this.anrMonitorWorker = anrMonitorWorker;
        this.clock = clock;
        this.state = state2;
        this.targetThreadHandler = targetThreadHandler2;
        this.blockedThreadDetector = blockedThreadDetector2;
        this.logger = logger2;
        this.anrMonitorThread = anrMonitorThread;
        this.intervalMs = configService2.getAnrBehavior().getSamplingIntervalMs();
        this.targetThreadHandler.setAction((Function1<? super Long, Unit>)((Function1)new Function1<Long, Unit>(this.blockedThreadDetector){

            public final void invoke(long p1) {
                ((BlockedThreadDetector)this.receiver).onTargetThreadResponse(p1);
            }
        }));
        this.targetThreadHandler.start();
    }

    public static final /* synthetic */ boolean access$stopHeartbeatTask(LivenessCheckScheduler $this) {
        return $this.stopHeartbeatTask();
    }

    public static final /* synthetic */ void access$scheduleRegularHeartbeats(LivenessCheckScheduler $this) {
        $this.scheduleRegularHeartbeats();
    }
}

