/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk.anr.detection;

import io.embrace.android.embracesdk.anr.BlockedThreadListener;
import io.embrace.android.embracesdk.capture.internal.errors.InternalErrorType;
import io.embrace.android.embracesdk.logging.EmbLogger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\bH\u0002J\u0018\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0006H\u0002J\u0018\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\bH\u0016J\u0018\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\bH\u0016J\u0018\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\bH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lio/embrace/android/embracesdk/anr/detection/UnbalancedCallDetector;", "Lio/embrace/android/embracesdk/anr/BlockedThreadListener;", "logger", "Lio/embrace/android/embracesdk/logging/EmbLogger;", "(Lio/embrace/android/embracesdk/logging/EmbLogger;)V", "blocked", "", "lastTimestamp", "", "checkTimeTravel", "", "name", "", "timestamp", "checkUnbalancedCall", "expected", "onThreadBlocked", "thread", "Ljava/lang/Thread;", "onThreadBlockedInterval", "onThreadUnblocked", "embrace-android-sdk_release"})
public final class UnbalancedCallDetector
implements BlockedThreadListener {
    private volatile boolean blocked;
    private volatile long lastTimestamp;
    private final EmbLogger logger;

    @Override
    public void onThreadBlocked(@NotNull Thread thread, long timestamp) {
        Intrinsics.checkNotNullParameter((Object)thread, (String)"thread");
        this.checkUnbalancedCall("onThreadBlocked()", false);
        this.blocked = true;
        this.checkTimeTravel("onThreadBlocked()", timestamp);
    }

    @Override
    public void onThreadBlockedInterval(@NotNull Thread thread, long timestamp) {
        Intrinsics.checkNotNullParameter((Object)thread, (String)"thread");
        this.checkUnbalancedCall("onThreadBlockedInterval()", true);
        this.checkTimeTravel("onThreadBlockedInterval()", timestamp);
    }

    @Override
    public void onThreadUnblocked(@NotNull Thread thread, long timestamp) {
        Intrinsics.checkNotNullParameter((Object)thread, (String)"thread");
        this.checkUnbalancedCall("onThreadUnblocked()", true);
        this.blocked = false;
        this.checkTimeTravel("onThreadUnblocked()", timestamp);
    }

    private final void checkTimeTravel(String name, long timestamp) {
        if (this.lastTimestamp > timestamp) {
            String msg = "Time travel in " + name + ". " + this.lastTimestamp + " to " + timestamp;
            EmbLogger.DefaultImpls.logWarning$default(this.logger, msg, null, 2, null);
            this.logger.trackInternalError(InternalErrorType.TIME_TRAVEL, new IllegalStateException("Time Travel"));
        }
        this.lastTimestamp = timestamp;
    }

    private final void checkUnbalancedCall(String name, boolean expected) {
        if (this.blocked != expected) {
            Thread thread = Thread.currentThread();
            Intrinsics.checkNotNullExpressionValue((Object)thread, (String)"Thread.currentThread()");
            String threadName = thread.getName();
            String msg = "Unbalanced call to " + name + " in ANR detection. Thread=" + threadName;
            EmbLogger.DefaultImpls.logWarning$default(this.logger, msg, null, 2, null);
            this.logger.trackInternalError(InternalErrorType.UNBALANCED_CALL, new IllegalStateException("Unbalanced call"));
        }
    }

    public UnbalancedCallDetector(@NotNull EmbLogger logger2) {
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        this.logger = logger2;
    }
}

