/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk.arch.datasource;

import io.embrace.android.embracesdk.arch.datasource.DataSource;
import io.embrace.android.embracesdk.arch.limits.LimitStrategy;
import io.embrace.android.embracesdk.capture.internal.errors.InternalErrorType;
import io.embrace.android.embracesdk.logging.EmbLogger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b \u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ/\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\r2\u0017\u0010\u000e\u001a\u0013\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\u0002\b\u0011H\u0016J9\u0010\u0012\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\r2\u0017\u0010\u000e\u001a\u0013\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\u0002\b\u00112\b\b\u0002\u0010\u0013\u001a\u00020\u000bH\u0004J\b\u0010\u0014\u001a\u00020\u0010H\u0016J\b\u0010\u0015\u001a\u00020\u0010H\u0016J\b\u0010\u0016\u001a\u00020\u0010H\u0016R\u0010\u0010\u0003\u001a\u00028\u0000X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lio/embrace/android/embracesdk/arch/datasource/DataSourceImpl;", "T", "Lio/embrace/android/embracesdk/arch/datasource/DataSource;", "destination", "logger", "Lio/embrace/android/embracesdk/logging/EmbLogger;", "limitStrategy", "Lio/embrace/android/embracesdk/arch/limits/LimitStrategy;", "(Ljava/lang/Object;Lio/embrace/android/embracesdk/logging/EmbLogger;Lio/embrace/android/embracesdk/arch/limits/LimitStrategy;)V", "Ljava/lang/Object;", "alterSessionSpan", "", "inputValidation", "Lkotlin/Function0;", "captureAction", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "captureDataImpl", "enforceLimits", "disableDataCapture", "enableDataCapture", "resetDataCaptureLimits", "embrace-android-sdk_release"})
public abstract class DataSourceImpl<T>
implements DataSource<T> {
    private final T destination;
    private final EmbLogger logger;
    private final LimitStrategy limitStrategy;

    @Override
    public void enableDataCapture() {
    }

    @Override
    public void disableDataCapture() {
    }

    @Override
    public void resetDataCaptureLimits() {
        this.limitStrategy.resetDataCaptureLimits();
    }

    @Override
    public boolean alterSessionSpan(@NotNull Function0<Boolean> inputValidation, @NotNull Function1<? super T, Unit> captureAction) {
        Intrinsics.checkNotNullParameter(inputValidation, (String)"inputValidation");
        Intrinsics.checkNotNullParameter(captureAction, (String)"captureAction");
        return this.captureDataImpl(inputValidation, captureAction, true);
    }

    protected final boolean captureDataImpl(@NotNull Function0<Boolean> inputValidation, @NotNull Function1<? super T, Unit> captureAction, boolean enforceLimits) {
        Intrinsics.checkNotNullParameter(inputValidation, (String)"inputValidation");
        Intrinsics.checkNotNullParameter(captureAction, (String)"captureAction");
        try {
            if (enforceLimits && !this.limitStrategy.shouldCapture()) {
                EmbLogger.DefaultImpls.logInfo$default(this.logger, "Data capture limit reached for " + this.getClass().getName() + '.' + " Ignoring to keep payload size reasonable - other data types will still be captured normally.", null, 2, null);
                return false;
            }
            if (!((Boolean)inputValidation.invoke()).booleanValue()) {
                EmbLogger.DefaultImpls.logWarning$default(this.logger, "Input validation failed.", null, 2, null);
                return false;
            }
            captureAction.invoke(this.destination);
            return true;
        }
        catch (Throwable exc) {
            this.logger.logError("Error capturing data", exc);
            this.logger.trackInternalError(InternalErrorType.DATA_SOURCE_DATA_CAPTURE_FAIL, exc);
            return false;
        }
    }

    public static /* synthetic */ boolean captureDataImpl$default(DataSourceImpl dataSourceImpl, Function0 function0, Function1 function1, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: captureDataImpl");
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        return dataSourceImpl.captureDataImpl((Function0<Boolean>)function0, function1, bl);
    }

    public DataSourceImpl(T destination, @NotNull EmbLogger logger2, @NotNull LimitStrategy limitStrategy) {
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)limitStrategy, (String)"limitStrategy");
        this.destination = destination;
        this.logger = logger2;
        this.limitStrategy = limitStrategy;
    }
}

