/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk.arch.destination;

import io.embrace.android.embracesdk.Severity;
import io.embrace.android.embracesdk.arch.destination.LogWriter;
import io.embrace.android.embracesdk.arch.schema.FixedAttribute;
import io.embrace.android.embracesdk.arch.schema.PrivateSpan;
import io.embrace.android.embracesdk.arch.schema.SchemaType;
import io.embrace.android.embracesdk.capture.metadata.MetadataService;
import io.embrace.android.embracesdk.internal.spans.EmbraceExtensionsKt;
import io.embrace.android.embracesdk.internal.utils.Uuid;
import io.embrace.android.embracesdk.opentelemetry.EmbraceAttributeKeysKt;
import io.embrace.android.embracesdk.session.id.SessionIdTracker;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.logs.LogRecordBuilder;
import io.opentelemetry.api.logs.Logger;
import io.opentelemetry.semconv.incubating.LogIncubatingAttributes;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ(\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lio/embrace/android/embracesdk/arch/destination/LogWriterImpl;", "Lio/embrace/android/embracesdk/arch/destination/LogWriter;", "logger", "Lio/opentelemetry/api/logs/Logger;", "sessionIdTracker", "Lio/embrace/android/embracesdk/session/id/SessionIdTracker;", "metadataService", "Lio/embrace/android/embracesdk/capture/metadata/MetadataService;", "(Lio/opentelemetry/api/logs/Logger;Lio/embrace/android/embracesdk/session/id/SessionIdTracker;Lio/embrace/android/embracesdk/capture/metadata/MetadataService;)V", "addLog", "", "schemaType", "Lio/embrace/android/embracesdk/arch/schema/SchemaType;", "severity", "Lio/embrace/android/embracesdk/Severity;", "message", "", "isPrivate", "", "embrace-android-sdk_release"})
public final class LogWriterImpl
implements LogWriter {
    private final Logger logger;
    private final SessionIdTracker sessionIdTracker;
    private final MetadataService metadataService;

    @Override
    public void addLog(@NotNull SchemaType schemaType, @NotNull Severity severity, @NotNull String message, boolean isPrivate) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)schemaType, (String)"schemaType");
        Intrinsics.checkNotNullParameter((Object)((Object)severity), (String)"severity");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        LogRecordBuilder builder = this.logger.logRecordBuilder().setBody(message).setSeverity(EmbraceExtensionsKt.toOtelSeverity(severity)).setSeverityText(severity.name());
        builder.setAttribute(LogIncubatingAttributes.LOG_RECORD_UID, (Object)Uuid.getEmbUuid$default(null, 1, null));
        String string3 = this.sessionIdTracker.getActiveSessionId();
        if (string3 != null) {
            String sessionId = string2 = string3;
            boolean bl = false;
            builder.setAttribute(EmbraceAttributeKeysKt.getEmbSessionId().getAttributeKey(), (Object)sessionId);
        }
        String string4 = this.metadataService.getAppState();
        if (string4 != null) {
            String appState = string2 = string4;
            boolean bl = false;
            builder.setAttribute(EmbraceAttributeKeysKt.getEmbState().getAttributeKey(), (Object)appState);
        }
        if (isPrivate) {
            LogRecordBuilder logRecordBuilder = builder;
            Intrinsics.checkNotNullExpressionValue((Object)logRecordBuilder, (String)"builder");
            EmbraceExtensionsKt.setFixedAttribute(logRecordBuilder, (FixedAttribute)PrivateSpan.INSTANCE);
        }
        SchemaType $this$with = schemaType;
        boolean bl = false;
        LogRecordBuilder logRecordBuilder = builder;
        Intrinsics.checkNotNullExpressionValue((Object)logRecordBuilder, (String)"builder");
        EmbraceExtensionsKt.setFixedAttribute(logRecordBuilder, (FixedAttribute)$this$with.getTelemetryType());
        Map<String, String> $this$forEach$iv = $this$with.attributes();
        boolean $i$f$forEach = false;
        Map<String, String> map = $this$forEach$iv;
        boolean bl2 = false;
        Iterator<Map.Entry<String, String>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> element$iv;
            Map.Entry<String, String> it = element$iv = iterator.next();
            boolean bl3 = false;
            builder.setAttribute(AttributeKey.stringKey((String)it.getKey()), (Object)it.getValue());
        }
        builder.emit();
    }

    public LogWriterImpl(@NotNull Logger logger2, @NotNull SessionIdTracker sessionIdTracker2, @NotNull MetadataService metadataService2) {
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)sessionIdTracker2, (String)"sessionIdTracker");
        Intrinsics.checkNotNullParameter((Object)metadataService2, (String)"metadataService");
        this.logger = logger2;
        this.sessionIdTracker = sessionIdTracker2;
        this.metadataService = metadataService2;
    }
}

