/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk.capture.aei;

import android.app.ActivityManager;
import android.app.ApplicationExitInfo;
import androidx.annotation.RequiresApi;
import io.embrace.android.embracesdk.Severity;
import io.embrace.android.embracesdk.arch.datasource.DataSourceImpl;
import io.embrace.android.embracesdk.arch.datasource.DataSourceImplKt;
import io.embrace.android.embracesdk.arch.destination.LogWriter;
import io.embrace.android.embracesdk.arch.limits.UpToLimitStrategy;
import io.embrace.android.embracesdk.arch.schema.SchemaType;
import io.embrace.android.embracesdk.capture.aei.AeiDataSource;
import io.embrace.android.embracesdk.capture.internal.errors.InternalErrorType;
import io.embrace.android.embracesdk.config.behavior.AppExitInfoBehavior;
import io.embrace.android.embracesdk.internal.utils.BuildVersionChecker;
import io.embrace.android.embracesdk.internal.utils.EncodingExtensionsKt;
import io.embrace.android.embracesdk.internal.utils.VersionChecker;
import io.embrace.android.embracesdk.logging.EmbLogger;
import io.embrace.android.embracesdk.payload.AppExitInfoData;
import io.embrace.android.embracesdk.prefs.PreferencesService;
import io.embrace.android.embracesdk.worker.BackgroundWorker;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0001\u0018\u0000 72\u00020\u00012\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u0004:\u00017BA\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u0003\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J$\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u001eH\u0002J\u0012\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\b\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020#H\u0016J\u0010\u0010%\u001a\u00020\u001e2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u000e\u0010&\u001a\b\u0012\u0004\u0012\u00020\u001c0'H\u0002J\u0010\u0010(\u001a\u00020\u001e2\u0006\u0010)\u001a\u00020\u001eH\u0002J\u0012\u0010*\u001a\u0004\u0018\u00010\u001e2\u0006\u0010+\u001a\u00020!H\u0002J\u0012\u0010,\u001a\u0004\u0018\u00010\u001e2\u0006\u0010+\u001a\u00020!H\u0002J\u001c\u0010-\u001a\b\u0012\u0004\u0012\u00020\u001c0'2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u001c0'H\u0002J\b\u0010/\u001a\u00020#H\u0002J\u0016\u00100\u001a\u00020#2\f\u00101\u001a\b\u0012\u0004\u0012\u00020\u001c0'H\u0002J\u0012\u00102\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0016\u00103\u001a\u00020#2\f\u00104\u001a\b\u0012\u0004\u0012\u00020\u00190'H\u0002J\f\u00105\u001a\u000206*\u00020\u001cH\u0002R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lio/embrace/android/embracesdk/capture/aei/AeiDataSourceImpl;", "Lio/embrace/android/embracesdk/capture/aei/AeiDataSource;", "Lio/embrace/android/embracesdk/arch/datasource/DataSourceImpl;", "Lio/embrace/android/embracesdk/arch/destination/LogWriter;", "Lio/embrace/android/embracesdk/arch/datasource/LogDataSourceImpl;", "backgroundWorker", "Lio/embrace/android/embracesdk/worker/BackgroundWorker;", "appExitInfoBehavior", "Lio/embrace/android/embracesdk/config/behavior/AppExitInfoBehavior;", "activityManager", "Landroid/app/ActivityManager;", "preferencesService", "Lio/embrace/android/embracesdk/prefs/PreferencesService;", "logWriter", "logger", "Lio/embrace/android/embracesdk/logging/EmbLogger;", "buildVersionChecker", "Lio/embrace/android/embracesdk/internal/utils/VersionChecker;", "(Lio/embrace/android/embracesdk/worker/BackgroundWorker;Lio/embrace/android/embracesdk/config/behavior/AppExitInfoBehavior;Landroid/app/ActivityManager;Lio/embrace/android/embracesdk/prefs/PreferencesService;Lio/embrace/android/embracesdk/arch/destination/LogWriter;Lio/embrace/android/embracesdk/logging/EmbLogger;Lio/embrace/android/embracesdk/internal/utils/VersionChecker;)V", "backgroundExecution", "Ljava/util/concurrent/Future;", "isSessionApplicationExitInfoDataReady", "Ljava/util/concurrent/atomic/AtomicBoolean;", "sessionApplicationExitInfoData", "", "Lio/embrace/android/embracesdk/payload/AppExitInfoData;", "buildSessionAppExitInfoData", "appExitInfo", "Landroid/app/ApplicationExitInfo;", "trace", "", "traceStatus", "collectExitInfoTrace", "Lio/embrace/android/embracesdk/config/behavior/AppExitInfoBehavior$CollectTracesResult;", "disableDataCapture", "", "enableDataCapture", "generateUniqueHash", "getHistoricalProcessExitReasons", "", "getSessionIdValidationError", "sid", "getTrace", "traceResult", "getTraceStatus", "getUnsentExitReasons", "historicalProcessExitReasons", "processApplicationExitInfo", "processApplicationExitInfoBlobs", "unsentExitReasons", "readTraceAsString", "sendApplicationExitInfoWithTraces", "appExitInfoWithTraces", "isNdkProtobufFile", "", "Companion", "embrace-android-sdk_release"})
@RequiresApi(value=30)
public final class AeiDataSourceImpl
extends DataSourceImpl<LogWriter>
implements AeiDataSource {
    private volatile Future<?> backgroundExecution;
    private final List<AppExitInfoData> sessionApplicationExitInfoData;
    private final AtomicBoolean isSessionApplicationExitInfoDataReady;
    private final BackgroundWorker backgroundWorker;
    private final AppExitInfoBehavior appExitInfoBehavior;
    private final ActivityManager activityManager;
    private final PreferencesService preferencesService;
    private final EmbLogger logger;
    private final VersionChecker buildVersionChecker;
    private static final int SDK_AEI_SEND_LIMIT = 32;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    public void enableDataCapture() {
        if (this.backgroundExecution != null) {
            return;
        }
        this.backgroundExecution = BackgroundWorker.submit$default(this.backgroundWorker, null, new Runnable(this){
            final /* synthetic */ AeiDataSourceImpl this$0;

            public final void run() {
                try {
                    AeiDataSourceImpl.access$processApplicationExitInfo(this.this$0);
                }
                catch (Throwable exc) {
                    AeiDataSourceImpl.access$getLogger$p(this.this$0).logWarning("AEI - Failed to process AEIs due to unexpected error", exc);
                    AeiDataSourceImpl.access$getLogger$p(this.this$0).trackInternalError(InternalErrorType.ENABLE_DATA_CAPTURE, exc);
                }
            }
            {
                this.this$0 = aeiDataSourceImpl;
            }
        }, 1, null);
    }

    @Override
    public void disableDataCapture() {
        try {
            Future<?> future2 = this.backgroundExecution;
            if (future2 != null) {
                future2.cancel(true);
            }
            this.backgroundExecution = null;
        }
        catch (Throwable t) {
            this.logger.logWarning("AEI - Failed to disable EmbraceApplicationExitInfoService work", t);
            this.logger.trackInternalError(InternalErrorType.DISABLE_DATA_CAPTURE, t);
        }
    }

    private final void processApplicationExitInfo() {
        List<ApplicationExitInfo> historicalProcessExitReasons = this.getHistoricalProcessExitReasons();
        List<ApplicationExitInfo> unsentExitReasons = this.getUnsentExitReasons(historicalProcessExitReasons);
        Iterable $this$forEach$iv = unsentExitReasons;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ApplicationExitInfo it = (ApplicationExitInfo)element$iv;
            boolean bl = false;
            this.sessionApplicationExitInfoData.add(this.buildSessionAppExitInfoData(it, null, null));
        }
        this.isSessionApplicationExitInfoDataReady.set(true);
        this.processApplicationExitInfoBlobs(unsentExitReasons);
    }

    private final void processApplicationExitInfoBlobs(List<ApplicationExitInfo> unsentExitReasons) {
        Iterable $this$forEach$iv = unsentExitReasons;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ApplicationExitInfo aei = (ApplicationExitInfo)element$iv;
            boolean bl = false;
            AppExitInfoBehavior.CollectTracesResult traceResult = this.collectExitInfoTrace(aei);
            if (traceResult == null) continue;
            AppExitInfoData payload = this.buildSessionAppExitInfoData(aei, this.getTrace(traceResult), this.getTraceStatus(traceResult));
            this.sendApplicationExitInfoWithTraces(CollectionsKt.listOf((Object)payload));
        }
    }

    private final List<ApplicationExitInfo> getHistoricalProcessExitReasons() {
        int pid = 0;
        int maxNum = this.appExitInfoBehavior.appExitInfoMaxNum();
        Object object = this.activityManager;
        if (object == null || (object = object.getHistoricalProcessExitReasons(null, pid, maxNum)) == null) {
            return CollectionsKt.emptyList();
        }
        Object historicalProcessExitReasons = object;
        if (historicalProcessExitReasons.size() > 32) {
            historicalProcessExitReasons = CollectionsKt.take((Iterable)((Iterable)historicalProcessExitReasons), (int)32);
        }
        return historicalProcessExitReasons;
    }

    /*
     * WARNING - void declaration
     */
    private final List<ApplicationExitInfo> getUnsentExitReasons(List<ApplicationExitInfo> historicalProcessExitReasons) {
        void $this$filterTo$iv$iv;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = historicalProcessExitReasons;
        AeiDataSourceImpl aeiDataSourceImpl = this;
        boolean $i$f$map = false;
        void var6_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p1;
            ApplicationExitInfo applicationExitInfo = (ApplicationExitInfo)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string2 = aeiDataSourceImpl.generateUniqueHash((ApplicationExitInfo)p1);
            collection.add(string2);
        }
        Set allAeiHashCodes = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Set set = this.preferencesService.getApplicationExitInfoHistory();
        if (set == null) {
            set = SetsKt.emptySet();
        }
        Set deliveredHashCodes = set;
        Set unsentHashCodes = CollectionsKt.subtract((Iterable)allAeiHashCodes, (Iterable)deliveredHashCodes);
        this.preferencesService.setApplicationExitInfoHistory(allAeiHashCodes);
        Iterable $this$filter$iv = historicalProcessExitReasons;
        boolean $i$f$filter = false;
        Iterable $i$f$mapTo22 = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ApplicationExitInfo it = (ApplicationExitInfo)element$iv$iv;
            boolean bl = false;
            if (!unsentHashCodes.contains(this.generateUniqueHash(it))) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List unsentAeiObjects = (List)destination$iv$iv2;
        return unsentAeiObjects;
    }

    private final AppExitInfoData buildSessionAppExitInfoData(ApplicationExitInfo appExitInfo, String trace, String traceStatus) {
        byte[] byArray = appExitInfo.getProcessStateSummary();
        if (byArray == null) {
            byArray = new byte[]{};
        }
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"appExitInfo.processStateSummary ?: ByteArray(0)");
        byte[] byArray2 = byArray;
        String sessionId = new String(byArray2, Charsets.UTF_8);
        return new AppExitInfoData(sessionId, this.getSessionIdValidationError(sessionId), appExitInfo.getImportance(), appExitInfo.getPss(), appExitInfo.getReason(), appExitInfo.getRss(), appExitInfo.getStatus(), appExitInfo.getTimestamp(), trace, appExitInfo.getDescription(), traceStatus);
    }

    private final String getTrace(AppExitInfoBehavior.CollectTracesResult traceResult) {
        AppExitInfoBehavior.CollectTracesResult collectTracesResult = traceResult;
        return collectTracesResult instanceof AppExitInfoBehavior.CollectTracesResult.Success ? traceResult.getResult() : (collectTracesResult instanceof AppExitInfoBehavior.CollectTracesResult.TooLarge ? traceResult.getResult() : null);
    }

    private final String getTraceStatus(AppExitInfoBehavior.CollectTracesResult traceResult) {
        AppExitInfoBehavior.CollectTracesResult collectTracesResult = traceResult;
        return collectTracesResult instanceof AppExitInfoBehavior.CollectTracesResult.Success ? null : (collectTracesResult instanceof AppExitInfoBehavior.CollectTracesResult.TooLarge ? "Trace was too large, sending truncated trace" : traceResult.getResult());
    }

    private final void sendApplicationExitInfoWithTraces(List<AppExitInfoData> appExitInfoWithTraces) {
        Iterable $this$forEach$iv = appExitInfoWithTraces;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AppExitInfoData data = (AppExitInfoData)element$iv;
            boolean bl = false;
            this.alterSessionSpan(DataSourceImplKt.getNoInputValidation(), (Function1)new Function1<LogWriter, Unit>(data){
                final /* synthetic */ AppExitInfoData $data;

                public final void invoke(@NotNull LogWriter $this$alterSessionSpan) {
                    Intrinsics.checkNotNullParameter((Object)$this$alterSessionSpan, (String)"$receiver");
                    SchemaType.AeiLog schemaType = new SchemaType.AeiLog(this.$data);
                    SchemaType schemaType2 = schemaType;
                    String string2 = this.$data.getTrace$embrace_android_sdk_release();
                    if (string2 == null) {
                        string2 = "";
                    }
                    LogWriter.DefaultImpls.addLog$default($this$alterSessionSpan, schemaType2, Severity.INFO, string2, false, 8, null);
                }
                {
                    this.$data = appExitInfoData;
                    super(1);
                }
            });
        }
    }

    private final AppExitInfoBehavior.CollectTracesResult collectExitInfoTrace(ApplicationExitInfo appExitInfo) {
        try {
            String trace = this.readTraceAsString(appExitInfo);
            if (trace == null) {
                EmbLogger.DefaultImpls.logDebug$default(this.logger, "AEI - No info trace collected", null, 2, null);
                return null;
            }
            int traceMaxLimit = this.appExitInfoBehavior.getTraceMaxLimit();
            if (trace.length() > traceMaxLimit) {
                return new AppExitInfoBehavior.CollectTracesResult.TooLarge(StringsKt.take((String)trace, (int)traceMaxLimit));
            }
            return new AppExitInfoBehavior.CollectTracesResult.Success(trace);
        }
        catch (IOException e) {
            this.logger.logWarning("AEI - IOException", e);
            return new AppExitInfoBehavior.CollectTracesResult.TraceException("ioexception: " + e.getMessage());
        }
        catch (OutOfMemoryError e) {
            this.logger.logWarning("AEI - Out of Memory", e);
            return new AppExitInfoBehavior.CollectTracesResult.TraceException("oom: " + e.getMessage());
        }
        catch (Throwable tr) {
            this.logger.logWarning("AEI - An error occurred", tr);
            return new AppExitInfoBehavior.CollectTracesResult.TraceException("error: " + tr.getMessage());
        }
    }

    private final String readTraceAsString(ApplicationExitInfo appExitInfo) {
        String string2;
        if (this.isNdkProtobufFile(appExitInfo)) {
            byte[] bytes;
            InputStream inputStream = appExitInfo.getTraceInputStream();
            Object object = bytes = (Object)(inputStream != null ? ByteStreamsKt.readBytes((InputStream)inputStream) : null);
            if (bytes == null) {
                EmbLogger.DefaultImpls.logDebug$default(this.logger, "AEI - No info trace collected", null, 2, null);
                return null;
            }
            return EncodingExtensionsKt.toUTF8String(bytes);
        }
        InputStream inputStream = appExitInfo.getTraceInputStream();
        if (inputStream != null) {
            InputStream inputStream2 = inputStream;
            Charset charset = Charsets.UTF_8;
            Closeable closeable = inputStream2;
            int n = 0;
            closeable = new InputStreamReader((InputStream)closeable, charset);
            n = 8192;
            boolean bl = false;
            string2 = TextStreamsKt.readText((Reader)(closeable instanceof BufferedReader ? (BufferedReader)closeable : new BufferedReader((Reader)closeable, n)));
        } else {
            string2 = null;
        }
        return string2;
    }

    private final boolean isNdkProtobufFile(ApplicationExitInfo $this$isNdkProtobufFile) {
        return this.buildVersionChecker.isAtLeast(31) && $this$isNdkProtobufFile.getReason() == 5;
    }

    private final String getSessionIdValidationError(String sid) {
        Regex regex;
        CharSequence charSequence = sid;
        return charSequence.length() == 0 || (regex = new Regex("^[0-9a-fA-F]{32}$")).matches(charSequence = (CharSequence)sid) ? "" : "invalid session ID: " + sid;
    }

    private final String generateUniqueHash(ApplicationExitInfo appExitInfo) {
        return "" + appExitInfo.getTimestamp() + '_' + appExitInfo.getPid();
    }

    public AeiDataSourceImpl(@NotNull BackgroundWorker backgroundWorker, @NotNull AppExitInfoBehavior appExitInfoBehavior2, @Nullable ActivityManager activityManager2, @NotNull PreferencesService preferencesService2, @NotNull LogWriter logWriter2, @NotNull EmbLogger logger2, @NotNull VersionChecker buildVersionChecker) {
        Intrinsics.checkNotNullParameter((Object)backgroundWorker, (String)"backgroundWorker");
        Intrinsics.checkNotNullParameter((Object)appExitInfoBehavior2, (String)"appExitInfoBehavior");
        Intrinsics.checkNotNullParameter((Object)preferencesService2, (String)"preferencesService");
        Intrinsics.checkNotNullParameter((Object)logWriter2, (String)"logWriter");
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)buildVersionChecker, (String)"buildVersionChecker");
        super(logWriter2, logger2, new UpToLimitStrategy((Function0<Integer>)((Function0)1.INSTANCE)));
        this.backgroundWorker = backgroundWorker;
        this.appExitInfoBehavior = appExitInfoBehavior2;
        this.activityManager = activityManager2;
        this.preferencesService = preferencesService2;
        this.logger = logger2;
        this.buildVersionChecker = buildVersionChecker;
        this.sessionApplicationExitInfoData = new ArrayList();
        this.isSessionApplicationExitInfoDataReady = new AtomicBoolean(false);
    }

    public /* synthetic */ AeiDataSourceImpl(BackgroundWorker backgroundWorker, AppExitInfoBehavior appExitInfoBehavior2, ActivityManager activityManager2, PreferencesService preferencesService2, LogWriter logWriter2, EmbLogger embLogger, VersionChecker versionChecker, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x40) != 0) {
            versionChecker = BuildVersionChecker.INSTANCE;
        }
        this(backgroundWorker, appExitInfoBehavior2, activityManager2, preferencesService2, logWriter2, embLogger, versionChecker);
    }

    public static final /* synthetic */ void access$processApplicationExitInfo(AeiDataSourceImpl $this) {
        $this.processApplicationExitInfo();
    }

    public static final /* synthetic */ EmbLogger access$getLogger$p(AeiDataSourceImpl $this) {
        return $this.logger;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/embrace/android/embracesdk/capture/aei/AeiDataSourceImpl$Companion;", "", "()V", "SDK_AEI_SEND_LIMIT", "", "embrace-android-sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

