/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk.capture.connectivity;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import io.embrace.android.embracesdk.arch.datasource.DataSourceState;
import io.embrace.android.embracesdk.capture.connectivity.NetworkConnectivityListener;
import io.embrace.android.embracesdk.capture.connectivity.NetworkConnectivityService;
import io.embrace.android.embracesdk.capture.connectivity.NetworkStatusDataSource;
import io.embrace.android.embracesdk.capture.internal.errors.InternalErrorType;
import io.embrace.android.embracesdk.comms.delivery.NetworkStatus;
import io.embrace.android.embracesdk.injection.DataSourceModule;
import io.embrace.android.embracesdk.internal.clock.Clock;
import io.embrace.android.embracesdk.logging.EmbLogger;
import io.embrace.android.embracesdk.worker.BackgroundWorker;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002BK\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\u001a\u0010\r\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u000ej\n\u0012\u0006\u0012\u0004\u0018\u00010\u000f`\u0010\u00a2\u0006\u0002\u0010\u0011J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u001eH\u0016J\n\u0010\"\u001a\u0004\u0018\u00010\u0015H\u0002J\b\u0010#\u001a\u00020 H\u0016J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u001bH\u0002J\b\u0010'\u001a\u00020\u001bH\u0016J\u001a\u0010(\u001a\u00020 2\u0006\u0010)\u001a\u00020%2\b\b\u0002\u0010*\u001a\u00020+H\u0002J\u0010\u0010,\u001a\u00020 2\u0006\u0010-\u001a\u00020+H\u0016J\u0010\u0010.\u001a\u00020 2\u0006\u0010/\u001a\u00020\u001bH\u0002J\u0018\u00100\u001a\u00020 2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u00101\u001a\u000202H\u0016J\b\u00103\u001a\u00020 H\u0016J\u0010\u00104\u001a\u00020 2\u0006\u0010!\u001a\u00020\u001eH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\r\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u000ej\n\u0012\u0006\u0012\u0004\u0018\u00010\u000f`\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0014\u001a\u0004\u0018\u00010\u00158VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u0016\u0010\u0017R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lio/embrace/android/embracesdk/capture/connectivity/EmbraceNetworkConnectivityService;", "Landroid/content/BroadcastReceiver;", "Lio/embrace/android/embracesdk/capture/connectivity/NetworkConnectivityService;", "context", "Landroid/content/Context;", "clock", "Lio/embrace/android/embracesdk/internal/clock/Clock;", "backgroundWorker", "Lio/embrace/android/embracesdk/worker/BackgroundWorker;", "logger", "Lio/embrace/android/embracesdk/logging/EmbLogger;", "connectivityManager", "Landroid/net/ConnectivityManager;", "dataSourceModuleProvider", "Lkotlin/Function0;", "Lio/embrace/android/embracesdk/injection/DataSourceModule;", "Lio/embrace/android/embracesdk/internal/utils/Provider;", "(Landroid/content/Context;Lio/embrace/android/embracesdk/internal/clock/Clock;Lio/embrace/android/embracesdk/worker/BackgroundWorker;Lio/embrace/android/embracesdk/logging/EmbLogger;Landroid/net/ConnectivityManager;Lkotlin/jvm/functions/Function0;)V", "intentFilter", "Landroid/content/IntentFilter;", "ipAddress", "", "getIpAddress", "()Ljava/lang/String;", "ipAddress$delegate", "Lkotlin/Lazy;", "lastNetworkStatus", "Lio/embrace/android/embracesdk/comms/delivery/NetworkStatus;", "networkConnectivityListeners", "", "Lio/embrace/android/embracesdk/capture/connectivity/NetworkConnectivityListener;", "addNetworkConnectivityListener", "", "listener", "calculateIpAddress", "close", "didNetworkStatusChange", "", "newNetworkStatus", "getCurrentNetworkStatus", "handleNetworkStatus", "notifyListeners", "timestamp", "", "networkStatusOnSessionStarted", "startTime", "notifyNetworkConnectivityListeners", "status", "onReceive", "intent", "Landroid/content/Intent;", "register", "removeNetworkConnectivityListener", "embrace-android-sdk_release"})
public final class EmbraceNetworkConnectivityService
extends BroadcastReceiver
implements NetworkConnectivityService {
    private final IntentFilter intentFilter;
    private NetworkStatus lastNetworkStatus;
    private final List<NetworkConnectivityListener> networkConnectivityListeners;
    @Nullable
    private final Lazy ipAddress$delegate;
    private final Context context;
    private final Clock clock;
    private final BackgroundWorker backgroundWorker;
    private final EmbLogger logger;
    private final ConnectivityManager connectivityManager;
    private final Function0<DataSourceModule> dataSourceModuleProvider;

    @Override
    @Nullable
    public String getIpAddress() {
        Lazy lazy = this.ipAddress$delegate;
        EmbraceNetworkConnectivityService embraceNetworkConnectivityService = this;
        Object var3_3 = null;
        return (String)lazy.getValue();
    }

    public void onReceive(@NotNull Context context2, @NotNull Intent intent) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        EmbraceNetworkConnectivityService.handleNetworkStatus$default(this, true, 0L, 2, null);
    }

    @Override
    public void networkStatusOnSessionStarted(long startTime) {
        this.handleNetworkStatus(false, startTime);
    }

    private final void handleNetworkStatus(boolean notifyListeners, long timestamp) {
        try {
            NetworkStatus networkStatus = this.getCurrentNetworkStatus();
            if (this.didNetworkStatusChange(networkStatus)) {
                this.lastNetworkStatus = networkStatus;
                Object object = (DataSourceModule)this.dataSourceModuleProvider.invoke();
                if (object != null && (object = object.getNetworkStatusDataSource()) != null && (object = (NetworkStatusDataSource)((DataSourceState)object).getDataSource()) != null) {
                    ((NetworkStatusDataSource)object).networkStatusChange(networkStatus, timestamp);
                }
                if (notifyListeners) {
                    EmbLogger.DefaultImpls.logInfo$default(this.logger, "Network status changed to: " + networkStatus.name(), null, 2, null);
                    this.notifyNetworkConnectivityListeners(networkStatus);
                }
            }
        }
        catch (Exception ex) {
            this.logger.logWarning("Failed to record network connectivity", ex);
            this.logger.trackInternalError(InternalErrorType.NETWORK_STATUS_CAPTURE_FAIL, ex);
        }
    }

    static /* synthetic */ void handleNetworkStatus$default(EmbraceNetworkConnectivityService embraceNetworkConnectivityService, boolean bl, long l, int n, Object object) {
        if ((n & 2) != 0) {
            l = embraceNetworkConnectivityService.clock.now();
        }
        embraceNetworkConnectivityService.handleNetworkStatus(bl, l);
    }

    @Override
    @NotNull
    public NetworkStatus getCurrentNetworkStatus() {
        NetworkStatus networkStatus = null;
        try {
            NetworkInfo networkInfo;
            ConnectivityManager connectivityManager2 = this.connectivityManager;
            Object object = networkInfo = connectivityManager2 != null ? connectivityManager2.getActiveNetworkInfo() : null;
            if (networkInfo != null && networkInfo.isConnected()) {
                switch (networkInfo.getType()) {
                    case 1: {
                        networkStatus = NetworkStatus.WIFI;
                        break;
                    }
                    case 0: {
                        networkStatus = NetworkStatus.WAN;
                        break;
                    }
                    default: {
                        networkStatus = NetworkStatus.UNKNOWN;
                        break;
                    }
                }
            } else {
                networkStatus = NetworkStatus.NOT_REACHABLE;
            }
        }
        catch (Exception e) {
            this.logger.logError("Error while trying to get connectivity status.", e);
            this.logger.trackInternalError(InternalErrorType.NETWORK_STATUS_CAPTURE_FAIL, e);
            networkStatus = NetworkStatus.UNKNOWN;
        }
        return networkStatus;
    }

    private final boolean didNetworkStatusChange(NetworkStatus newNetworkStatus) {
        return this.lastNetworkStatus == null || this.lastNetworkStatus != newNetworkStatus;
    }

    @Override
    public void register() {
        BackgroundWorker.submit$default(this.backgroundWorker, null, new Runnable(this){
            final /* synthetic */ EmbraceNetworkConnectivityService this$0;

            public final void run() {
                try {
                    EmbraceNetworkConnectivityService.access$getContext$p(this.this$0).registerReceiver((BroadcastReceiver)this.this$0, EmbraceNetworkConnectivityService.access$getIntentFilter$p(this.this$0));
                }
                catch (Exception ex) {
                    EmbraceNetworkConnectivityService.access$getLogger$p(this.this$0).logInfo("Failed to register EmbraceNetworkConnectivityService broadcast receiver. Connectivity status will be unavailable.", ex);
                }
            }
            {
                this.this$0 = embraceNetworkConnectivityService;
            }
        }, 1, null);
    }

    @Override
    public void close() {
        this.context.unregisterReceiver((BroadcastReceiver)this);
    }

    @Override
    public void addNetworkConnectivityListener(@NotNull NetworkConnectivityListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.networkConnectivityListeners.add(listener);
    }

    @Override
    public void removeNetworkConnectivityListener(@NotNull NetworkConnectivityListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.networkConnectivityListeners.remove(listener);
    }

    private final void notifyNetworkConnectivityListeners(NetworkStatus status) {
        for (NetworkConnectivityListener listener : this.networkConnectivityListeners) {
            listener.onNetworkConnectivityStatusChanged(status);
        }
    }

    private final String calculateIpAddress() {
        try {
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            while (en.hasMoreElements()) {
                NetworkInterface intf;
                NetworkInterface networkInterface = intf = en.nextElement();
                Intrinsics.checkNotNullExpressionValue((Object)networkInterface, (String)"intf");
                Enumeration<InetAddress> enumIpAddr = networkInterface.getInetAddresses();
                while (enumIpAddr.hasMoreElements()) {
                    InetAddress inetAddress;
                    InetAddress inetAddress2 = inetAddress = enumIpAddr.nextElement();
                    Intrinsics.checkNotNullExpressionValue((Object)inetAddress2, (String)"inetAddress");
                    if (inetAddress2.isLoopbackAddress() || !(inetAddress instanceof Inet4Address)) continue;
                    return inetAddress.getHostAddress();
                }
            }
        }
        catch (Exception ex) {
            EmbLogger.DefaultImpls.logDebug$default(this.logger, "Cannot get IP Address", null, 2, null);
        }
        return null;
    }

    public EmbraceNetworkConnectivityService(@NotNull Context context2, @NotNull Clock clock, @NotNull BackgroundWorker backgroundWorker, @NotNull EmbLogger logger2, @Nullable ConnectivityManager connectivityManager2, @NotNull Function0<? extends DataSourceModule> dataSourceModuleProvider) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)backgroundWorker, (String)"backgroundWorker");
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        Intrinsics.checkNotNullParameter(dataSourceModuleProvider, (String)"dataSourceModuleProvider");
        this.context = context2;
        this.clock = clock;
        this.backgroundWorker = backgroundWorker;
        this.logger = logger2;
        this.connectivityManager = connectivityManager2;
        this.dataSourceModuleProvider = dataSourceModuleProvider;
        this.intentFilter = new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE");
        this.networkConnectivityListeners = new ArrayList();
        this.ipAddress$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ EmbraceNetworkConnectivityService this$0;

            @Nullable
            public final String invoke() {
                return EmbraceNetworkConnectivityService.access$calculateIpAddress(this.this$0);
            }
            {
                this.this$0 = embraceNetworkConnectivityService;
                super(0);
            }
        }));
    }

    public static final /* synthetic */ Context access$getContext$p(EmbraceNetworkConnectivityService $this) {
        return $this.context;
    }

    public static final /* synthetic */ IntentFilter access$getIntentFilter$p(EmbraceNetworkConnectivityService $this) {
        return $this.intentFilter;
    }

    public static final /* synthetic */ EmbLogger access$getLogger$p(EmbraceNetworkConnectivityService $this) {
        return $this.logger;
    }

    public static final /* synthetic */ String access$calculateIpAddress(EmbraceNetworkConnectivityService $this) {
        return $this.calculateIpAddress();
    }
}

