/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk.capture.crash;

import io.embrace.android.embracesdk.Severity;
import io.embrace.android.embracesdk.anr.AnrService;
import io.embrace.android.embracesdk.arch.datasource.DataSourceImpl;
import io.embrace.android.embracesdk.arch.destination.LogWriter;
import io.embrace.android.embracesdk.arch.limits.NoopLimitStrategy;
import io.embrace.android.embracesdk.arch.schema.EmbType;
import io.embrace.android.embracesdk.arch.schema.SchemaType;
import io.embrace.android.embracesdk.arch.schema.TelemetryAttributes;
import io.embrace.android.embracesdk.capture.crash.CrashDataSource;
import io.embrace.android.embracesdk.capture.crash.EmbraceUncaughtExceptionHandler;
import io.embrace.android.embracesdk.config.ConfigService;
import io.embrace.android.embracesdk.internal.ApkToolsConfig;
import io.embrace.android.embracesdk.internal.crash.CrashFileMarker;
import io.embrace.android.embracesdk.internal.logs.LogOrchestrator;
import io.embrace.android.embracesdk.internal.serialization.EmbraceSerializer;
import io.embrace.android.embracesdk.internal.utils.EncodingExtensionsKt;
import io.embrace.android.embracesdk.internal.utils.Uuid;
import io.embrace.android.embracesdk.logging.EmbLogger;
import io.embrace.android.embracesdk.ndk.NdkService;
import io.embrace.android.embracesdk.opentelemetry.EmbraceAttributeKeysKt;
import io.embrace.android.embracesdk.payload.JsException;
import io.embrace.android.embracesdk.payload.LegacyExceptionInfo;
import io.embrace.android.embracesdk.payload.ThreadInfo;
import io.embrace.android.embracesdk.prefs.PreferencesService;
import io.embrace.android.embracesdk.session.orchestrator.SessionOrchestrator;
import io.embrace.android.embracesdk.session.properties.EmbraceSessionProperties;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.semconv.incubating.ExceptionIncubatingAttributes;
import io.opentelemetry.semconv.incubating.LogIncubatingAttributes;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u00012\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u0004B_\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0003\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u0012\u0006\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\u0002\u0010\u001aJ\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 H\u0002J\u0012\u0010\"\u001a\u00020 2\b\u0010#\u001a\u0004\u0018\u00010$H\u0002J\u0010\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0002J\b\u0010)\u001a\u00020 H\u0002J\u0010\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020$H\u0016J\u0010\u0010-\u001a\u00020+2\u0006\u0010,\u001a\u00020\u001cH\u0016J\b\u0010.\u001a\u00020+H\u0002R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lio/embrace/android/embracesdk/capture/crash/CrashDataSourceImpl;", "Lio/embrace/android/embracesdk/capture/crash/CrashDataSource;", "Lio/embrace/android/embracesdk/arch/datasource/DataSourceImpl;", "Lio/embrace/android/embracesdk/arch/destination/LogWriter;", "Lio/embrace/android/embracesdk/arch/datasource/LogDataSourceImpl;", "logOrchestrator", "Lio/embrace/android/embracesdk/internal/logs/LogOrchestrator;", "sessionOrchestrator", "Lio/embrace/android/embracesdk/session/orchestrator/SessionOrchestrator;", "sessionProperties", "Lio/embrace/android/embracesdk/session/properties/EmbraceSessionProperties;", "anrService", "Lio/embrace/android/embracesdk/anr/AnrService;", "ndkService", "Lio/embrace/android/embracesdk/ndk/NdkService;", "preferencesService", "Lio/embrace/android/embracesdk/prefs/PreferencesService;", "crashMarker", "Lio/embrace/android/embracesdk/internal/crash/CrashFileMarker;", "logWriter", "configService", "Lio/embrace/android/embracesdk/config/ConfigService;", "serializer", "Lio/embrace/android/embracesdk/internal/serialization/EmbraceSerializer;", "logger", "Lio/embrace/android/embracesdk/logging/EmbLogger;", "(Lio/embrace/android/embracesdk/internal/logs/LogOrchestrator;Lio/embrace/android/embracesdk/session/orchestrator/SessionOrchestrator;Lio/embrace/android/embracesdk/session/properties/EmbraceSessionProperties;Lio/embrace/android/embracesdk/anr/AnrService;Lio/embrace/android/embracesdk/ndk/NdkService;Lio/embrace/android/embracesdk/prefs/PreferencesService;Lio/embrace/android/embracesdk/internal/crash/CrashFileMarker;Lio/embrace/android/embracesdk/arch/destination/LogWriter;Lio/embrace/android/embracesdk/config/ConfigService;Lio/embrace/android/embracesdk/internal/serialization/EmbraceSerializer;Lio/embrace/android/embracesdk/logging/EmbLogger;)V", "jsException", "Lio/embrace/android/embracesdk/payload/JsException;", "mainCrashHandled", "", "encodeToUTF8String", "", "source", "getExceptionCause", "t", "", "getSchemaType", "Lio/embrace/android/embracesdk/arch/schema/SchemaType;", "attributes", "Lio/embrace/android/embracesdk/arch/schema/TelemetryAttributes;", "getThreadsInfo", "handleCrash", "", "exception", "logUnhandledJsException", "registerExceptionHandler", "embrace-android-sdk_release"})
public final class CrashDataSourceImpl
extends DataSourceImpl<LogWriter>
implements CrashDataSource {
    private boolean mainCrashHandled;
    private JsException jsException;
    private final LogOrchestrator logOrchestrator;
    private final SessionOrchestrator sessionOrchestrator;
    private final EmbraceSessionProperties sessionProperties;
    private final AnrService anrService;
    private final NdkService ndkService;
    private final PreferencesService preferencesService;
    private final CrashFileMarker crashMarker;
    private final LogWriter logWriter;
    private final ConfigService configService;
    private final EmbraceSerializer serializer;
    private final EmbLogger logger;

    @Override
    public void handleCrash(@NotNull Throwable exception) {
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        if (!this.mainCrashHandled) {
            String string2;
            this.mainCrashHandled = true;
            AnrService anrService2 = this.anrService;
            if (anrService2 != null) {
                anrService2.forceAnrTrackingStopOnCrash();
            }
            if ((string2 = this.ndkService.getUnityCrashId()) == null) {
                string2 = Uuid.getEmbUuid$default(null, 1, null);
            }
            String crashId = string2;
            int crashNumber = this.preferencesService.incrementAndGetCrashNumber();
            TelemetryAttributes crashAttributes = new TelemetryAttributes(this.configService, this.sessionProperties, null, 4, null);
            LegacyExceptionInfo crashException = LegacyExceptionInfo.Companion.ofThrowable(exception);
            AttributeKey attributeKey = ExceptionIncubatingAttributes.EXCEPTION_TYPE;
            Intrinsics.checkNotNullExpressionValue((Object)attributeKey, (String)"ExceptionIncubatingAttributes.EXCEPTION_TYPE");
            crashAttributes.setAttribute((AttributeKey<String>)attributeKey, crashException.getName());
            AttributeKey attributeKey2 = ExceptionIncubatingAttributes.EXCEPTION_MESSAGE;
            Intrinsics.checkNotNullExpressionValue((Object)attributeKey2, (String)"ExceptionIncubatingAttributes.EXCEPTION_MESSAGE");
            String string3 = crashException.getMessage();
            if (string3 == null) {
                string3 = "";
            }
            crashAttributes.setAttribute((AttributeKey<String>)attributeKey2, string3);
            AttributeKey attributeKey3 = ExceptionIncubatingAttributes.EXCEPTION_STACKTRACE;
            Intrinsics.checkNotNullExpressionValue((Object)attributeKey3, (String)"ExceptionIncubatingAttributes.EXCEPTION_STACKTRACE");
            crashAttributes.setAttribute((AttributeKey<String>)attributeKey3, this.encodeToUTF8String(this.serializer.toJson(crashException.getLines(), List.class)));
            AttributeKey attributeKey4 = LogIncubatingAttributes.LOG_RECORD_UID;
            Intrinsics.checkNotNullExpressionValue((Object)attributeKey4, (String)"LogIncubatingAttributes.LOG_RECORD_UID");
            crashAttributes.setAttribute((AttributeKey<String>)attributeKey4, crashId);
            crashAttributes.setAttribute(EmbraceAttributeKeysKt.getEmbCrashNumber(), String.valueOf(crashNumber));
            crashAttributes.setAttribute(EmbType.System.Crash.INSTANCE.getEmbAndroidCrashExceptionCause(), this.encodeToUTF8String(this.getExceptionCause(exception)));
            crashAttributes.setAttribute(EmbraceAttributeKeysKt.getEmbAndroidThreads(), this.encodeToUTF8String(this.getThreadsInfo()));
            JsException jsException = this.jsException;
            if (jsException != null) {
                JsException jsException2;
                JsException e = jsException2 = jsException;
                boolean bl = false;
                crashAttributes.setAttribute(EmbType.System.ReactNativeCrash.INSTANCE.getEmbAndroidReactNativeCrashJsException(), this.encodeToUTF8String(this.serializer.toJson(e, JsException.class)));
            }
            LogWriter.DefaultImpls.addLog$default(this.logWriter, this.getSchemaType(crashAttributes), Severity.ERROR, "", false, 8, null);
            this.logOrchestrator.flush(true);
            this.sessionOrchestrator.endSessionWithCrash(crashId);
            this.crashMarker.mark();
        }
    }

    @Override
    public void logUnhandledJsException(@NotNull JsException exception) {
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        this.jsException = exception;
    }

    private final SchemaType getSchemaType(TelemetryAttributes attributes) {
        return attributes.getAttribute(EmbType.System.ReactNativeCrash.INSTANCE.getEmbAndroidReactNativeCrashJsException()) != null ? (SchemaType)new SchemaType.ReactNativeCrash(attributes) : (SchemaType)new SchemaType.Crash(attributes);
    }

    private final String getExceptionCause(Throwable t) {
        LegacyExceptionInfo exceptionInfo;
        List result = new ArrayList();
        for (Throwable throwable = t; throwable != null && Intrinsics.areEqual((Object)throwable, (Object)throwable.getCause()) ^ true && !result.contains(exceptionInfo = LegacyExceptionInfo.Companion.ofThrowable(throwable)); throwable = throwable.getCause()) {
            result.add(0, exceptionInfo);
        }
        return this.serializer.toJson(result, List.class);
    }

    /*
     * WARNING - void declaration
     */
    private final String getThreadsInfo() {
        void $this$mapTo$iv$iv;
        Map<Thread, StackTraceElement[]> map = Thread.getAllStackTraces();
        Intrinsics.checkNotNullExpressionValue(map, (String)"Thread.getAllStackTraces()");
        Map<Thread, StackTraceElement[]> $this$map$iv = map;
        boolean $i$f$map = false;
        Map<Thread, StackTraceElement[]> map2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        void var7_6 = $this$mapTo$iv$iv;
        boolean bl = false;
        Iterator iterator = var7_6.entrySet().iterator();
        while (iterator.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            Object k = it.getKey();
            Intrinsics.checkNotNullExpressionValue(k, (String)"it.key");
            Thread thread = (Thread)k;
            Object v = it.getValue();
            Intrinsics.checkNotNullExpressionValue(v, (String)"it.value");
            ThreadInfo threadInfo = ThreadInfo.Companion.ofThread$default(ThreadInfo.Companion, thread, (StackTraceElement[])v, 0, 4, null);
            collection.add(threadInfo);
        }
        List threadsList = (List)destination$iv$iv;
        return this.serializer.toJson(threadsList, List.class);
    }

    private final String encodeToUTF8String(String source) {
        String string2 = source;
        Charset charset = Charsets.UTF_8;
        String string3 = string2;
        if (string3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string3.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        return EncodingExtensionsKt.toUTF8String(byArray);
    }

    private final void registerExceptionHandler() {
        Thread.UncaughtExceptionHandler defaultHandler = Thread.getDefaultUncaughtExceptionHandler();
        EmbraceUncaughtExceptionHandler embraceHandler = new EmbraceUncaughtExceptionHandler(defaultHandler, this, this.logger);
        Thread.setDefaultUncaughtExceptionHandler(embraceHandler);
    }

    public CrashDataSourceImpl(@NotNull LogOrchestrator logOrchestrator2, @NotNull SessionOrchestrator sessionOrchestrator2, @NotNull EmbraceSessionProperties sessionProperties2, @Nullable AnrService anrService2, @NotNull NdkService ndkService2, @NotNull PreferencesService preferencesService2, @NotNull CrashFileMarker crashMarker2, @NotNull LogWriter logWriter2, @NotNull ConfigService configService2, @NotNull EmbraceSerializer serializer, @NotNull EmbLogger logger2) {
        Intrinsics.checkNotNullParameter((Object)logOrchestrator2, (String)"logOrchestrator");
        Intrinsics.checkNotNullParameter((Object)sessionOrchestrator2, (String)"sessionOrchestrator");
        Intrinsics.checkNotNullParameter((Object)sessionProperties2, (String)"sessionProperties");
        Intrinsics.checkNotNullParameter((Object)ndkService2, (String)"ndkService");
        Intrinsics.checkNotNullParameter((Object)preferencesService2, (String)"preferencesService");
        Intrinsics.checkNotNullParameter((Object)crashMarker2, (String)"crashMarker");
        Intrinsics.checkNotNullParameter((Object)logWriter2, (String)"logWriter");
        Intrinsics.checkNotNullParameter((Object)configService2, (String)"configService");
        Intrinsics.checkNotNullParameter((Object)serializer, (String)"serializer");
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        super(logWriter2, logger2, NoopLimitStrategy.INSTANCE);
        this.logOrchestrator = logOrchestrator2;
        this.sessionOrchestrator = sessionOrchestrator2;
        this.sessionProperties = sessionProperties2;
        this.anrService = anrService2;
        this.ndkService = ndkService2;
        this.preferencesService = preferencesService2;
        this.crashMarker = crashMarker2;
        this.logWriter = logWriter2;
        this.configService = configService2;
        this.serializer = serializer;
        this.logger = logger2;
        if (this.configService.getAutoDataCaptureBehavior().isUncaughtExceptionHandlerEnabled() && !ApkToolsConfig.IS_EXCEPTION_CAPTURE_DISABLED) {
            this.registerExceptionHandler();
        }
    }
}

