/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk.capture.envelope.resource;

import android.util.DisplayMetrics;
import android.view.Display;
import android.view.WindowManager;
import io.embrace.android.embracesdk.capture.cpu.CpuInfoDelegate;
import io.embrace.android.embracesdk.capture.envelope.resource.Device;
import io.embrace.android.embracesdk.capture.envelope.resource.DeviceImpl;
import io.embrace.android.embracesdk.capture.envelope.resource.DeviceKt;
import io.embrace.android.embracesdk.capture.internal.errors.InternalErrorType;
import io.embrace.android.embracesdk.internal.SystemInfo;
import io.embrace.android.embracesdk.logging.EmbLogger;
import io.embrace.android.embracesdk.prefs.PreferencesService;
import io.embrace.android.embracesdk.worker.BackgroundWorker;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B7\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\b\u0010,\u001a\u00020-H\u0002J\b\u0010.\u001a\u00020-H\u0002J\b\u0010/\u001a\u00020\u001bH\u0002J\u0012\u0010'\u001a\u00020\u00102\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0016\u0010\u0013\u001a\u0004\u0018\u00010\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012R\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001e\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0096\u000e\u00a2\u0006\u0010\n\u0002\u0010\u001f\u001a\u0004\b\u001a\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00100!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\"\u001a\u00020#X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010&\u001a\u00020\u0010X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010\u0012\"\u0004\b(\u0010)R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lio/embrace/android/embracesdk/capture/envelope/resource/DeviceImpl;", "Lio/embrace/android/embracesdk/capture/envelope/resource/Device;", "windowManager", "Landroid/view/WindowManager;", "preferencesService", "Lio/embrace/android/embracesdk/prefs/PreferencesService;", "backgroundWorker", "Lio/embrace/android/embracesdk/worker/BackgroundWorker;", "systemInfo", "Lio/embrace/android/embracesdk/internal/SystemInfo;", "cpuInfoDelegate", "Lio/embrace/android/embracesdk/capture/cpu/CpuInfoDelegate;", "logger", "Lio/embrace/android/embracesdk/logging/EmbLogger;", "(Landroid/view/WindowManager;Lio/embrace/android/embracesdk/prefs/PreferencesService;Lio/embrace/android/embracesdk/worker/BackgroundWorker;Lio/embrace/android/embracesdk/internal/SystemInfo;Lio/embrace/android/embracesdk/capture/cpu/CpuInfoDelegate;Lio/embrace/android/embracesdk/logging/EmbLogger;)V", "cpuName", "", "getCpuName", "()Ljava/lang/String;", "eglInfo", "getEglInfo", "internalStorageTotalCapacity", "Lkotlin/Lazy;", "", "getInternalStorageTotalCapacity", "()Lkotlin/Lazy;", "isJailbroken", "", "()Ljava/lang/Boolean;", "setJailbroken", "(Ljava/lang/Boolean;)V", "Ljava/lang/Boolean;", "jailbreakLocations", "", "numberOfCores", "", "getNumberOfCores", "()I", "screenResolution", "getScreenResolution", "setScreenResolution", "(Ljava/lang/String;)V", "getSystemInfo", "()Lio/embrace/android/embracesdk/internal/SystemInfo;", "asyncRetrieveIsJailbroken", "", "asyncRetrieveScreenResolution", "checkIfIsJailbroken", "embrace-android-sdk_release"})
public final class DeviceImpl
implements Device {
    @Nullable
    private Boolean isJailbroken;
    @NotNull
    private String screenResolution;
    private final List<String> jailbreakLocations;
    private final int numberOfCores;
    @NotNull
    private final Lazy<Long> internalStorageTotalCapacity;
    @Nullable
    private final String cpuName;
    @Nullable
    private final String eglInfo;
    private final WindowManager windowManager;
    private final PreferencesService preferencesService;
    private final BackgroundWorker backgroundWorker;
    @NotNull
    private final SystemInfo systemInfo;
    private final EmbLogger logger;

    @Override
    @Nullable
    public Boolean isJailbroken() {
        return this.isJailbroken;
    }

    @Override
    public void setJailbroken(@Nullable Boolean bl) {
        this.isJailbroken = bl;
    }

    @Override
    @NotNull
    public String getScreenResolution() {
        return this.screenResolution;
    }

    @Override
    public void setScreenResolution(@NotNull String string2) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"<set-?>");
        this.screenResolution = string2;
    }

    private final void asyncRetrieveScreenResolution() {
        CharSequence charSequence = this.getScreenResolution();
        if (charSequence.length() > 0) {
            return;
        }
        BackgroundWorker.submit$default(this.backgroundWorker, null, new Runnable(this){
            final /* synthetic */ DeviceImpl this$0;

            public final void run() {
                String storedScreenResolution = DeviceImpl.access$getPreferencesService$p(this.this$0).getScreenResolution();
                if (storedScreenResolution != null) {
                    this.this$0.setScreenResolution(storedScreenResolution);
                } else {
                    this.this$0.setScreenResolution(DeviceImpl.access$getScreenResolution(this.this$0, DeviceImpl.access$getWindowManager$p(this.this$0)));
                    DeviceImpl.access$getPreferencesService$p(this.this$0).setScreenResolution(this.this$0.getScreenResolution());
                }
            }
            {
                this.this$0 = deviceImpl;
            }
        }, 1, null);
    }

    private final String getScreenResolution(WindowManager windowManager2) {
        String string2;
        try {
            WindowManager windowManager3 = windowManager2;
            Display display = windowManager3 != null ? windowManager3.getDefaultDisplay() : null;
            DisplayMetrics displayMetrics = new DisplayMetrics();
            Display display2 = display;
            if (display2 != null) {
                display2.getMetrics(displayMetrics);
            }
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            Locale locale = Locale.US;
            String string3 = "%dx%d";
            Object[] objectArray = new Object[]{displayMetrics.widthPixels, displayMetrics.heightPixels};
            String string4 = String.format(locale, string3, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"java.lang.String.format(locale, format, *args)");
            string2 = string4;
        }
        catch (Exception ex) {
            this.logger.logWarning("Could not determine screen resolution", ex);
            this.logger.trackInternalError(InternalErrorType.SCREEN_RES_CAPTURE_FAIL, ex);
            string2 = "";
        }
        return string2;
    }

    private final void asyncRetrieveIsJailbroken() {
        if (this.isJailbroken() != null) {
            return;
        }
        BackgroundWorker.submit$default(this.backgroundWorker, null, new Runnable(this){
            final /* synthetic */ DeviceImpl this$0;

            public final void run() {
                Boolean storedIsJailbroken = DeviceImpl.access$getPreferencesService$p(this.this$0).getJailbroken();
                if (storedIsJailbroken != null) {
                    this.this$0.setJailbroken(storedIsJailbroken);
                } else {
                    this.this$0.setJailbroken(DeviceImpl.access$checkIfIsJailbroken(this.this$0));
                    DeviceImpl.access$getPreferencesService$p(this.this$0).setJailbroken(this.this$0.isJailbroken());
                }
            }
            {
                this.this$0 = deviceImpl;
            }
        }, 1, null);
    }

    private final boolean checkIfIsJailbroken() {
        if (DeviceKt.isEmulator(this.getSystemInfo())) {
            return false;
        }
        for (String location : this.jailbreakLocations) {
            if (!new File(location + "su").exists()) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getNumberOfCores() {
        return this.numberOfCores;
    }

    @Override
    @NotNull
    public Lazy<Long> getInternalStorageTotalCapacity() {
        return this.internalStorageTotalCapacity;
    }

    @Override
    @Nullable
    public String getCpuName() {
        return this.cpuName;
    }

    @Override
    @Nullable
    public String getEglInfo() {
        return this.eglInfo;
    }

    @Override
    @NotNull
    public SystemInfo getSystemInfo() {
        return this.systemInfo;
    }

    public DeviceImpl(@Nullable WindowManager windowManager2, @NotNull PreferencesService preferencesService2, @NotNull BackgroundWorker backgroundWorker, @NotNull SystemInfo systemInfo, @NotNull CpuInfoDelegate cpuInfoDelegate2, @NotNull EmbLogger logger2) {
        Intrinsics.checkNotNullParameter((Object)preferencesService2, (String)"preferencesService");
        Intrinsics.checkNotNullParameter((Object)backgroundWorker, (String)"backgroundWorker");
        Intrinsics.checkNotNullParameter((Object)systemInfo, (String)"systemInfo");
        Intrinsics.checkNotNullParameter((Object)cpuInfoDelegate2, (String)"cpuInfoDelegate");
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        this.windowManager = windowManager2;
        this.preferencesService = preferencesService2;
        this.backgroundWorker = backgroundWorker;
        this.systemInfo = systemInfo;
        this.logger = logger2;
        this.screenResolution = "";
        this.jailbreakLocations = CollectionsKt.listOf((Object[])new String[]{"/sbin/", "/system/bin/", "/system/xbin/", "/data/local/xbin/", "/data/local/bin/", "/system/sd/xbin/", "/system/bin/failsafe/", "/data/local/"});
        this.asyncRetrieveIsJailbroken();
        this.asyncRetrieveScreenResolution();
        this.numberOfCores = Runtime.getRuntime().availableProcessors();
        this.internalStorageTotalCapacity = LazyKt.lazy((Function0)internalStorageTotalCapacity.1.INSTANCE);
        this.cpuName = cpuInfoDelegate2.getCpuName();
        this.eglInfo = cpuInfoDelegate2.getEgl();
    }

    public static final /* synthetic */ PreferencesService access$getPreferencesService$p(DeviceImpl $this) {
        return $this.preferencesService;
    }

    public static final /* synthetic */ String access$getScreenResolution(DeviceImpl $this, WindowManager windowManager2) {
        return $this.getScreenResolution(windowManager2);
    }

    public static final /* synthetic */ WindowManager access$getWindowManager$p(DeviceImpl $this) {
        return $this.windowManager;
    }

    public static final /* synthetic */ boolean access$checkIfIsJailbroken(DeviceImpl $this) {
        return $this.checkIfIsJailbroken();
    }
}

