/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk.capture.memory;

import android.app.Application;
import android.content.ComponentCallbacks;
import android.content.ComponentCallbacks2;
import android.content.res.Configuration;
import io.embrace.android.embracesdk.capture.memory.MemoryService;
import io.embrace.android.embracesdk.logging.EmbLogger;
import java.io.Closeable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000bH\u0016J\u0010\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lio/embrace/android/embracesdk/capture/memory/ComponentCallbackService;", "Landroid/content/ComponentCallbacks2;", "Ljava/io/Closeable;", "application", "Landroid/app/Application;", "memoryService", "Lio/embrace/android/embracesdk/capture/memory/MemoryService;", "logger", "Lio/embrace/android/embracesdk/logging/EmbLogger;", "(Landroid/app/Application;Lio/embrace/android/embracesdk/capture/memory/MemoryService;Lio/embrace/android/embracesdk/logging/EmbLogger;)V", "close", "", "onConfigurationChanged", "configuration", "Landroid/content/res/Configuration;", "onLowMemory", "onTrimMemory", "trimLevel", "", "embrace-android-sdk_release"})
public final class ComponentCallbackService
implements ComponentCallbacks2,
Closeable {
    private final Application application;
    private final MemoryService memoryService;
    private final EmbLogger logger;

    public void onTrimMemory(int trimLevel) {
        if (trimLevel == 10) {
            try {
                MemoryService memoryService2 = this.memoryService;
                if (memoryService2 != null) {
                    memoryService2.onMemoryWarning();
                }
            }
            catch (Exception ex) {
                this.logger.logWarning("Failed to handle onTrimMemory (low memory) event", ex);
            }
        }
    }

    public void onConfigurationChanged(@NotNull Configuration configuration) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
    }

    public void onLowMemory() {
    }

    @Override
    public void close() {
        try {
            this.application.getApplicationContext().unregisterComponentCallbacks((ComponentCallbacks)this);
        }
        catch (Exception ex) {
            this.logger.logWarning("Error when closing ComponentCallbackService", ex);
        }
    }

    public ComponentCallbackService(@NotNull Application application2, @Nullable MemoryService memoryService2, @NotNull EmbLogger logger2) {
        Intrinsics.checkNotNullParameter((Object)application2, (String)"application");
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        this.application = application2;
        this.memoryService = memoryService2;
        this.logger = logger2;
        this.application.getApplicationContext().registerComponentCallbacks((ComponentCallbacks)this);
    }
}

