/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk.capture.user;

import io.embrace.android.embracesdk.capture.internal.errors.InternalErrorType;
import io.embrace.android.embracesdk.capture.user.UserService;
import io.embrace.android.embracesdk.logging.EmbLogger;
import io.embrace.android.embracesdk.payload.UserInfo;
import io.embrace.android.embracesdk.prefs.PreferencesService;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0015\b\u0000\u0018\u0000 %2\u00020\u0001:\u0001%B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u000fH\u0016J\b\u0010\u0013\u001a\u00020\u000fH\u0016J\b\u0010\u0014\u001a\u00020\u000fH\u0016J\b\u0010\u0015\u001a\u00020\u000fH\u0016J\b\u0010\u0016\u001a\u00020\u000fH\u0016J\u0012\u0010\u0017\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\b\u0010\u0018\u001a\u00020\u000fH\u0016J\b\u0010\u0019\u001a\u00020\tH\u0016J\n\u0010\u001a\u001a\u0004\u0018\u00010\tH\u0016J\u0010\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\tH\u0002J\b\u0010\u001d\u001a\u00020\u000fH\u0016J\u0012\u0010\u001e\u001a\u00020\u000f2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0011H\u0016J\u0012\u0010 \u001a\u00020\u000f2\b\u0010!\u001a\u0004\u0018\u00010\u0011H\u0016J\u0012\u0010\"\u001a\u00020\u000f2\b\u0010#\u001a\u0004\u0018\u00010\u0011H\u0016J\b\u0010$\u001a\u00020\tH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\t0\bj\b\u0012\u0004\u0012\u00020\t`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000b\u001a\u0010\u0012\f\u0012\n \r*\u0004\u0018\u00010\t0\t0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lio/embrace/android/embracesdk/capture/user/EmbraceUserService;", "Lio/embrace/android/embracesdk/capture/user/UserService;", "preferencesService", "Lio/embrace/android/embracesdk/prefs/PreferencesService;", "logger", "Lio/embrace/android/embracesdk/logging/EmbLogger;", "(Lio/embrace/android/embracesdk/prefs/PreferencesService;Lio/embrace/android/embracesdk/logging/EmbLogger;)V", "userInfoProvider", "Lkotlin/Function0;", "Lio/embrace/android/embracesdk/payload/UserInfo;", "Lio/embrace/android/embracesdk/internal/utils/Provider;", "userInfoReference", "Ljava/util/concurrent/atomic/AtomicReference;", "kotlin.jvm.PlatformType", "addUserPersona", "", "persona", "", "clearAllUserInfo", "clearAllUserPersonas", "clearUserAsPayer", "clearUserEmail", "clearUserIdentifier", "clearUserPersona", "clearUsername", "getUserInfo", "loadUserInfoFromDisk", "modifyUserInfo", "newUserInfo", "setUserAsPayer", "setUserEmail", "email", "setUserIdentifier", "userId", "setUsername", "username", "userInfo", "Companion", "embrace-android-sdk_release"})
public final class EmbraceUserService
implements UserService {
    private final AtomicReference<UserInfo> userInfoReference;
    private final Function0<UserInfo> userInfoProvider;
    private final PreferencesService preferencesService;
    private final EmbLogger logger;
    @NotNull
    private static final Pattern VALID_PERSONA;
    public static final int PERSONA_LIMIT = 10;
    private static final UserInfo DEFAULT_USER;
    @NotNull
    public static final Companion Companion;

    @Override
    @Nullable
    public UserInfo loadUserInfoFromDisk() {
        UserInfo userInfo;
        try {
            userInfo = UserInfo.Companion.ofStored(this.preferencesService);
        }
        catch (Exception ex) {
            this.logger.logError("Failed to load user info from persistent storage.", ex);
            this.logger.trackInternalError(InternalErrorType.USER_LOAD_FAIL, ex);
            userInfo = null;
        }
        return userInfo;
    }

    @Override
    @NotNull
    public UserInfo getUserInfo() {
        return UserInfo.copy$default(this.userInfo(), null, null, null, null, 15, null);
    }

    @Override
    public void setUserIdentifier(@Nullable String userId) {
        String currentUserId = this.userInfo().getUserId();
        if (currentUserId != null && Intrinsics.areEqual((Object)currentUserId, (Object)userId)) {
            return;
        }
        this.modifyUserInfo(UserInfo.copy$default(this.userInfo(), userId, null, null, null, 14, null));
        this.preferencesService.setUserIdentifier(userId);
    }

    @Override
    public void clearUserIdentifier() {
        this.setUserIdentifier(null);
    }

    @Override
    public void setUsername(@Nullable String username) {
        String currentUserName = this.userInfo().getUsername();
        if (currentUserName != null && Intrinsics.areEqual((Object)currentUserName, (Object)username)) {
            return;
        }
        this.modifyUserInfo(UserInfo.copy$default(this.userInfo(), null, null, username, null, 11, null));
        this.preferencesService.setUsername(username);
    }

    @Override
    public void clearUsername() {
        this.setUsername(null);
    }

    @Override
    public void setUserEmail(@Nullable String email) {
        String currentEmail = this.userInfo().getEmail();
        if (currentEmail != null && Intrinsics.areEqual((Object)currentEmail, (Object)email)) {
            return;
        }
        this.modifyUserInfo(UserInfo.copy$default(this.userInfo(), null, email, null, null, 13, null));
        this.preferencesService.setUserEmailAddress(email);
    }

    @Override
    public void clearUserEmail() {
        this.setUserEmail(null);
    }

    @Override
    public void setUserAsPayer() {
        this.addUserPersona("payer");
    }

    @Override
    public void clearUserAsPayer() {
        this.clearUserPersona("payer");
    }

    @Override
    public void addUserPersona(@Nullable String persona) {
        Set set;
        if (persona == null) {
            return;
        }
        if (!VALID_PERSONA.matcher(persona).matches()) {
            EmbLogger.DefaultImpls.logWarning$default(this.logger, "Ignoring persona " + persona + " as it does not match " + VALID_PERSONA.pattern(), null, 2, null);
            return;
        }
        Set<String> currentPersonas = this.userInfo().getPersonas();
        if (currentPersonas != null) {
            if (currentPersonas.size() >= 10) {
                EmbLogger.DefaultImpls.logWarning$default(this.logger, "Cannot set persona as the limit of 10 has been reached", null, 2, null);
                return;
            }
            if (currentPersonas.contains(persona)) {
                return;
            }
        }
        if ((set = this.userInfo().getPersonas()) == null || (set = SetsKt.plus(set, (Object)persona)) == null) {
            set = SetsKt.mutableSetOf((Object[])new String[]{persona});
        }
        Set newPersonas = set;
        this.modifyUserInfo(UserInfo.copy$default(this.userInfo(), null, null, null, newPersonas, 7, null));
        this.preferencesService.setUserPersonas(newPersonas);
    }

    @Override
    public void clearUserPersona(@Nullable String persona) {
        if (persona == null) {
            return;
        }
        Set<String> currentPersonas = this.userInfo().getPersonas();
        if (currentPersonas != null && !currentPersonas.contains(persona)) {
            EmbLogger.DefaultImpls.logWarning$default(this.logger, "Persona '" + persona + "' is not set", null, 2, null);
            return;
        }
        Set set = this.userInfo().getPersonas();
        if (set == null || (set = SetsKt.minus(set, (Object)persona)) == null) {
            set = new LinkedHashSet();
        }
        Set newPersonas = set;
        this.modifyUserInfo(UserInfo.copy$default(this.userInfo(), null, null, null, newPersonas, 7, null));
        this.preferencesService.setUserPersonas(newPersonas);
    }

    @Override
    public void clearAllUserPersonas() {
        Set<String> currentPersonas = this.userInfo().getPersonas();
        if (currentPersonas != null && currentPersonas.isEmpty()) {
            return;
        }
        Set personas = new HashSet();
        if (this.preferencesService.getUserPayer()) {
            personas.add("payer");
        }
        if (this.preferencesService.isUsersFirstDay()) {
            personas.add("first_day");
        }
        this.modifyUserInfo(UserInfo.copy$default(this.userInfo(), null, null, null, personas, 7, null));
        this.preferencesService.setUserPersonas(personas);
    }

    @Override
    public void clearAllUserInfo() {
        this.clearUserIdentifier();
        this.clearUserEmail();
        this.clearUsername();
        this.clearAllUserPersonas();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final UserInfo userInfo() {
        if (this.userInfoReference.get() == DEFAULT_USER) {
            AtomicReference<UserInfo> atomicReference = this.userInfoReference;
            synchronized (atomicReference) {
                boolean bl = false;
                if (this.userInfoReference.get() == DEFAULT_USER) {
                    this.userInfoReference.set((UserInfo)this.userInfoProvider.invoke());
                }
                Unit unit = Unit.INSTANCE;
            }
        }
        UserInfo userInfo = this.userInfoReference.get();
        Intrinsics.checkNotNullExpressionValue((Object)userInfo, (String)"userInfoReference.get()");
        return userInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void modifyUserInfo(UserInfo newUserInfo) {
        AtomicReference<UserInfo> atomicReference = this.userInfoReference;
        synchronized (atomicReference) {
            boolean bl = false;
            this.userInfoReference.set(newUserInfo);
            Unit unit = Unit.INSTANCE;
        }
    }

    public EmbraceUserService(@NotNull PreferencesService preferencesService2, @NotNull EmbLogger logger2) {
        Intrinsics.checkNotNullParameter((Object)preferencesService2, (String)"preferencesService");
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        this.preferencesService = preferencesService2;
        this.logger = logger2;
        this.userInfoReference = new AtomicReference<UserInfo>(DEFAULT_USER);
        this.userInfoProvider = (Function0)new Function0<UserInfo>(this){
            final /* synthetic */ EmbraceUserService this$0;

            @NotNull
            public final UserInfo invoke() {
                return UserInfo.Companion.ofStored(EmbraceUserService.access$getPreferencesService$p(this.this$0));
            }
            {
                this.this$0 = embraceUserService;
                super(0);
            }
        };
    }

    static {
        Companion = new Companion(null);
        Pattern pattern = Pattern.compile("^[a-zA-Z0-9_]{1,32}$");
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"Pattern.compile(\"^[a-zA-Z0-9_]{1,32}$\")");
        VALID_PERSONA = pattern;
        DEFAULT_USER = new UserInfo("", "", "", SetsKt.emptySet());
    }

    public static final /* synthetic */ PreferencesService access$getPreferencesService$p(EmbraceUserService $this) {
        return $this.preferencesService;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lio/embrace/android/embracesdk/capture/user/EmbraceUserService$Companion;", "", "()V", "DEFAULT_USER", "Lio/embrace/android/embracesdk/payload/UserInfo;", "PERSONA_LIMIT", "", "VALID_PERSONA", "Ljava/util/regex/Pattern;", "getVALID_PERSONA", "()Ljava/util/regex/Pattern;", "embrace-android-sdk_release"})
    public static final class Companion {
        @NotNull
        public final Pattern getVALID_PERSONA() {
            return VALID_PERSONA;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

