/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk.capture.webview;

import io.embrace.android.embracesdk.arch.datasource.DataSourceState;
import io.embrace.android.embracesdk.capture.internal.errors.InternalErrorType;
import io.embrace.android.embracesdk.capture.webview.EmbraceWebViewService$WhenMappings;
import io.embrace.android.embracesdk.capture.webview.WebViewDataSource;
import io.embrace.android.embracesdk.capture.webview.WebViewService;
import io.embrace.android.embracesdk.config.ConfigService;
import io.embrace.android.embracesdk.injection.DataSourceModule;
import io.embrace.android.embracesdk.internal.serialization.EmbraceSerializer;
import io.embrace.android.embracesdk.logging.EmbLogger;
import io.embrace.android.embracesdk.payload.WebViewInfo;
import io.embrace.android.embracesdk.payload.WebVital;
import io.embrace.android.embracesdk.payload.WebVitalType;
import io.embrace.android.embracesdk.session.MemoryCleanerListener;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000b\b\u0000\u0018\u0000  2\u00020\u00012\u00020\u0002:\u0001 B9\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u001a\u0010\t\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\nj\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b`\f\u00a2\u0006\u0002\u0010\rJ\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u0012H\u0016J\u0018\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0012H\u0002J\b\u0010\u001b\u001a\u00020\u0016H\u0016J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0019\u001a\u00020\u0012H\u0002J\u0018\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020\u0013H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\"\u0010\t\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\nj\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0010\u001a\u001e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011j\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0013`\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lio/embrace/android/embracesdk/capture/webview/EmbraceWebViewService;", "Lio/embrace/android/embracesdk/capture/webview/WebViewService;", "Lio/embrace/android/embracesdk/session/MemoryCleanerListener;", "configService", "Lio/embrace/android/embracesdk/config/ConfigService;", "serializer", "Lio/embrace/android/embracesdk/internal/serialization/EmbraceSerializer;", "logger", "Lio/embrace/android/embracesdk/logging/EmbLogger;", "dataSourceModuleProvider", "Lkotlin/Function0;", "Lio/embrace/android/embracesdk/injection/DataSourceModule;", "Lio/embrace/android/embracesdk/internal/utils/Provider;", "(Lio/embrace/android/embracesdk/config/ConfigService;Lio/embrace/android/embracesdk/internal/serialization/EmbraceSerializer;Lio/embrace/android/embracesdk/logging/EmbLogger;Lkotlin/jvm/functions/Function0;)V", "getConfigService", "()Lio/embrace/android/embracesdk/config/ConfigService;", "webViewInfoMap", "Ljava/util/HashMap;", "", "Lio/embrace/android/embracesdk/payload/WebViewInfo;", "Lkotlin/collections/HashMap;", "cleanCollections", "", "collectWebData", "tag", "message", "collectWebVital", "loadDataIntoSession", "parseWebVital", "processVitalList", "newMessage", "storedMessage", "Companion", "embrace-android-sdk_release"})
public final class EmbraceWebViewService
implements WebViewService,
MemoryCleanerListener {
    private final HashMap<String, WebViewInfo> webViewInfoMap;
    @NotNull
    private final ConfigService configService;
    private final EmbraceSerializer serializer;
    private final EmbLogger logger;
    private final Function0<DataSourceModule> dataSourceModuleProvider;
    private static final int SCRIPT_MESSAGE_MAXIMUM_ALLOWED_LENGTH = 2000;
    private static final String MESSAGE_KEY_FOR_METRICS = "EMBRACE_METRIC";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    public void collectWebData(@NotNull String tag, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (StringsKt.contains$default((CharSequence)message, (CharSequence)MESSAGE_KEY_FOR_METRICS, (boolean)false, (int)2, null)) {
            this.collectWebVital(message, tag);
        } else {
            EmbLogger.DefaultImpls.logDebug$default(this.logger, "WebView console message ignored.", null, 2, null);
        }
    }

    @Override
    public void loadDataIntoSession() {
        block0: {
            Object object = (DataSourceModule)this.dataSourceModuleProvider.invoke();
            if (object == null || (object = object.getWebViewDataSource()) == null || (object = (WebViewDataSource)((DataSourceState)object).getDataSource()) == null) break block0;
            Collection<WebViewInfo> collection = this.webViewInfoMap.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"webViewInfoMap.values");
            ((WebViewDataSource)object).loadDataIntoSession(CollectionsKt.toList((Iterable)collection));
        }
    }

    private final void collectWebVital(String message, String tag) {
        block3: {
            WebViewInfo webViewInfo;
            WebViewInfo collectedWebVitals;
            if (this.webViewInfoMap.size() >= this.configService.getWebViewVitalsBehavior().getMaxWebViewVitals()) {
                EmbLogger.DefaultImpls.logDebug$default(this.logger, "Max webview vitals per session exceeded", null, 2, null);
                return;
            }
            WebViewInfo webViewInfo2 = collectedWebVitals = this.parseWebVital(message);
            if (webViewInfo2 == null) break block3;
            WebViewInfo it = webViewInfo = webViewInfo2;
            boolean bl = false;
            if (this.webViewInfoMap.get(it.getUrl() + it.getStartTime()) == null) {
                ((Map)this.webViewInfoMap).put(it.getUrl() + it.getStartTime(), WebViewInfo.copy$default(it, tag, null, null, 0L, new EnumMap(WebVitalType.class), 14, null));
            }
            WebViewInfo webViewInfo3 = this.webViewInfoMap.get(it.getUrl() + it.getStartTime());
            boolean bl2 = false;
            boolean bl3 = false;
            if (webViewInfo3 == null) {
                String string2 = "Required value was null.";
                throw (Throwable)new IllegalStateException(string2.toString());
            }
            ((Map)this.webViewInfoMap).put(it.getUrl() + it.getStartTime(), this.processVitalList(it, webViewInfo3));
        }
    }

    private final WebViewInfo processVitalList(WebViewInfo newMessage, WebViewInfo storedMessage) {
        Iterable $this$forEach$iv = newMessage.getWebVitals();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            WebVital webVital;
            WebVital newVital = (WebVital)element$iv;
            boolean bl = false;
            WebVital it = webVital = storedMessage.getWebVitalMap().get((Object)newVital.getType());
            boolean bl2 = false;
            if (it == null) {
                storedMessage.getWebVitalMap().put(newVital.getType(), newVital);
                continue;
            }
            switch (EmbraceWebViewService$WhenMappings.$EnumSwitchMapping$0[it.getType().ordinal()]) {
                case 1: {
                    Long l = newVital.getDuration();
                    Long l2 = it.getDuration();
                    if ((l != null ? l : 0L) <= (l2 != null ? l2 : 0L)) break;
                    storedMessage.getWebVitalMap().put(it.getType(), newVital);
                    break;
                }
                case 2: {
                    if (newVital.getStartTime() <= it.getStartTime()) break;
                    storedMessage.getWebVitalMap().put(it.getType(), newVital);
                    break;
                }
            }
        }
        return WebViewInfo.copy$default(storedMessage, null, CollectionsKt.toMutableList(storedMessage.getWebVitalMap().values()), null, 0L, null, 29, null);
    }

    private final WebViewInfo parseWebVital(String message) {
        try {
            if (message.length() < 2000) {
                return this.serializer.fromJson(message, WebViewInfo.class);
            }
            EmbLogger.DefaultImpls.logWarning$default(this.logger, "Web Vital info is too large to parse", null, 2, null);
        }
        catch (Exception e) {
            this.logger.logError("Cannot parse Web Vital", e);
            this.logger.trackInternalError(InternalErrorType.WEB_VITAL_PARSE_FAIL, e);
        }
        return null;
    }

    @Override
    public void cleanCollections() {
        this.webViewInfoMap.clear();
    }

    @NotNull
    public final ConfigService getConfigService() {
        return this.configService;
    }

    public EmbraceWebViewService(@NotNull ConfigService configService2, @NotNull EmbraceSerializer serializer, @NotNull EmbLogger logger2, @NotNull Function0<? extends DataSourceModule> dataSourceModuleProvider) {
        Intrinsics.checkNotNullParameter((Object)configService2, (String)"configService");
        Intrinsics.checkNotNullParameter((Object)serializer, (String)"serializer");
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        Intrinsics.checkNotNullParameter(dataSourceModuleProvider, (String)"dataSourceModuleProvider");
        this.configService = configService2;
        this.serializer = serializer;
        this.logger = logger2;
        this.dataSourceModuleProvider = dataSourceModuleProvider;
        this.webViewInfoMap = new HashMap();
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lio/embrace/android/embracesdk/capture/webview/EmbraceWebViewService$Companion;", "", "()V", "MESSAGE_KEY_FOR_METRICS", "", "SCRIPT_MESSAGE_MAXIMUM_ALLOWED_LENGTH", "", "embrace-android-sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

