/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk.comms.api;

import io.embrace.android.embracesdk.comms.api.EmbraceConnection;
import io.embrace.android.embracesdk.comms.api.EmbraceUrl;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;

class EmbraceConnectionImpl
implements EmbraceConnection {
    private HttpURLConnection httpUrlConnection;
    private EmbraceUrl url;
    private Integer responseCode = null;

    public EmbraceConnectionImpl(HttpURLConnection embraceConnection, EmbraceUrl url) {
        this.httpUrlConnection = embraceConnection;
        this.url = url;
    }

    @Override
    public boolean isHttps() {
        return this.httpUrlConnection instanceof HttpsURLConnection;
    }

    @Override
    public void setRequestMethod(String method) throws ProtocolException {
        this.httpUrlConnection.setRequestMethod(method);
    }

    @Override
    public void setDoOutput(Boolean doOutput) {
        this.httpUrlConnection.setDoOutput(doOutput);
    }

    @Override
    public void setConnectTimeout(Integer timeout) {
        this.httpUrlConnection.setConnectTimeout(timeout);
    }

    @Override
    public void setReadTimeout(Integer readTimeout) {
        this.httpUrlConnection.setReadTimeout(readTimeout);
    }

    @Override
    public void setRequestProperty(String key, String value) {
        this.httpUrlConnection.setRequestProperty(key, value);
    }

    @Override
    public EmbraceUrl getURL() {
        return this.url;
    }

    @Override
    public String getRequestMethod() {
        return this.httpUrlConnection.getRequestMethod();
    }

    @Override
    public String getHeaderField(String key) {
        return this.httpUrlConnection.getHeaderField(key);
    }

    @Override
    public Map<String, List<String>> getHeaderFields() {
        return this.httpUrlConnection.getHeaderFields();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.httpUrlConnection.getOutputStream();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.httpUrlConnection.getInputStream();
    }

    @Override
    public InputStream getErrorStream() {
        return this.httpUrlConnection.getErrorStream();
    }

    @Override
    public void connect() throws IOException {
        this.httpUrlConnection.connect();
    }

    @Override
    public int getResponseCode() throws IOException {
        if (this.responseCode == null) {
            return this.httpUrlConnection.getResponseCode();
        }
        return this.responseCode;
    }

    @Override
    public String getResponseMessage() throws IOException {
        return this.httpUrlConnection.getResponseMessage();
    }

    @Override
    public void setSSLSocketFactory(SSLSocketFactory factory) {
        ((HttpsURLConnection)this.httpUrlConnection).setSSLSocketFactory(factory);
    }

    @Override
    public SSLSocketFactory getSSLSocketFactory() {
        return ((HttpsURLConnection)this.httpUrlConnection).getSSLSocketFactory();
    }
}

