/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk.comms.delivery;

import io.embrace.android.embracesdk.comms.delivery.CacheService;
import io.embrace.android.embracesdk.comms.delivery.CachedSession;
import io.embrace.android.embracesdk.comms.delivery.DeliveryCacheManager;
import io.embrace.android.embracesdk.comms.delivery.PendingApiCall;
import io.embrace.android.embracesdk.comms.delivery.PendingApiCalls;
import io.embrace.android.embracesdk.comms.delivery.SessionPurgeException;
import io.embrace.android.embracesdk.internal.Systrace;
import io.embrace.android.embracesdk.internal.clock.ClockKt;
import io.embrace.android.embracesdk.internal.payload.Envelope;
import io.embrace.android.embracesdk.internal.payload.EnvelopeKt;
import io.embrace.android.embracesdk.internal.payload.SessionPayload;
import io.embrace.android.embracesdk.internal.payload.Span;
import io.embrace.android.embracesdk.internal.utils.Uuid;
import io.embrace.android.embracesdk.logging.EmbLogger;
import io.embrace.android.embracesdk.payload.EventMessage;
import io.embrace.android.embracesdk.session.orchestrator.SessionSnapshotType;
import io.embrace.android.embracesdk.worker.BackgroundWorker;
import io.embrace.android.embracesdk.worker.TaskPriority;
import java.io.Closeable;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\t\b\u0000\u0018\u0000 <2\u00020\u00012\u00020\u0002:\u0001<B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u000fH\u0016J\b\u0010\u0011\u001a\u00020\u000fH\u0002J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\fH\u0016J\u0010\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\fH\u0016J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\r0\u0017H\u0016J\n\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J/\u0010\u001a\u001a!\u0012\u0013\u0012\u00110\u001c\u00a2\u0006\f\b\u001d\u0012\b\b\u0013\u0012\u0004\b\b(\u001e\u0012\u0004\u0012\u00020\u000f0\u001bj\u0002`\u001f2\u0006\u0010\u0013\u001a\u00020\fH\u0016J\b\u0010 \u001a\u00020!H\u0016J\n\u0010\"\u001a\u0004\u0018\u00010!H\u0002J3\u0010#\u001a%\u0012\u0013\u0012\u00110\u001c\u00a2\u0006\f\b\u001d\u0012\b\b\u0013\u0012\u0004\b\b(\u001e\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u001bj\u0004\u0018\u0001`\u001f2\u0006\u0010\u0015\u001a\u00020\fH\u0016J\u0010\u0010$\u001a\u00020\u000f2\u0006\u0010%\u001a\u00020\u0019H\u0016J/\u0010&\u001a\u00020\f2%\u0010'\u001a!\u0012\u0013\u0012\u00110\u001c\u00a2\u0006\f\b\u001d\u0012\b\b\u0013\u0012\u0004\b\b(\u001e\u0012\u0004\u0012\u00020\u000f0\u001bj\u0002`\u001fH\u0016J\u0018\u0010(\u001a\u00020\u000f2\u0006\u0010)\u001a\u00020!2\u0006\u0010*\u001a\u00020+H\u0016J\u001e\u0010,\u001a\u00020\u000f2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020/0.2\u0006\u00100\u001a\u000201H\u0016JO\u00102\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\f2\u0006\u00103\u001a\u0002042\b\b\u0002\u00105\u001a\u00020+2\b\b\u0002\u00106\u001a\u00020+2!\u00107\u001a\u001d\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\u001d\u0012\b\b\u0013\u0012\u0004\b\b(8\u0012\u0004\u0012\u00020\u000f0\u001bH\u0002J;\u00109\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\f2\u0006\u00103\u001a\u0002042!\u00107\u001a\u001d\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\u001d\u0012\b\b\u0013\u0012\u0004\b\b(8\u0012\u0004\u0012\u00020\u000f0\u001bH\u0002J0\u0010:\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\f2\u001e\u0010;\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020/0.\u0012\n\u0012\b\u0012\u0004\u0012\u00020/0.0\u001bH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lio/embrace/android/embracesdk/comms/delivery/EmbraceDeliveryCacheManager;", "Ljava/io/Closeable;", "Lio/embrace/android/embracesdk/comms/delivery/DeliveryCacheManager;", "cacheService", "Lio/embrace/android/embracesdk/comms/delivery/CacheService;", "backgroundWorker", "Lio/embrace/android/embracesdk/worker/BackgroundWorker;", "logger", "Lio/embrace/android/embracesdk/logging/EmbLogger;", "(Lio/embrace/android/embracesdk/comms/delivery/CacheService;Lio/embrace/android/embracesdk/worker/BackgroundWorker;Lio/embrace/android/embracesdk/logging/EmbLogger;)V", "cachedSessions", "", "", "Lio/embrace/android/embracesdk/comms/delivery/CachedSession;", "close", "", "deleteCrash", "deleteOldestSessions", "deletePayload", "name", "deleteSession", "sessionId", "getAllCachedSessionIds", "", "loadCrash", "Lio/embrace/android/embracesdk/payload/EventMessage;", "loadPayloadAsAction", "Lkotlin/Function1;", "Ljava/io/OutputStream;", "Lkotlin/ParameterName;", "outputStream", "Lio/embrace/android/embracesdk/internal/utils/SerializationAction;", "loadPendingApiCalls", "Lio/embrace/android/embracesdk/comms/delivery/PendingApiCalls;", "loadPendingApiCallsOldVersion", "loadSessionAsAction", "saveCrash", "crash", "savePayload", "action", "savePendingApiCalls", "pendingApiCalls", "sync", "", "saveSession", "envelope", "Lio/embrace/android/embracesdk/internal/payload/Envelope;", "Lio/embrace/android/embracesdk/internal/payload/SessionPayload;", "snapshotType", "Lio/embrace/android/embracesdk/session/orchestrator/SessionSnapshotType;", "saveSessionBytes", "sessionStartTimeMs", "", "writeSync", "snapshot", "saveAction", "filename", "saveSessionBytesImpl", "transformSession", "transformer", "Companion", "embrace-android-sdk_release"})
public final class EmbraceDeliveryCacheManager
implements Closeable,
DeliveryCacheManager {
    private final Map<String, CachedSession> cachedSessions;
    private final CacheService cacheService;
    private final BackgroundWorker backgroundWorker;
    private final EmbLogger logger;
    private static final String CRASH_FILE_NAME = "crash.json";
    private static final String PENDING_API_CALLS_FILE_NAME = "failed_api_calls.json";
    public static final int MAX_SESSIONS_CACHED = 64;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    public void saveSession(@NotNull Envelope<SessionPayload> envelope, @NotNull SessionSnapshotType snapshotType) {
        Intrinsics.checkNotNullParameter(envelope, (String)"envelope");
        Intrinsics.checkNotNullParameter((Object)((Object)snapshotType), (String)"snapshotType");
        try {
            if (this.cachedSessions.size() >= 64) {
                this.deleteOldestSessions();
            }
            Span span = EnvelopeKt.getSessionSpan(envelope);
            String string2 = EnvelopeKt.getSessionId(envelope);
            if (string2 == null) {
                return;
            }
            String sessionId = string2;
            Object object = span;
            if (object == null || (object = ((Span)object).getStartTimeNanos()) == null) {
                return;
            }
            long sessionStartTimeMs = ClockKt.nanosToMillis((Long)object);
            boolean writeSync = snapshotType == SessionSnapshotType.JVM_CRASH;
            boolean snapshot = snapshotType == SessionSnapshotType.PERIODIC_CACHE;
            this.saveSessionBytes(sessionId, sessionStartTimeMs, writeSync, snapshot, (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(this, envelope){
                final /* synthetic */ EmbraceDeliveryCacheManager this$0;
                final /* synthetic */ Envelope $envelope;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void invoke(@NotNull String filename) {
                    Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
                    String sectionName$iv = "serialize-session";
                    boolean $i$f$traceSynchronous = false;
                    Unit returnValue$iv = null;
                    try {
                        Systrace.startSynchronous(sectionName$iv);
                        boolean bl = false;
                        EmbraceDeliveryCacheManager.access$getCacheService$p(this.this$0).writeSession(filename, this.$envelope);
                        returnValue$iv = Unit.INSTANCE;
                    }
                    catch (Throwable t$iv) {
                        throw t$iv;
                    }
                    finally {
                        Systrace.endSynchronous();
                    }
                }
                {
                    this.this$0 = embraceDeliveryCacheManager;
                    this.$envelope = envelope;
                    super(1);
                }
            }));
        }
        catch (Throwable exc) {
            this.logger.logError("Save session failed", exc);
            throw exc;
        }
    }

    @Override
    @Nullable
    public Function1<OutputStream, Unit> loadSessionAsAction(@NotNull String sessionId) {
        Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
        CachedSession cachedSession = this.cachedSessions.get(sessionId);
        if (cachedSession != null) {
            CachedSession cachedSession2;
            CachedSession cachedSession3 = cachedSession2 = cachedSession;
            boolean bl = false;
            return this.loadPayloadAsAction(cachedSession3.getFilename());
        }
        EmbLogger.DefaultImpls.logError$default(this.logger, "Session " + sessionId + " is not in cache", null, 2, null);
        return null;
    }

    @Override
    public void deleteSession(@NotNull String sessionId) {
        block0: {
            CachedSession cachedSession;
            Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
            CachedSession cachedSession2 = this.cachedSessions.get(sessionId);
            if (cachedSession2 == null) break block0;
            CachedSession cachedSession3 = cachedSession = cachedSession2;
            boolean bl = false;
            BackgroundWorker.submit$default(this.backgroundWorker, null, new Runnable(cachedSession3, this, sessionId){
                final /* synthetic */ CachedSession $cachedSession;
                final /* synthetic */ EmbraceDeliveryCacheManager this$0;
                final /* synthetic */ String $sessionId$inlined;
                {
                    this.$cachedSession = cachedSession;
                    this.this$0 = embraceDeliveryCacheManager;
                    this.$sessionId$inlined = string2;
                }

                public final void run() {
                    try {
                        EmbraceDeliveryCacheManager.access$getCacheService$p(this.this$0).deleteFile(this.$cachedSession.getFilename());
                        EmbraceDeliveryCacheManager.access$getCachedSessions$p(this.this$0).remove(this.$sessionId$inlined);
                    }
                    catch (Exception ex) {
                        EmbLogger.DefaultImpls.logError$default(EmbraceDeliveryCacheManager.access$getLogger$p(this.this$0), "Could not remove session from cache: " + this.$sessionId$inlined, null, 2, null);
                    }
                }
            }, 1, null);
        }
    }

    @Override
    @NotNull
    public List<CachedSession> getAllCachedSessionIds() {
        List<String> sessionFileIds = this.cacheService.normalizeCacheAndGetSessionFileIds();
        Iterable $this$forEach$iv = sessionFileIds;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String filename = (String)element$iv;
            boolean bl = false;
            if (CachedSession.Companion.fromFilename(filename) != null) {
                CachedSession cachedSession;
                CachedSession cachedSession2 = cachedSession;
                boolean bl2 = false;
                this.cachedSessions.put(cachedSession2.getSessionId(), cachedSession2);
                continue;
            }
            EmbLogger.DefaultImpls.logError$default(this.logger, "Unrecognized cached file: " + filename, null, 2, null);
        }
        return CollectionsKt.toList((Iterable)this.cachedSessions.values());
    }

    @Override
    public void saveCrash(@NotNull EventMessage crash) {
        Intrinsics.checkNotNullParameter((Object)crash, (String)"crash");
        this.cacheService.cacheObject(CRASH_FILE_NAME, crash, (Type)((Object)EventMessage.class));
    }

    @Override
    @Nullable
    public EventMessage loadCrash() {
        return (EventMessage)this.cacheService.loadObject(CRASH_FILE_NAME, (Type)((Object)EventMessage.class));
    }

    @Override
    public void deleteCrash() {
        this.cacheService.deleteFile(CRASH_FILE_NAME);
    }

    @Override
    @NotNull
    public String savePayload(@NotNull Function1<? super OutputStream, Unit> action2) {
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        String name = "payload_" + Uuid.getEmbUuid$default(null, 1, null);
        BackgroundWorker.submit$default(this.backgroundWorker, null, new Runnable(this, name, action2){
            final /* synthetic */ EmbraceDeliveryCacheManager this$0;
            final /* synthetic */ String $name;
            final /* synthetic */ Function1 $action;

            public final void run() {
                EmbraceDeliveryCacheManager.access$getCacheService$p(this.this$0).cachePayload(this.$name, (Function1<? super OutputStream, Unit>)this.$action);
            }
            {
                this.this$0 = embraceDeliveryCacheManager;
                this.$name = string2;
                this.$action = function1;
            }
        }, 1, null);
        return name;
    }

    @Override
    @NotNull
    public Function1<OutputStream, Unit> loadPayloadAsAction(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.cacheService.loadPayload(name);
    }

    @Override
    public void deletePayload(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        BackgroundWorker.submit$default(this.backgroundWorker, null, new Runnable(this, name){
            final /* synthetic */ EmbraceDeliveryCacheManager this$0;
            final /* synthetic */ String $name;

            public final void run() {
                EmbraceDeliveryCacheManager.access$getCacheService$p(this.this$0).deleteFile(this.$name);
            }
            {
                this.this$0 = embraceDeliveryCacheManager;
                this.$name = string2;
            }
        }, 1, null);
    }

    @Override
    public void savePendingApiCalls(@NotNull PendingApiCalls pendingApiCalls2, boolean sync) {
        Intrinsics.checkNotNullParameter((Object)pendingApiCalls2, (String)"pendingApiCalls");
        if (sync) {
            this.cacheService.cacheObject(PENDING_API_CALLS_FILE_NAME, pendingApiCalls2, (Type)((Object)PendingApiCalls.class));
        } else {
            BackgroundWorker.submit$default(this.backgroundWorker, null, new Runnable(this, pendingApiCalls2){
                final /* synthetic */ EmbraceDeliveryCacheManager this$0;
                final /* synthetic */ PendingApiCalls $pendingApiCalls;

                public final void run() {
                    EmbraceDeliveryCacheManager.access$getCacheService$p(this.this$0).cacheObject("failed_api_calls.json", this.$pendingApiCalls, (Type)((Object)PendingApiCalls.class));
                }
                {
                    this.this$0 = embraceDeliveryCacheManager;
                    this.$pendingApiCalls = pendingApiCalls2;
                }
            }, 1, null);
        }
    }

    @Override
    @NotNull
    public PendingApiCalls loadPendingApiCalls() {
        PendingApiCalls pendingApiCalls2;
        Object object;
        EmbraceDeliveryCacheManager embraceDeliveryCacheManager = this;
        try {
            object = Result.Companion;
            EmbraceDeliveryCacheManager $this$runCatching = embraceDeliveryCacheManager;
            boolean bl = false;
            PendingApiCalls pendingApiCalls3 = (PendingApiCalls)$this$runCatching.cacheService.loadObject(PENDING_API_CALLS_FILE_NAME, (Type)((Object)PendingApiCalls.class));
            boolean bl2 = false;
            object = Result.constructor-impl((Object)pendingApiCalls3);
        }
        catch (Throwable throwable) {
            Result.Companion companion = Result.Companion;
            boolean bl = false;
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        embraceDeliveryCacheManager = object;
        PendingApiCalls pendingApiCalls4 = (PendingApiCalls)((Object)(Result.isFailure-impl((Object)embraceDeliveryCacheManager) ? null : embraceDeliveryCacheManager));
        if (pendingApiCalls4 == null) {
            pendingApiCalls4 = pendingApiCalls2 = this.loadPendingApiCallsOldVersion();
        }
        if (pendingApiCalls4 == null) {
            pendingApiCalls2 = new PendingApiCalls(null, 1, null);
        }
        return pendingApiCalls2;
    }

    @Override
    public void transformSession(@NotNull String sessionId, @NotNull Function1<? super Envelope<SessionPayload>, Envelope<SessionPayload>> transformer) {
        Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
        Intrinsics.checkNotNullParameter(transformer, (String)"transformer");
        Object object = this.cachedSessions.get(sessionId);
        if (object == null || (object = ((CachedSession)object).getFilename()) == null) {
            return;
        }
        Object filename = object;
        this.cacheService.transformSession((String)filename, transformer);
    }

    private final PendingApiCalls loadPendingApiCallsOldVersion() {
        Object object;
        PendingApiCalls cachedApiCallsPerEndpoint = null;
        EmbraceDeliveryCacheManager embraceDeliveryCacheManager = this;
        try {
            object = Result.Companion;
            EmbraceDeliveryCacheManager $this$runCatching = embraceDeliveryCacheManager;
            boolean bl = false;
            List<PendingApiCall> list = $this$runCatching.cacheService.loadOldPendingApiCalls(PENDING_API_CALLS_FILE_NAME);
            bl = false;
            object = Result.constructor-impl(list);
        }
        catch (Throwable throwable) {
            Result.Companion bl = Result.Companion;
            boolean bl2 = false;
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        Object loadPendingApiCallsQueue = object;
        if (Result.isSuccess-impl((Object)loadPendingApiCallsQueue)) {
            cachedApiCallsPerEndpoint = new PendingApiCalls(null, 1, null);
            embraceDeliveryCacheManager = loadPendingApiCallsQueue;
            List list = (List)((Object)(Result.isFailure-impl((Object)embraceDeliveryCacheManager) ? null : embraceDeliveryCacheManager));
            if (list != null) {
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    PendingApiCall cachedApiCall = (PendingApiCall)element$iv;
                    boolean bl = false;
                    cachedApiCallsPerEndpoint.add(cachedApiCall);
                }
            }
        }
        return cachedApiCallsPerEndpoint;
    }

    @Override
    public void close() {
    }

    private final void deleteOldestSessions() {
        Iterable $this$sortedBy$iv = this.cachedSessions.values();
        boolean $i$f$sortedBy = false;
        boolean bl = false;
        List sessionsToPurge = CollectionsKt.take((Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                CachedSession it = (CachedSession)a;
                boolean bl2 = false;
                Comparable comparable = Long.valueOf(it.getTimestampMs());
                it = (CachedSession)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                Long l = it.getTimestampMs();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)l);
            }
        }), (int)(this.cachedSessions.size() - 64 + 1));
        if (!($this$sortedBy$iv = (Collection)sessionsToPurge).isEmpty()) {
            Iterable $this$forEach$iv = sessionsToPurge;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CachedSession it = (CachedSession)element$iv;
                boolean bl2 = false;
                String message = "Too many cached sessions. Purging session with file name " + it.getFilename();
                this.logger.logWarning(message, new SessionPurgeException(message));
                this.deleteSession(it.getSessionId());
            }
        }
    }

    private final void saveSessionBytes(String sessionId, long sessionStartTimeMs, boolean writeSync, boolean snapshot, Function1<? super String, Unit> saveAction) {
        if (writeSync) {
            this.saveSessionBytesImpl(sessionId, sessionStartTimeMs, saveAction);
        } else {
            TaskPriority priority = snapshot ? TaskPriority.LOW : TaskPriority.CRITICAL;
            this.backgroundWorker.submit(priority, new Runnable(this, sessionId, sessionStartTimeMs, saveAction){
                final /* synthetic */ EmbraceDeliveryCacheManager this$0;
                final /* synthetic */ String $sessionId;
                final /* synthetic */ long $sessionStartTimeMs;
                final /* synthetic */ Function1 $saveAction;

                public final void run() {
                    EmbraceDeliveryCacheManager.access$saveSessionBytesImpl(this.this$0, this.$sessionId, this.$sessionStartTimeMs, this.$saveAction);
                }
                {
                    this.this$0 = embraceDeliveryCacheManager;
                    this.$sessionId = string2;
                    this.$sessionStartTimeMs = l;
                    this.$saveAction = function1;
                }
            });
        }
    }

    static /* synthetic */ void saveSessionBytes$default(EmbraceDeliveryCacheManager embraceDeliveryCacheManager, String string2, long l, boolean bl, boolean bl2, Function1 function1, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            bl2 = false;
        }
        embraceDeliveryCacheManager.saveSessionBytes(string2, l, bl, bl2, (Function1<? super String, Unit>)function1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void saveSessionBytesImpl(String sessionId, long sessionStartTimeMs, Function1<? super String, Unit> saveAction) {
        try {
            Map<String, CachedSession> map = this.cachedSessions;
            synchronized (map) {
                boolean bl = false;
                Unit unit = this.cachedSessions;
                String string2 = sessionId;
                CachedSession cachedSession = unit.get(string2);
                if (cachedSession == null) {
                    boolean bl2 = false;
                    cachedSession = CachedSession.Companion.create$default(CachedSession.Companion, sessionId, sessionStartTimeMs, false, 4, null);
                }
                CachedSession cachedSession2 = cachedSession;
                saveAction.invoke((Object)cachedSession2.getFilename());
                if (!this.cachedSessions.containsKey(cachedSession2.getSessionId())) {
                    this.cachedSessions.put(cachedSession2.getSessionId(), cachedSession2);
                }
                unit = Unit.INSTANCE;
            }
        }
        catch (Throwable ex) {
            this.logger.logError("Failed to cache current active session", ex);
        }
    }

    public EmbraceDeliveryCacheManager(@NotNull CacheService cacheService2, @NotNull BackgroundWorker backgroundWorker, @NotNull EmbLogger logger2) {
        Intrinsics.checkNotNullParameter((Object)cacheService2, (String)"cacheService");
        Intrinsics.checkNotNullParameter((Object)backgroundWorker, (String)"backgroundWorker");
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        this.cacheService = cacheService2;
        this.backgroundWorker = backgroundWorker;
        this.logger = logger2;
        this.cachedSessions = new LinkedHashMap();
    }

    public static final /* synthetic */ CacheService access$getCacheService$p(EmbraceDeliveryCacheManager $this) {
        return $this.cacheService;
    }

    public static final /* synthetic */ Map access$getCachedSessions$p(EmbraceDeliveryCacheManager $this) {
        return $this.cachedSessions;
    }

    public static final /* synthetic */ EmbLogger access$getLogger$p(EmbraceDeliveryCacheManager $this) {
        return $this.logger;
    }

    public static final /* synthetic */ void access$saveSessionBytesImpl(EmbraceDeliveryCacheManager $this, String sessionId, long sessionStartTimeMs, Function1 saveAction) {
        $this.saveSessionBytesImpl(sessionId, sessionStartTimeMs, (Function1<? super String, Unit>)saveAction);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lio/embrace/android/embracesdk/comms/delivery/EmbraceDeliveryCacheManager$Companion;", "", "()V", "CRASH_FILE_NAME", "", "MAX_SESSIONS_CACHED", "", "PENDING_API_CALLS_FILE_NAME", "embrace-android-sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

