/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk.config;

import android.content.res.Resources;
import android.util.Base64;
import io.embrace.android.embracesdk.config.local.LocalConfig;
import io.embrace.android.embracesdk.config.local.SdkLocalConfig;
import io.embrace.android.embracesdk.internal.AndroidResourcesService;
import io.embrace.android.embracesdk.internal.ApkToolsConfig;
import io.embrace.android.embracesdk.internal.serialization.EmbraceSerializer;
import io.embrace.android.embracesdk.logging.EmbLogger;
import io.embrace.android.embracesdk.opentelemetry.OpenTelemetryConfiguration;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J:\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\f\u001a\u00020\b2\b\u0010\r\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J:\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00042\b\u0010\u0018\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J$\u0010\u0019\u001a\u0004\u0018\u00010\u00042\b\u0010\u0018\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lio/embrace/android/embracesdk/config/LocalConfigParser;", "", "()V", "BUILD_INFO_APP_ID", "", "BUILD_INFO_NDK_ENABLED", "BUILD_INFO_SDK_CONFIG", "NDK_ENABLED_DEFAULT", "", "buildConfig", "Lio/embrace/android/embracesdk/config/local/LocalConfig;", "appId", "ndkEnabled", "sdkConfigs", "serializer", "Lio/embrace/android/embracesdk/internal/serialization/EmbraceSerializer;", "openTelemetryCfg", "Lio/embrace/android/embracesdk/opentelemetry/OpenTelemetryConfiguration;", "logger", "Lio/embrace/android/embracesdk/logging/EmbLogger;", "fromResources", "resources", "Lio/embrace/android/embracesdk/internal/AndroidResourcesService;", "packageName", "customAppId", "resolveAppId", "embrace-android-sdk_release"})
public final class LocalConfigParser {
    @NotNull
    public static final String BUILD_INFO_APP_ID = "emb_app_id";
    private static final String BUILD_INFO_SDK_CONFIG = "emb_sdk_config";
    @NotNull
    public static final String BUILD_INFO_NDK_ENABLED = "emb_ndk_enabled";
    public static final boolean NDK_ENABLED_DEFAULT = false;
    @NotNull
    public static final LocalConfigParser INSTANCE;

    @JvmStatic
    @NotNull
    public static final LocalConfig fromResources(@NotNull AndroidResourcesService resources2, @NotNull String packageName, @Nullable String customAppId, @NotNull EmbraceSerializer serializer, @NotNull OpenTelemetryConfiguration openTelemetryCfg, @NotNull EmbLogger logger2) {
        LocalConfig localConfig;
        Intrinsics.checkNotNullParameter((Object)resources2, (String)"resources");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter((Object)serializer, (String)"serializer");
        Intrinsics.checkNotNullParameter((Object)openTelemetryCfg, (String)"openTelemetryCfg");
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        try {
            String string2;
            String appId2 = INSTANCE.resolveAppId(customAppId, resources2, packageName);
            int ndkEnabledJsonId = resources2.getIdentifier(BUILD_INFO_NDK_ENABLED, "string", packageName);
            boolean ndkEnabled = (ndkEnabledJsonId != 0 ? Boolean.parseBoolean(resources2.getString(ndkEnabledJsonId)) : false) && !ApkToolsConfig.IS_NDK_DISABLED;
            int sdkConfigJsonId = resources2.getIdentifier(BUILD_INFO_SDK_CONFIG, "string", packageName);
            if (sdkConfigJsonId != 0) {
                String encodedConfig = resources2.getString(sdkConfigJsonId);
                byte[] byArray = Base64.decode((String)encodedConfig, (int)0);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"Base64.decode(encodedConfig, Base64.DEFAULT)");
                byte[] byArray2 = byArray;
                string2 = new String(byArray2, Charsets.UTF_8);
            } else {
                string2 = null;
            }
            String sdkConfigJson = string2;
            localConfig = INSTANCE.buildConfig(appId2, ndkEnabled, sdkConfigJson, serializer, openTelemetryCfg, logger2);
        }
        catch (Exception ex) {
            throw (Throwable)new IllegalStateException("Failed to load local config from resources.", ex);
        }
        return localConfig;
    }

    private final String resolveAppId(String customAppId, AndroidResourcesService resources2, String packageName) {
        String string2;
        try {
            String string3 = customAppId;
            if (string3 == null) {
                string3 = resources2.getString(resources2.getIdentifier(BUILD_INFO_APP_ID, "string", packageName));
            }
            string2 = string3;
        }
        catch (Resources.NotFoundException exc) {
            string2 = null;
        }
        return string2;
    }

    @NotNull
    public final LocalConfig buildConfig(@Nullable String appId2, boolean ndkEnabled, @Nullable String sdkConfigs, @NotNull EmbraceSerializer serializer, @NotNull OpenTelemetryConfiguration openTelemetryCfg, @NotNull EmbLogger logger2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)serializer, (String)"serializer");
        Intrinsics.checkNotNullParameter((Object)openTelemetryCfg, (String)"openTelemetryCfg");
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        CharSequence charSequence = appId2;
        boolean bl2 = bl = !(charSequence == null || charSequence.length() == 0) || openTelemetryCfg.hasConfiguredOtelExporters();
        if (!bl) {
            boolean bl3 = false;
            String string2 = "No appId supplied in embrace-config.json. This is required if you want to send data to Embrace, unless you configure an OTel exporter and add embrace.disableMappingFileUpload=true to gradle.properties.";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        String enabledStr = ndkEnabled ? "enabled" : "disabled";
        EmbLogger.DefaultImpls.logInfo$default(logger2, "Native crash capture is " + enabledStr, null, 2, null);
        SdkLocalConfig configs = null;
        CharSequence charSequence2 = sdkConfigs;
        if (!(charSequence2 == null || charSequence2.length() == 0)) {
            try {
                configs = serializer.fromJson(sdkConfigs, SdkLocalConfig.class);
            }
            catch (Exception ex) {
                logger2.logError("Failed to parse Embrace config from config json file.", ex);
            }
        }
        if (configs == null) {
            configs = new SdkLocalConfig(null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 262143, null);
        }
        return new LocalConfig(appId2, ndkEnabled, configs);
    }

    private LocalConfigParser() {
    }

    static {
        LocalConfigParser localConfigParser;
        INSTANCE = localConfigParser = new LocalConfigParser();
    }
}

