/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk.event;

import io.embrace.android.embracesdk.EventType;
import io.embrace.android.embracesdk.capture.metadata.MetadataService;
import io.embrace.android.embracesdk.capture.user.UserService;
import io.embrace.android.embracesdk.comms.delivery.DeliveryService;
import io.embrace.android.embracesdk.config.ConfigService;
import io.embrace.android.embracesdk.internal.EventDescription;
import io.embrace.android.embracesdk.internal.StartupEventInfo;
import io.embrace.android.embracesdk.internal.clock.Clock;
import io.embrace.android.embracesdk.logging.EmbLogger;
import io.embrace.android.embracesdk.payload.AppInfo;
import io.embrace.android.embracesdk.payload.DeviceInfo;
import io.embrace.android.embracesdk.payload.Event;
import io.embrace.android.embracesdk.payload.EventMessage;
import io.embrace.android.embracesdk.payload.NativeCrash;
import io.embrace.android.embracesdk.payload.Stacktraces;
import io.embrace.android.embracesdk.payload.UserInfo;
import io.embrace.android.embracesdk.session.id.SessionIdTracker;
import io.embrace.android.embracesdk.session.properties.EmbraceSessionProperties;
import io.embrace.android.embracesdk.worker.ScheduledWorker;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001BE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012JF\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0014\u0010\u001d\u001a\u0010\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u001eH\u0002J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0014H\u0002JF\u0010#\u001a\u00020\u00142\u0006\u0010$\u001a\u00020\u001f2\u0006\u0010%\u001a\u00020\u001f2\u0006\u0010&\u001a\u00020\u00172\u0006\u0010'\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001c2\u0014\u0010\u001d\u001a\u0010\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u001eH\u0002J\u0010\u0010(\u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0014H\u0002J\u0016\u0010)\u001a\u00020*2\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010+\u001a\u00020\u0014J\u0010\u0010,\u001a\u00020\u00172\u0006\u0010$\u001a\u00020\u001fH\u0002J\u0018\u0010-\u001a\u00020\u00172\u0006\u0010&\u001a\u00020\u00172\u0006\u0010'\u001a\u00020\u0017H\u0002J\u000e\u0010.\u001a\u00020\u001a2\u0006\u0010%\u001a\u00020\u001fJ4\u0010/\u001a\u00020!2\u0006\u00100\u001a\u0002012\u0006\u0010\u0019\u001a\u00020\u001a2\u0014\u0010\u001d\u001a\u0010\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u001e2\u0006\u0010\u001b\u001a\u00020\u001cJD\u00102\u001a\u0002012\u0006\u0010$\u001a\u00020\u001f2\u0006\u0010%\u001a\u00020\u001f2\u0006\u0010&\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001c2\u0014\u0010\u001d\u001a\u0010\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u001e2\u0006\u00103\u001a\u000204J\u0012\u00105\u001a\u00020\u001a2\b\u00106\u001a\u0004\u0018\u00010\u001fH\u0002R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lio/embrace/android/embracesdk/event/EventHandler;", "", "metadataService", "Lio/embrace/android/embracesdk/capture/metadata/MetadataService;", "sessionIdTracker", "Lio/embrace/android/embracesdk/session/id/SessionIdTracker;", "configService", "Lio/embrace/android/embracesdk/config/ConfigService;", "userService", "Lio/embrace/android/embracesdk/capture/user/UserService;", "deliveryService", "Lio/embrace/android/embracesdk/comms/delivery/DeliveryService;", "logger", "Lio/embrace/android/embracesdk/logging/EmbLogger;", "clock", "Lio/embrace/android/embracesdk/internal/clock/Clock;", "scheduledWorker", "Lio/embrace/android/embracesdk/worker/ScheduledWorker;", "(Lio/embrace/android/embracesdk/capture/metadata/MetadataService;Lio/embrace/android/embracesdk/session/id/SessionIdTracker;Lio/embrace/android/embracesdk/config/ConfigService;Lio/embrace/android/embracesdk/capture/user/UserService;Lio/embrace/android/embracesdk/comms/delivery/DeliveryService;Lio/embrace/android/embracesdk/logging/EmbLogger;Lio/embrace/android/embracesdk/internal/clock/Clock;Lio/embrace/android/embracesdk/worker/ScheduledWorker;)V", "buildEndEvent", "Lio/embrace/android/embracesdk/payload/Event;", "originEvent", "endTime", "", "duration", "late", "", "sessionProperties", "Lio/embrace/android/embracesdk/session/properties/EmbraceSessionProperties;", "eventProperties", "", "", "buildEndEventMessage", "Lio/embrace/android/embracesdk/payload/EventMessage;", "event", "buildStartEvent", "eventId", "eventName", "startTime", "threshold", "buildStartEventMessage", "buildStartupEventInfo", "Lio/embrace/android/embracesdk/internal/StartupEventInfo;", "endEvent", "calculateLateThreshold", "calculateOffset", "isAllowedToStart", "onEventEnded", "originEventDescription", "Lio/embrace/android/embracesdk/internal/EventDescription;", "onEventStarted", "timeoutCallback", "Ljava/lang/Runnable;", "shouldSendMoment", "name", "embrace-android-sdk_release"})
public final class EventHandler {
    private final MetadataService metadataService;
    private final SessionIdTracker sessionIdTracker;
    private final ConfigService configService;
    private final UserService userService;
    private final DeliveryService deliveryService;
    private final EmbLogger logger;
    private final Clock clock;
    private final ScheduledWorker scheduledWorker;

    @NotNull
    public final EventDescription onEventStarted(@NotNull String eventId, @NotNull String eventName, long startTime, @NotNull EmbraceSessionProperties sessionProperties2, @Nullable Map<String, ? extends Object> eventProperties, @NotNull Runnable timeoutCallback) {
        Intrinsics.checkNotNullParameter((Object)eventId, (String)"eventId");
        Intrinsics.checkNotNullParameter((Object)eventName, (String)"eventName");
        Intrinsics.checkNotNullParameter((Object)sessionProperties2, (String)"sessionProperties");
        Intrinsics.checkNotNullParameter((Object)timeoutCallback, (String)"timeoutCallback");
        long threshold = this.calculateLateThreshold(eventId);
        Event event = this.buildStartEvent(eventId, eventName, startTime, threshold, sessionProperties2, eventProperties);
        ScheduledFuture timer = this.scheduledWorker.schedule(timeoutCallback, threshold - this.calculateOffset(startTime, threshold), TimeUnit.MILLISECONDS);
        if (this.shouldSendMoment(eventName)) {
            EventMessage eventMessage = this.buildStartEventMessage(event);
            this.deliveryService.sendMoment(eventMessage);
        } else {
            EmbLogger.DefaultImpls.logDebug$default(this.logger, eventName + " start moment not sent based on gating config.", null, 2, null);
        }
        return new EventDescription(timer, event);
    }

    @NotNull
    public final EventMessage onEventEnded(@NotNull EventDescription originEventDescription, boolean late, @Nullable Map<String, ? extends Object> eventProperties, @NotNull EmbraceSessionProperties sessionProperties2) {
        Intrinsics.checkNotNullParameter((Object)originEventDescription, (String)"originEventDescription");
        Intrinsics.checkNotNullParameter((Object)sessionProperties2, (String)"sessionProperties");
        Event event = originEventDescription.getEvent();
        Long l = event.timestamp;
        long startTime = l != null ? l : 0L;
        long endTime = this.clock.now();
        long duration = Math.max(0L, endTime - startTime);
        originEventDescription.getLateTimer().cancel(false);
        Event endEvent = this.buildEndEvent(event, endTime, duration, late, sessionProperties2, eventProperties);
        EventMessage endEventMessage = this.buildEndEventMessage(endEvent);
        if (this.shouldSendMoment(event.name)) {
            this.deliveryService.sendMoment(endEventMessage);
        } else {
            EmbLogger.DefaultImpls.logDebug$default(this.logger, event.name + " end moment not sent based on gating config.", null, 2, null);
        }
        return endEventMessage;
    }

    public final boolean isAllowedToStart(@NotNull String eventName) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)eventName, (String)"eventName");
        CharSequence charSequence = eventName;
        if (charSequence.length() == 0) {
            EmbLogger.DefaultImpls.logWarning$default(this.logger, "Event name is empty. Ignoring this event.", null, 2, null);
            bl = false;
        } else if (!this.configService.getDataCaptureEventBehavior().isEventEnabled(eventName)) {
            EmbLogger.DefaultImpls.logWarning$default(this.logger, "Event disabled. Ignoring event with name " + eventName, null, 2, null);
            bl = false;
        } else {
            bl = true;
        }
        return bl;
    }

    @NotNull
    public final StartupEventInfo buildStartupEventInfo(@NotNull Event originEvent, @NotNull Event endEvent) {
        Intrinsics.checkNotNullParameter((Object)originEvent, (String)"originEvent");
        Intrinsics.checkNotNullParameter((Object)endEvent, (String)"endEvent");
        return new StartupEventInfo(endEvent.duration, originEvent.lateThreshold);
    }

    private final EventMessage buildEndEventMessage(Event event) {
        return new EventMessage(event, null, null, this.userService.getUserInfo(), null, 0, null, 118, null);
    }

    private final boolean shouldSendMoment(String name) {
        return Intrinsics.areEqual((Object)name, (Object)"_startup") ? !this.configService.getSessionBehavior().shouldGateStartupMoment() : !this.configService.getSessionBehavior().shouldGateMoment();
    }

    private final EventMessage buildStartEventMessage(Event event) {
        NativeCrash nativeCrash = null;
        int n = 0;
        Stacktraces stacktraces = null;
        DeviceInfo deviceInfo = this.metadataService.getDeviceInfo();
        AppInfo appInfo = this.metadataService.getAppInfo();
        UserInfo userInfo = this.userService.getUserInfo();
        return new EventMessage(event, deviceInfo, appInfo, userInfo, stacktraces, n, nativeCrash, 112, null);
    }

    private final Event buildStartEvent(String eventId, String eventName, long startTime, long threshold, EmbraceSessionProperties sessionProperties2, Map<String, ? extends Object> eventProperties) {
        Map<String, ? extends Object> map = eventProperties;
        Integer n = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        List list = null;
        Map map2 = map != null ? MapsKt.toMap(map) : null;
        Map map3 = MapsKt.toMap(sessionProperties2.get());
        Long l = startTime;
        Long l2 = null;
        Boolean bl = null;
        Long l3 = threshold;
        String string5 = this.metadataService.getAppState();
        EventType eventType = EventType.START;
        String string6 = eventId;
        String string7 = this.sessionIdTracker.getActiveSessionId();
        return new Event(eventName, null, string6, string7, eventType, l, l3, bl, l2, string5, map2, map3, list, string4, string3, string2, n, 127362, null);
    }

    private final Event buildEndEvent(Event originEvent, long endTime, long duration, boolean late, EmbraceSessionProperties sessionProperties2, Map<String, ? extends Object> eventProperties) {
        Map<String, ? extends Object> map = eventProperties;
        Integer n = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        List list = null;
        Map map2 = MapsKt.toMap(sessionProperties2.get());
        Map map3 = map != null ? MapsKt.toMap(map) : null;
        EventType eventType = late ? EventType.LATE : EventType.END;
        String string5 = this.metadataService.getAppState();
        Boolean bl = null;
        Long l = null;
        Long l2 = duration;
        Long l3 = endTime;
        return new Event(originEvent.name, null, originEvent.eventId, this.sessionIdTracker.getActiveSessionId(), eventType, l3, l, bl, l2, string5, map3, map2, list, string4, string3, string2, n, 127170, null);
    }

    private final long calculateOffset(long startTime, long threshold) {
        return Math.min(threshold, Math.max(0L, this.clock.now() - startTime));
    }

    private final long calculateLateThreshold(String eventId) {
        Map<String, Long> limits = this.configService.getDataCaptureEventBehavior().getEventLimits();
        Long value = limits.get(eventId);
        return value == null || !limits.containsKey(eventId) ? 5000L : value;
    }

    public EventHandler(@NotNull MetadataService metadataService2, @NotNull SessionIdTracker sessionIdTracker2, @NotNull ConfigService configService2, @NotNull UserService userService2, @NotNull DeliveryService deliveryService2, @NotNull EmbLogger logger2, @NotNull Clock clock, @NotNull ScheduledWorker scheduledWorker) {
        Intrinsics.checkNotNullParameter((Object)metadataService2, (String)"metadataService");
        Intrinsics.checkNotNullParameter((Object)sessionIdTracker2, (String)"sessionIdTracker");
        Intrinsics.checkNotNullParameter((Object)configService2, (String)"configService");
        Intrinsics.checkNotNullParameter((Object)userService2, (String)"userService");
        Intrinsics.checkNotNullParameter((Object)deliveryService2, (String)"deliveryService");
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)scheduledWorker, (String)"scheduledWorker");
        this.metadataService = metadataService2;
        this.sessionIdTracker = sessionIdTracker2;
        this.configService = configService2;
        this.userService = userService2;
        this.deliveryService = deliveryService2;
        this.logger = logger2;
        this.clock = clock;
        this.scheduledWorker = scheduledWorker;
    }
}

