/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk.gating;

import io.embrace.android.embracesdk.config.ConfigService;
import io.embrace.android.embracesdk.gating.EventSanitizerFacade;
import io.embrace.android.embracesdk.gating.GatingService;
import io.embrace.android.embracesdk.gating.v2.EnvelopeSanitizerFacade;
import io.embrace.android.embracesdk.internal.logs.LogService;
import io.embrace.android.embracesdk.internal.payload.Envelope;
import io.embrace.android.embracesdk.internal.payload.SessionPayload;
import io.embrace.android.embracesdk.logging.EmbLogger;
import io.embrace.android.embracesdk.payload.EventMessage;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016J$\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016J\b\u0010\u0012\u001a\u00020\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lio/embrace/android/embracesdk/gating/EmbraceGatingService;", "Lio/embrace/android/embracesdk/gating/GatingService;", "configService", "Lio/embrace/android/embracesdk/config/ConfigService;", "logService", "Lio/embrace/android/embracesdk/internal/logs/LogService;", "logger", "Lio/embrace/android/embracesdk/logging/EmbLogger;", "(Lio/embrace/android/embracesdk/config/ConfigService;Lio/embrace/android/embracesdk/internal/logs/LogService;Lio/embrace/android/embracesdk/logging/EmbLogger;)V", "gateEventMessage", "Lio/embrace/android/embracesdk/payload/EventMessage;", "eventMessage", "gateSessionEnvelope", "Lio/embrace/android/embracesdk/internal/payload/Envelope;", "Lio/embrace/android/embracesdk/internal/payload/SessionPayload;", "hasCrash", "", "envelope", "hasErrorLogs", "embrace-android-sdk_release"})
public final class EmbraceGatingService
implements GatingService {
    private final ConfigService configService;
    private final LogService logService;
    private final EmbLogger logger;

    @Override
    @NotNull
    public Envelope<SessionPayload> gateSessionEnvelope(boolean hasCrash, @NotNull Envelope<SessionPayload> envelope) {
        Intrinsics.checkNotNullParameter(envelope, (String)"envelope");
        Set<String> components = this.configService.getSessionBehavior().getSessionComponents();
        if (components != null && this.configService.getSessionBehavior().isGatingFeatureEnabled()) {
            if (this.hasErrorLogs()) {
                return envelope;
            }
            if (hasCrash) {
                return envelope;
            }
            return new EnvelopeSanitizerFacade(envelope, components).sanitize();
        }
        return envelope;
    }

    private final boolean hasErrorLogs() {
        Collection collection = this.logService.findErrorLogIds();
        return !collection.isEmpty() && this.configService.getSessionBehavior().shouldSendFullForErrorLog();
    }

    @Override
    @NotNull
    public EventMessage gateEventMessage(@NotNull EventMessage eventMessage) {
        Intrinsics.checkNotNullParameter((Object)eventMessage, (String)"eventMessage");
        Set<String> components = this.configService.getSessionBehavior().getSessionComponents();
        if (components != null && this.configService.getSessionBehavior().isGatingFeatureEnabled()) {
            EmbLogger.DefaultImpls.logDebug$default(this.logger, "Session gating feature enabled. Attempting to sanitize the event message", null, 2, null);
            if (this.configService.getSessionBehavior().shouldSendFullMessage(eventMessage)) {
                return eventMessage;
            }
            return new EventSanitizerFacade(eventMessage, components).getSanitizedMessage();
        }
        return eventMessage;
    }

    public EmbraceGatingService(@NotNull ConfigService configService2, @NotNull LogService logService2, @NotNull EmbLogger logger2) {
        Intrinsics.checkNotNullParameter((Object)configService2, (String)"configService");
        Intrinsics.checkNotNullParameter((Object)logService2, (String)"logService");
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        this.configService = configService2;
        this.logService = logService2;
        this.logger = logger2;
    }
}

