/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk.internal.compression;

import java.io.BufferedOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u000bH\u0002J\b\u0010\r\u001a\u00020\u000bH\u0016J\b\u0010\u000e\u001a\u00020\u0001H\u0002J\u0016\u0010\u000f\u001a\u00020\u00052\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0001X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lio/embrace/android/embracesdk/internal/compression/ConditionalGzipOutputStream;", "Ljava/io/OutputStream;", "outputStream", "(Ljava/io/OutputStream;)V", "drainedBuffer", "", "impl", "magicNumberBuffer", "", "", "close", "", "drainBufferIfNeeded", "flush", "generateOutputStream", "isCompressed", "buffer", "", "write", "b", "", "embrace-android-sdk_release"})
public final class ConditionalGzipOutputStream
extends OutputStream {
    private final List<Byte> magicNumberBuffer;
    private boolean drainedBuffer;
    private OutputStream impl;
    private final OutputStream outputStream;

    @Override
    public void write(int b) {
        if (this.magicNumberBuffer.size() < 2) {
            this.magicNumberBuffer.add((byte)b);
        } else {
            this.drainBufferIfNeeded();
            OutputStream outputStream = this.impl;
            if (outputStream == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"impl");
            }
            outputStream.write(b);
        }
    }

    @Override
    public void close() {
        this.drainBufferIfNeeded();
        OutputStream outputStream = this.impl;
        if (outputStream == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"impl");
        }
        outputStream.close();
    }

    @Override
    public void flush() {
        this.drainBufferIfNeeded();
        OutputStream outputStream = this.impl;
        if (outputStream == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"impl");
        }
        outputStream.flush();
    }

    private final void drainBufferIfNeeded() {
        if (!this.drainedBuffer) {
            this.impl = this.generateOutputStream();
            Iterable $this$forEach$iv = this.magicNumberBuffer;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                byte it = ((Number)element$iv).byteValue();
                boolean bl = false;
                OutputStream outputStream = this.impl;
                if (outputStream == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"impl");
                }
                outputStream.write(it);
            }
            this.drainedBuffer = true;
        }
    }

    private final OutputStream generateOutputStream() {
        OutputStream outputStream;
        if (this.magicNumberBuffer.isEmpty() || this.isCompressed(this.magicNumberBuffer)) {
            OutputStream outputStream2 = this.outputStream;
            int n = 8192;
            outputStream = outputStream2 instanceof BufferedOutputStream ? (BufferedOutputStream)outputStream2 : new BufferedOutputStream(outputStream2, n);
        } else {
            OutputStream outputStream3 = this.outputStream;
            int n = 8192;
            outputStream = new GZIPOutputStream(outputStream3 instanceof BufferedOutputStream ? (BufferedOutputStream)outputStream3 : new BufferedOutputStream(outputStream3, n));
        }
        return outputStream;
    }

    private final boolean isCompressed(List<Byte> buffer) {
        if (buffer.size() < 2) {
            return false;
        }
        return ((Number)buffer.get(0)).byteValue() == (byte)31 && ((Number)buffer.get(1)).byteValue() == (byte)139;
    }

    public ConditionalGzipOutputStream(@NotNull OutputStream outputStream) {
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
        this.outputStream = outputStream;
        this.magicNumberBuffer = new ArrayList();
    }
}

