/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk.internal.logs;

import io.embrace.android.embracesdk.Embrace;
import io.embrace.android.embracesdk.EventType;
import io.embrace.android.embracesdk.LogExceptionType;
import io.embrace.android.embracesdk.Severity;
import io.embrace.android.embracesdk.arch.destination.LogWriter;
import io.embrace.android.embracesdk.arch.schema.EmbType;
import io.embrace.android.embracesdk.arch.schema.SchemaType;
import io.embrace.android.embracesdk.arch.schema.TelemetryAttributes;
import io.embrace.android.embracesdk.config.ConfigService;
import io.embrace.android.embracesdk.config.behavior.LogMessageBehavior;
import io.embrace.android.embracesdk.internal.clock.Clock;
import io.embrace.android.embracesdk.internal.logs.EmbraceLogService;
import io.embrace.android.embracesdk.internal.logs.EmbraceLogService$WhenMappings;
import io.embrace.android.embracesdk.internal.logs.LogCounter;
import io.embrace.android.embracesdk.internal.logs.LogService;
import io.embrace.android.embracesdk.internal.serialization.EmbraceSerializer;
import io.embrace.android.embracesdk.internal.serialization.PlatformSerializerKt;
import io.embrace.android.embracesdk.internal.utils.Uuid;
import io.embrace.android.embracesdk.logging.EmbLogger;
import io.embrace.android.embracesdk.opentelemetry.EmbraceAttributeKeysKt;
import io.embrace.android.embracesdk.session.properties.EmbraceSessionProperties;
import io.embrace.android.embracesdk.worker.BackgroundWorker;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.semconv.incubating.ExceptionIncubatingAttributes;
import io.opentelemetry.semconv.incubating.LogIncubatingAttributes;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u0000 ?2\u00020\u0001:\u0001?BE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J4\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u001f2\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\"0!H\u0002J\b\u0010#\u001a\u00020\u001aH\u0016J\u001e\u0010$\u001a\u00020\u001f2\u0014\u0010%\u001a\u0010\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020&\u0018\u00010\u0014H\u0002J\u000e\u0010'\u001a\b\u0012\u0004\u0012\u00020\u001c0(H\u0016J}\u0010)\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0014\u0010.\u001a\u0010\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020&\u0018\u00010\u00142\u000e\u0010/\u001a\n\u0012\u0004\u0012\u000201\u0018\u0001002\b\u00102\u001a\u0004\u0018\u00010\u001c2\b\u00103\u001a\u0004\u0018\u00010\u001c2\b\u00104\u001a\u0004\u0018\u00010\u001c2\b\u00105\u001a\u0004\u0018\u00010\u001c2\b\u00106\u001a\u0004\u0018\u00010\u001cH\u0016\u00a2\u0006\u0002\u00107J.\u0010)\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00152\u0014\u0010.\u001a\u0010\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020&\u0018\u00010\u0014H\u0002JT\u00108\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00152\u0006\u0010,\u001a\u00020-2\u0014\u0010.\u001a\u0010\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020&\u0018\u00010\u00142\b\u00109\u001a\u0004\u0018\u00010\u001c2\b\u00105\u001a\u0004\u0018\u00010\u001c2\b\u00106\u001a\u0004\u0018\u00010\u001cH\u0002Jh\u0010:\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00152\u0006\u0010,\u001a\u00020-2\u0014\u0010.\u001a\u0010\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020&\u0018\u00010\u00142\b\u00109\u001a\u0004\u0018\u00010\u001c2\b\u00105\u001a\u0004\u0018\u00010\u001c2\b\u00106\u001a\u0004\u0018\u00010\u001c2\b\u00103\u001a\u0004\u0018\u00010\u001c2\b\u00104\u001a\u0004\u0018\u00010\u001cH\u0002J6\u0010;\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010,\u001a\u00020-2\b\u00109\u001a\u0004\u0018\u00010\u001c2\b\u0010*\u001a\u0004\u0018\u00010\u001c2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0002J\u0010\u0010<\u001a\u00020=2\u0006\u0010\u001d\u001a\u00020\u0015H\u0002J\u0010\u0010>\u001a\u00020\u001c2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lio/embrace/android/embracesdk/internal/logs/EmbraceLogService;", "Lio/embrace/android/embracesdk/internal/logs/LogService;", "logWriter", "Lio/embrace/android/embracesdk/arch/destination/LogWriter;", "configService", "Lio/embrace/android/embracesdk/config/ConfigService;", "appFramework", "Lio/embrace/android/embracesdk/Embrace$AppFramework;", "sessionProperties", "Lio/embrace/android/embracesdk/session/properties/EmbraceSessionProperties;", "backgroundWorker", "Lio/embrace/android/embracesdk/worker/BackgroundWorker;", "logger", "Lio/embrace/android/embracesdk/logging/EmbLogger;", "clock", "Lio/embrace/android/embracesdk/internal/clock/Clock;", "serializer", "Lio/embrace/android/embracesdk/internal/serialization/EmbraceSerializer;", "(Lio/embrace/android/embracesdk/arch/destination/LogWriter;Lio/embrace/android/embracesdk/config/ConfigService;Lio/embrace/android/embracesdk/Embrace$AppFramework;Lio/embrace/android/embracesdk/session/properties/EmbraceSessionProperties;Lio/embrace/android/embracesdk/worker/BackgroundWorker;Lio/embrace/android/embracesdk/logging/EmbLogger;Lio/embrace/android/embracesdk/internal/clock/Clock;Lio/embrace/android/embracesdk/internal/serialization/EmbraceSerializer;)V", "logCounters", "", "Lio/embrace/android/embracesdk/Severity;", "Lio/embrace/android/embracesdk/internal/logs/LogCounter;", "unhandledExceptionsCount", "", "addLogEventData", "", "message", "", "severity", "attributes", "Lio/embrace/android/embracesdk/arch/schema/TelemetryAttributes;", "schemaProvider", "Lkotlin/Function1;", "Lio/embrace/android/embracesdk/arch/schema/SchemaType;", "cleanCollections", "createTelemetryAttributes", "customProperties", "", "findErrorLogIds", "", "log", "type", "Lio/embrace/android/embracesdk/EventType;", "logExceptionType", "Lio/embrace/android/embracesdk/LogExceptionType;", "properties", "stackTraceElements", "", "Ljava/lang/StackTraceElement;", "customStackTrace", "context", "library", "exceptionName", "exceptionMessage", "(Ljava/lang/String;Lio/embrace/android/embracesdk/EventType;Lio/embrace/android/embracesdk/LogExceptionType;Ljava/util/Map;[Ljava/lang/StackTraceElement;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "logException", "stackTrace", "logFlutterException", "populateLogExceptionAttributes", "shouldLogBeGated", "", "trimToMaxLength", "Companion", "embrace-android-sdk_release"})
public final class EmbraceLogService
implements LogService {
    private final Map<Severity, LogCounter> logCounters;
    private int unhandledExceptionsCount;
    private final LogWriter logWriter;
    private final ConfigService configService;
    private final Embrace.AppFramework appFramework;
    private final EmbraceSessionProperties sessionProperties;
    private final BackgroundWorker backgroundWorker;
    private final EmbLogger logger;
    private final EmbraceSerializer serializer;
    private static final int LOG_MESSAGE_UNITY_MAXIMUM_ALLOWED_LENGTH = 16384;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    public void log(@NotNull String message, @NotNull EventType type, @NotNull LogExceptionType logExceptionType, @Nullable Map<String, ? extends Object> properties, @Nullable StackTraceElement[] stackTraceElements, @Nullable String customStackTrace, @Nullable String context2, @Nullable String library, @Nullable String exceptionName, @Nullable String exceptionMessage) {
        Severity severity;
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)((Object)logExceptionType), (String)"logExceptionType");
        if (type.getSeverity() == null) {
            EmbLogger.DefaultImpls.logError$default(this.logger, "Invalid event type for log: " + (Object)((Object)type), null, 2, null);
            return;
        }
        Severity severity2 = type.getSeverity();
        if (severity2 == null) {
            severity2 = severity = Severity.INFO;
        }
        if (logExceptionType == LogExceptionType.NONE) {
            this.log(message, severity, properties);
        } else {
            String stacktrace;
            String string2 = stacktrace = stackTraceElements != null ? PlatformSerializerKt.truncatedStacktrace(this.serializer, stackTraceElements) : customStackTrace;
            if (this.appFramework == Embrace.AppFramework.FLUTTER) {
                this.logFlutterException(message, severity, logExceptionType, properties, stacktrace, exceptionName, exceptionMessage, context2, library);
            } else {
                this.logException(message, severity, logExceptionType, properties, stacktrace, exceptionName, exceptionMessage);
            }
        }
    }

    private final void log(String message, Severity severity, Map<String, ? extends Object> properties) {
        BackgroundWorker.submit$default(this.backgroundWorker, null, new Runnable(this, message, severity, properties){
            final /* synthetic */ EmbraceLogService this$0;
            final /* synthetic */ String $message;
            final /* synthetic */ Severity $severity;
            final /* synthetic */ Map $properties;

            public final void run() {
                EmbraceLogService.access$addLogEventData(this.this$0, this.$message, this.$severity, EmbraceLogService.access$createTelemetryAttributes(this.this$0, this.$properties), log.1.INSTANCE);
            }
            {
                this.this$0 = embraceLogService;
                this.$message = string2;
                this.$severity = severity;
                this.$properties = map;
            }
        }, 1, null);
    }

    private final void logException(String message, Severity severity, LogExceptionType logExceptionType, Map<String, ? extends Object> properties, String stackTrace, String exceptionName, String exceptionMessage) {
        BackgroundWorker.submit$default(this.backgroundWorker, null, new Runnable(this, logExceptionType, properties, stackTrace, exceptionName, exceptionMessage, message, severity){
            final /* synthetic */ EmbraceLogService this$0;
            final /* synthetic */ LogExceptionType $logExceptionType;
            final /* synthetic */ Map $properties;
            final /* synthetic */ String $stackTrace;
            final /* synthetic */ String $exceptionName;
            final /* synthetic */ String $exceptionMessage;
            final /* synthetic */ String $message;
            final /* synthetic */ Severity $severity;

            public final void run() {
                if (this.$logExceptionType == LogExceptionType.UNHANDLED) {
                    EmbraceLogService embraceLogService = this.this$0;
                    int n = EmbraceLogService.access$getUnhandledExceptionsCount$p(embraceLogService);
                    EmbraceLogService.access$setUnhandledExceptionsCount$p(embraceLogService, n + 1);
                }
                TelemetryAttributes attributes = EmbraceLogService.access$createTelemetryAttributes(this.this$0, this.$properties);
                EmbraceLogService.access$populateLogExceptionAttributes(this.this$0, attributes, this.$logExceptionType, this.$stackTrace, this.$exceptionName, this.$exceptionMessage);
                EmbraceLogService.access$addLogEventData(this.this$0, this.$message, this.$severity, attributes, logException.1.INSTANCE);
            }
            {
                this.this$0 = embraceLogService;
                this.$logExceptionType = logExceptionType;
                this.$properties = map;
                this.$stackTrace = string2;
                this.$exceptionName = string3;
                this.$exceptionMessage = string4;
                this.$message = string5;
                this.$severity = severity;
            }
        }, 1, null);
    }

    private final void logFlutterException(String message, Severity severity, LogExceptionType logExceptionType, Map<String, ? extends Object> properties, String stackTrace, String exceptionName, String exceptionMessage, String context2, String library) {
        BackgroundWorker.submit$default(this.backgroundWorker, null, new Runnable(this, logExceptionType, properties, stackTrace, exceptionName, exceptionMessage, context2, library, message, severity){
            final /* synthetic */ EmbraceLogService this$0;
            final /* synthetic */ LogExceptionType $logExceptionType;
            final /* synthetic */ Map $properties;
            final /* synthetic */ String $stackTrace;
            final /* synthetic */ String $exceptionName;
            final /* synthetic */ String $exceptionMessage;
            final /* synthetic */ String $context;
            final /* synthetic */ String $library;
            final /* synthetic */ String $message;
            final /* synthetic */ Severity $severity;

            public final void run() {
                String it;
                String string2;
                if (this.$logExceptionType == LogExceptionType.UNHANDLED) {
                    EmbraceLogService embraceLogService = this.this$0;
                    int n = EmbraceLogService.access$getUnhandledExceptionsCount$p(embraceLogService);
                    EmbraceLogService.access$setUnhandledExceptionsCount$p(embraceLogService, n + 1);
                }
                TelemetryAttributes attributes = EmbraceLogService.access$createTelemetryAttributes(this.this$0, this.$properties);
                EmbraceLogService.access$populateLogExceptionAttributes(this.this$0, attributes, this.$logExceptionType, this.$stackTrace, this.$exceptionName, this.$exceptionMessage);
                String string3 = this.$context;
                if (string3 != null) {
                    it = string2 = string3;
                    boolean bl = false;
                    attributes.setAttribute(EmbType.System.FlutterException.INSTANCE.getEmbFlutterExceptionContext(), it);
                }
                String string4 = this.$library;
                if (string4 != null) {
                    it = string2 = string4;
                    boolean bl = false;
                    attributes.setAttribute(EmbType.System.FlutterException.INSTANCE.getEmbFlutterExceptionLibrary(), it);
                }
                EmbraceLogService.access$addLogEventData(this.this$0, this.$message, this.$severity, attributes, logFlutterException.3.INSTANCE);
            }
            {
                this.this$0 = embraceLogService;
                this.$logExceptionType = logExceptionType;
                this.$properties = map;
                this.$stackTrace = string2;
                this.$exceptionName = string3;
                this.$exceptionMessage = string4;
                this.$context = string5;
                this.$library = string6;
                this.$message = string7;
                this.$severity = severity;
            }
        }, 1, null);
    }

    @Override
    @NotNull
    public List<String> findErrorLogIds() {
        return ((LogCounter)MapsKt.getValue(this.logCounters, (Object)((Object)Severity.ERROR))).findLogIds();
    }

    @Override
    public void cleanCollections() {
        Map<Severity, LogCounter> $this$forEach$iv = this.logCounters;
        boolean $i$f$forEach = false;
        Map<Severity, LogCounter> map = $this$forEach$iv;
        boolean bl = false;
        Iterator<Map.Entry<Severity, LogCounter>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Severity, LogCounter> element$iv;
            Map.Entry<Severity, LogCounter> it = element$iv = iterator.next();
            boolean bl2 = false;
            it.getValue().clear();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final TelemetryAttributes createTelemetryAttributes(Map<String, ? extends Object> customProperties) {
        Map map;
        ConfigService configService2 = this.configService;
        EmbraceSessionProperties embraceSessionProperties = this.sessionProperties;
        Map<String, ? extends Object> map2 = customProperties;
        if (map2 != null) {
            Map map3;
            void $this$mapValuesTo$iv$iv;
            void $this$mapValues$iv;
            Map<String, ? extends Object> map4 = map2;
            EmbraceSessionProperties embraceSessionProperties2 = embraceSessionProperties;
            ConfigService configService3 = configService2;
            boolean $i$f$mapValues = false;
            void var5_6 = $this$mapValues$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it;
                void it$iv$iv;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Map map5 = destination$iv$iv;
                boolean bl = false;
                Object k = it$iv$iv.getKey();
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                Object k2 = k;
                map3 = map5;
                boolean bl2 = false;
                String string2 = it.getValue().toString();
                map3.put(k2, string2);
            }
            map3 = destination$iv$iv;
            configService2 = configService3;
            embraceSessionProperties = embraceSessionProperties2;
            map = map3;
        } else {
            map = MapsKt.emptyMap();
        }
        Map map6 = map;
        EmbraceSessionProperties embraceSessionProperties3 = embraceSessionProperties;
        ConfigService configService4 = configService2;
        TelemetryAttributes attributes = new TelemetryAttributes(configService4, embraceSessionProperties3, map6);
        AttributeKey attributeKey = LogIncubatingAttributes.LOG_RECORD_UID;
        Intrinsics.checkNotNullExpressionValue((Object)attributeKey, (String)"LogIncubatingAttributes.LOG_RECORD_UID");
        attributes.setAttribute((AttributeKey<String>)attributeKey, Uuid.getEmbUuid$default(null, 1, null));
        return attributes;
    }

    private final void populateLogExceptionAttributes(TelemetryAttributes attributes, LogExceptionType logExceptionType, String stackTrace, String type, String message) {
        block2: {
            String it;
            String string2;
            attributes.setAttribute(EmbraceAttributeKeysKt.getEmbExceptionHandling(), logExceptionType.getValue$embrace_android_sdk_release());
            String string3 = type;
            if (string3 != null) {
                it = string2 = string3;
                boolean bl = false;
                AttributeKey attributeKey = ExceptionIncubatingAttributes.EXCEPTION_TYPE;
                Intrinsics.checkNotNullExpressionValue((Object)attributeKey, (String)"ExceptionIncubatingAttributes.EXCEPTION_TYPE");
                attributes.setAttribute((AttributeKey<String>)attributeKey, it);
            }
            String string4 = message;
            if (string4 != null) {
                it = string2 = string4;
                boolean bl = false;
                AttributeKey attributeKey = ExceptionIncubatingAttributes.EXCEPTION_MESSAGE;
                Intrinsics.checkNotNullExpressionValue((Object)attributeKey, (String)"ExceptionIncubatingAttributes.EXCEPTION_MESSAGE");
                attributes.setAttribute((AttributeKey<String>)attributeKey, it);
            }
            String string5 = stackTrace;
            if (string5 == null) break block2;
            it = string2 = string5;
            boolean bl = false;
            AttributeKey attributeKey = ExceptionIncubatingAttributes.EXCEPTION_STACKTRACE;
            Intrinsics.checkNotNullExpressionValue((Object)attributeKey, (String)"ExceptionIncubatingAttributes.EXCEPTION_STACKTRACE");
            attributes.setAttribute((AttributeKey<String>)attributeKey, it);
        }
    }

    private final void addLogEventData(String message, Severity severity, TelemetryAttributes attributes, Function1<? super TelemetryAttributes, ? extends SchemaType> schemaProvider) {
        if (this.shouldLogBeGated(severity)) {
            return;
        }
        AttributeKey attributeKey = LogIncubatingAttributes.LOG_RECORD_UID;
        Intrinsics.checkNotNullExpressionValue((Object)attributeKey, (String)"LogIncubatingAttributes.LOG_RECORD_UID");
        String logId = attributes.getAttribute((AttributeKey<String>)attributeKey);
        if (logId == null || !((LogCounter)MapsKt.getValue(this.logCounters, (Object)((Object)severity))).addIfAllowed(logId)) {
            return;
        }
        LogWriter.DefaultImpls.addLog$default(this.logWriter, (SchemaType)schemaProvider.invoke((Object)attributes), severity, this.trimToMaxLength(message), false, 8, null);
    }

    private final boolean shouldLogBeGated(Severity severity) {
        boolean bl;
        switch (EmbraceLogService$WhenMappings.$EnumSwitchMapping$0[severity.ordinal()]) {
            case 1: {
                bl = this.configService.getSessionBehavior().shouldGateInfoLog();
                break;
            }
            case 2: {
                bl = this.configService.getSessionBehavior().shouldGateWarnLog();
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    private final String trimToMaxLength(String message) {
        String string2;
        int maxLength;
        int n = maxLength = this.appFramework == Embrace.AppFramework.UNITY ? 16384 : this.configService.getLogMessageBehavior().getLogMessageMaximumAllowedLength();
        if (message.length() > maxLength) {
            String endChars = "...";
            int allowedLength = maxLength >= endChars.length() ? maxLength - endChars.length() : 128 - endChars.length();
            EmbLogger.DefaultImpls.logWarning$default(this.logger, "Truncating message to " + message.length() + " characters", null, 2, null);
            StringBuilder stringBuilder = new StringBuilder();
            String string3 = message;
            int n2 = 0;
            String string4 = string3;
            if (string4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.substring(n2, allowedLength);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            string2 = stringBuilder.append(string5).append(endChars).toString();
        } else {
            string2 = message;
        }
        return string2;
    }

    public EmbraceLogService(@NotNull LogWriter logWriter2, @NotNull ConfigService configService2, @NotNull Embrace.AppFramework appFramework2, @NotNull EmbraceSessionProperties sessionProperties2, @NotNull BackgroundWorker backgroundWorker, @NotNull EmbLogger logger2, @NotNull Clock clock, @NotNull EmbraceSerializer serializer) {
        Intrinsics.checkNotNullParameter((Object)logWriter2, (String)"logWriter");
        Intrinsics.checkNotNullParameter((Object)configService2, (String)"configService");
        Intrinsics.checkNotNullParameter((Object)((Object)appFramework2), (String)"appFramework");
        Intrinsics.checkNotNullParameter((Object)sessionProperties2, (String)"sessionProperties");
        Intrinsics.checkNotNullParameter((Object)backgroundWorker, (String)"backgroundWorker");
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)serializer, (String)"serializer");
        this.logWriter = logWriter2;
        this.configService = configService2;
        this.appFramework = appFramework2;
        this.sessionProperties = sessionProperties2;
        this.backgroundWorker = backgroundWorker;
        this.logger = logger2;
        this.serializer = serializer;
        this.logCounters = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)((Object)Severity.INFO), (Object)new LogCounter(Severity.INFO.name(), clock, (Function0<Integer>)((Function0)new Function0<Integer>(this.configService.getLogMessageBehavior()){

            public final int invoke() {
                return ((LogMessageBehavior)this.receiver).getInfoLogLimit();
            }
        }), this.logger)), TuplesKt.to((Object)((Object)Severity.WARNING), (Object)new LogCounter(Severity.WARNING.name(), clock, (Function0<Integer>)((Function0)new Function0<Integer>(this.configService.getLogMessageBehavior()){

            public final int invoke() {
                return ((LogMessageBehavior)this.receiver).getWarnLogLimit();
            }
        }), this.logger)), TuplesKt.to((Object)((Object)Severity.ERROR), (Object)new LogCounter(Severity.ERROR.name(), clock, (Function0<Integer>)((Function0)new Function0<Integer>(this.configService.getLogMessageBehavior()){

            public final int invoke() {
                return ((LogMessageBehavior)this.receiver).getErrorLogLimit();
            }
        }), this.logger))});
    }

    public static final /* synthetic */ void access$addLogEventData(EmbraceLogService $this, String message, Severity severity, TelemetryAttributes attributes, Function1 schemaProvider) {
        $this.addLogEventData(message, severity, attributes, (Function1<? super TelemetryAttributes, ? extends SchemaType>)schemaProvider);
    }

    public static final /* synthetic */ TelemetryAttributes access$createTelemetryAttributes(EmbraceLogService $this, Map customProperties) {
        return $this.createTelemetryAttributes(customProperties);
    }

    public static final /* synthetic */ int access$getUnhandledExceptionsCount$p(EmbraceLogService $this) {
        return $this.unhandledExceptionsCount;
    }

    public static final /* synthetic */ void access$setUnhandledExceptionsCount$p(EmbraceLogService $this, int n) {
        $this.unhandledExceptionsCount = n;
    }

    public static final /* synthetic */ void access$populateLogExceptionAttributes(EmbraceLogService $this, TelemetryAttributes attributes, LogExceptionType logExceptionType, String stackTrace, String type, String message) {
        $this.populateLogExceptionAttributes(attributes, logExceptionType, stackTrace, type, message);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/embrace/android/embracesdk/internal/logs/EmbraceLogService$Companion;", "", "()V", "LOG_MESSAGE_UNITY_MAXIMUM_ALLOWED_LENGTH", "", "embrace-android-sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

