/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk.internal.logs;

import io.embrace.android.embracesdk.capture.envelope.log.LogEnvelopeSource;
import io.embrace.android.embracesdk.comms.delivery.DeliveryService;
import io.embrace.android.embracesdk.internal.clock.Clock;
import io.embrace.android.embracesdk.internal.logs.LogOrchestrator;
import io.embrace.android.embracesdk.internal.logs.LogSink;
import io.embrace.android.embracesdk.internal.payload.Envelope;
import io.embrace.android.embracesdk.internal.payload.LogPayload;
import io.embrace.android.embracesdk.worker.ScheduledWorker;
import java.util.Collection;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0007\b\u0000\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\b\u0010\u001a\u001a\u00020\u0015H\u0002J\b\u0010\u001b\u001a\u00020\u0013H\u0002J\b\u0010\u001c\u001a\u00020\u0013H\u0002J\b\u0010\u001d\u001a\u00020\u0015H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lio/embrace/android/embracesdk/internal/logs/LogOrchestratorImpl;", "Lio/embrace/android/embracesdk/internal/logs/LogOrchestrator;", "logOrchestratorScheduledWorker", "Lio/embrace/android/embracesdk/worker/ScheduledWorker;", "clock", "Lio/embrace/android/embracesdk/internal/clock/Clock;", "sink", "Lio/embrace/android/embracesdk/internal/logs/LogSink;", "deliveryService", "Lio/embrace/android/embracesdk/comms/delivery/DeliveryService;", "logEnvelopeSource", "Lio/embrace/android/embracesdk/capture/envelope/log/LogEnvelopeSource;", "(Lio/embrace/android/embracesdk/worker/ScheduledWorker;Lio/embrace/android/embracesdk/internal/clock/Clock;Lio/embrace/android/embracesdk/internal/logs/LogSink;Lio/embrace/android/embracesdk/comms/delivery/DeliveryService;Lio/embrace/android/embracesdk/capture/envelope/log/LogEnvelopeSource;)V", "firstLogInBatchTime", "Ljava/util/concurrent/atomic/AtomicLong;", "lastLogTime", "scheduledCheckFuture", "Ljava/util/concurrent/ScheduledFuture;", "flush", "", "saveOnly", "", "isMaxBatchTimeReached", "now", "", "isMaxInactivityTimeReached", "isMaxLogsPerBatchReached", "onLogsAdded", "scheduleCheck", "sendLogsIfNeeded", "Companion", "embrace-android-sdk_release"})
public final class LogOrchestratorImpl
implements LogOrchestrator {
    private volatile AtomicLong lastLogTime;
    private volatile AtomicLong firstLogInBatchTime;
    private volatile ScheduledFuture<?> scheduledCheckFuture;
    private final ScheduledWorker logOrchestratorScheduledWorker;
    private final Clock clock;
    private final LogSink sink;
    private final DeliveryService deliveryService;
    private final LogEnvelopeSource logEnvelopeSource;
    public static final int MAX_LOGS_PER_BATCH = 50;
    private static final long MAX_BATCH_TIME = 5000L;
    private static final long MAX_INACTIVITY_TIME = 2000L;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    public void flush(boolean saveOnly) {
        ScheduledFuture<?> scheduledFuture = this.scheduledCheckFuture;
        if (scheduledFuture != null) {
            scheduledFuture.cancel(false);
        }
        this.scheduledCheckFuture = null;
        this.firstLogInBatchTime.set(0L);
        Envelope<LogPayload> envelope = this.logEnvelopeSource.getBatchedLogEnvelope();
        Collection collection = envelope.getData().getLogs();
        if (!(collection == null || collection.isEmpty())) {
            if (saveOnly) {
                this.deliveryService.saveLogs(envelope);
            } else {
                this.deliveryService.sendLogs(envelope);
            }
        }
    }

    private final void onLogsAdded() {
        Iterable $this$forEach$iv = this.logEnvelopeSource.getNonbatchedEnvelope();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Envelope logEnvelope = (Envelope)element$iv;
            boolean bl = false;
            this.deliveryService.sendLogs(logEnvelope);
        }
        this.lastLogTime.set(this.clock.now());
        this.firstLogInBatchTime.compareAndSet(0L, this.lastLogTime.get());
        if (!this.sendLogsIfNeeded()) {
            this.firstLogInBatchTime.compareAndSet(0L, this.lastLogTime.get());
            this.scheduleCheck();
        }
    }

    private final synchronized boolean sendLogsIfNeeded() {
        boolean shouldSendLogs;
        long now = this.clock.now();
        boolean bl = shouldSendLogs = this.isMaxLogsPerBatchReached() || this.isMaxInactivityTimeReached(now) || this.isMaxBatchTimeReached(now);
        if (!shouldSendLogs) {
            return false;
        }
        this.flush(false);
        return true;
    }

    private final void scheduleCheck() {
        long now = this.clock.now();
        long nextBatchCheck = 5000L - (now - this.firstLogInBatchTime.get());
        long nextInactivityCheck = 2000L - (now - this.lastLogTime.get());
        ScheduledFuture<?> scheduledFuture = this.scheduledCheckFuture;
        if (scheduledFuture != null) {
            scheduledFuture.cancel(false);
        }
        Function0 function0 = (Function0)new Function0<Unit>(this){

            public final void invoke() {
                LogOrchestratorImpl.access$sendLogsIfNeeded((LogOrchestratorImpl)this.receiver);
            }
        };
        this.scheduledCheckFuture = this.logOrchestratorScheduledWorker.schedule(new Runnable(function0){
            private final /* synthetic */ Function0 function;
            {
                this.function = function0;
            }

            public final /* synthetic */ void run() {
                Intrinsics.checkNotNullExpressionValue((Object)this.function.invoke(), (String)"invoke(...)");
            }
        }, Long.min(nextBatchCheck, nextInactivityCheck), TimeUnit.MILLISECONDS);
    }

    private final boolean isMaxLogsPerBatchReached() {
        return this.sink.completedLogs().size() >= 50;
    }

    private final boolean isMaxInactivityTimeReached(long now) {
        return now - this.lastLogTime.get() >= 2000L;
    }

    private final boolean isMaxBatchTimeReached(long now) {
        long firstLogInBatchTime = this.firstLogInBatchTime.get();
        return firstLogInBatchTime != 0L && now - firstLogInBatchTime >= 5000L;
    }

    public LogOrchestratorImpl(@NotNull ScheduledWorker logOrchestratorScheduledWorker, @NotNull Clock clock, @NotNull LogSink sink, @NotNull DeliveryService deliveryService2, @NotNull LogEnvelopeSource logEnvelopeSource2) {
        Intrinsics.checkNotNullParameter((Object)logOrchestratorScheduledWorker, (String)"logOrchestratorScheduledWorker");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        Intrinsics.checkNotNullParameter((Object)deliveryService2, (String)"deliveryService");
        Intrinsics.checkNotNullParameter((Object)logEnvelopeSource2, (String)"logEnvelopeSource");
        this.logOrchestratorScheduledWorker = logOrchestratorScheduledWorker;
        this.clock = clock;
        this.sink = sink;
        this.deliveryService = deliveryService2;
        this.logEnvelopeSource = logEnvelopeSource2;
        this.lastLogTime = new AtomicLong(0L);
        this.firstLogInBatchTime = new AtomicLong(0L);
        this.sink.registerLogStoredCallback((Function0<Unit>)((Function0)new Function0<Unit>(this){

            public final void invoke() {
                ((LogOrchestratorImpl)this.receiver).onLogsAdded();
            }
        }));
    }

    public static final /* synthetic */ boolean access$sendLogsIfNeeded(LogOrchestratorImpl $this) {
        return $this.sendLogsIfNeeded();
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lio/embrace/android/embracesdk/internal/logs/LogOrchestratorImpl$Companion;", "", "()V", "MAX_BATCH_TIME", "", "MAX_INACTIVITY_TIME", "MAX_LOGS_PER_BATCH", "", "embrace-android-sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

