/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk.internal.logs;

import io.embrace.android.embracesdk.arch.schema.FixedAttribute;
import io.embrace.android.embracesdk.arch.schema.SendImmediately;
import io.embrace.android.embracesdk.internal.logs.LogSink;
import io.embrace.android.embracesdk.internal.payload.Log;
import io.embrace.android.embracesdk.internal.payload.LogMapperKt;
import io.embrace.android.embracesdk.internal.spans.EmbraceExtensionsKt;
import io.embrace.android.embracesdk.utils.CollectionExtensionsKt;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.logs.data.LogRecordData;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\rH\u0016J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\rH\u0016J\n\u0010\u000f\u001a\u0004\u0018\u00010\u0007H\u0016J\u0016\u0010\u0010\u001a\u00020\n2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016J\u0016\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\rH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lio/embrace/android/embracesdk/internal/logs/LogSinkImpl;", "Lio/embrace/android/embracesdk/internal/logs/LogSink;", "()V", "flushLock", "", "nonbatchedLogs", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "Lio/embrace/android/embracesdk/internal/payload/Log;", "onLogsStored", "Lkotlin/Function0;", "", "storedLogs", "completedLogs", "", "flushLogs", "pollNonbatchedLog", "registerLogStoredCallback", "storeLogs", "Lio/opentelemetry/sdk/common/CompletableResultCode;", "logs", "Lio/opentelemetry/sdk/logs/data/LogRecordData;", "embrace-android-sdk_release"})
public final class LogSinkImpl
implements LogSink {
    private final ConcurrentLinkedQueue<Log> storedLogs = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<Log> nonbatchedLogs = new ConcurrentLinkedQueue();
    private Function0<Unit> onLogsStored;
    private final Object flushLock = new Object();

    @Override
    @NotNull
    public CompletableResultCode storeLogs(@NotNull List<? extends LogRecordData> logs) {
        Intrinsics.checkNotNullParameter(logs, (String)"logs");
        try {
            Iterable $this$forEach$iv = logs;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                LogRecordData log2 = (LogRecordData)element$iv;
                boolean bl = false;
                if (EmbraceExtensionsKt.hasFixedAttribute(log2, (FixedAttribute)SendImmediately.INSTANCE)) {
                    this.nonbatchedLogs.add(LogMapperKt.toNewPayload(log2));
                    continue;
                }
                this.storedLogs.add(LogMapperKt.toNewPayload(log2));
            }
            Function0<Unit> function0 = this.onLogsStored;
            if (function0 != null) {
                Unit cfr_ignored_0 = (Unit)function0.invoke();
            }
        }
        catch (Throwable t) {
            CompletableResultCode completableResultCode = CompletableResultCode.ofFailure();
            Intrinsics.checkNotNullExpressionValue((Object)completableResultCode, (String)"CompletableResultCode.ofFailure()");
            return completableResultCode;
        }
        CompletableResultCode completableResultCode = CompletableResultCode.ofSuccess();
        Intrinsics.checkNotNullExpressionValue((Object)completableResultCode, (String)"CompletableResultCode.ofSuccess()");
        return completableResultCode;
    }

    @Override
    @NotNull
    public List<Log> completedLogs() {
        return CollectionsKt.toList((Iterable)this.storedLogs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Log> flushLogs() {
        Object object = this.flushLock;
        synchronized (object) {
            void var3_4;
            boolean bl = false;
            int n = this.storedLogs.size();
            int n2 = 50;
            int batchSize = Math.min(n, n2);
            List flushedLogs = CollectionExtensionsKt.threadSafeTake((Collection)this.storedLogs, batchSize);
            this.storedLogs.removeAll(CollectionsKt.toSet((Iterable)flushedLogs));
            void var6_8 = var3_4;
            return var6_8;
        }
    }

    @Override
    @Nullable
    public Log pollNonbatchedLog() {
        return this.nonbatchedLogs.poll();
    }

    @Override
    public void registerLogStoredCallback(@NotNull Function0<Unit> onLogsStored) {
        Intrinsics.checkNotNullParameter(onLogsStored, (String)"onLogsStored");
        this.onLogsStored = onLogsStored;
    }
}

