/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk.internal.network.http;

import androidx.annotation.NonNull;
import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;

final class CountingInputStreamWithCallback
extends FilterInputStream {
    private volatile long streamMark = -1L;
    private final Function1<byte[], Unit> callback;
    private volatile boolean callbackCompleted;
    private final AtomicLong count = new AtomicLong(0L);
    private final boolean shouldCaptureBody;
    ByteArrayOutputStream os = new ByteArrayOutputStream();

    CountingInputStreamWithCallback(InputStream in, boolean shouldCaptureBody, @NonNull Function1<byte[], Unit> callback2) {
        super(in);
        this.callback = callback2;
        this.shouldCaptureBody = shouldCaptureBody;
    }

    public long getCount() {
        return this.count.longValue();
    }

    @Override
    public int read() throws IOException {
        int result = this.in.read();
        if (result != -1) {
            this.count.incrementAndGet();
            byte[] resultByte = new byte[]{Integer.valueOf(result).byteValue()};
            this.conditionallyCaptureBody(resultByte, 0, 1);
        } else if (!this.callbackCompleted) {
            this.notifyCallback();
        }
        return result;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int result = this.in.read(b, off, len);
        if (result != -1) {
            this.count.addAndGet(result);
            this.conditionallyCaptureBody(b, off, result);
        } else if (!this.callbackCompleted) {
            this.notifyCallback();
        }
        return result;
    }

    @Override
    public long skip(long n) throws IOException {
        long result = this.in.skip(n);
        this.count.addAndGet(result);
        return result;
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.in.mark(readlimit);
        this.streamMark = this.count.longValue();
    }

    @Override
    public synchronized void reset() throws IOException {
        if (!this.in.markSupported()) {
            throw new IOException("Mark not supported");
        }
        if (this.streamMark == -1L) {
            throw new IOException("Mark not set");
        }
        this.in.reset();
        this.count.set(this.streamMark);
        this.callbackCompleted = false;
    }

    private void conditionallyCaptureBody(byte[] b, int off, int len) {
        if (!this.shouldCaptureBody) {
            return;
        }
        if (b != null) {
            this.os.write(b, off, len);
        }
    }

    private void notifyCallback() {
        this.callbackCompleted = true;
        this.callback.invoke((Object)this.os.toByteArray());
    }
}

