/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk.internal.network.http;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.embrace.android.embracesdk.annotation.InternalApi;
import io.embrace.android.embracesdk.internal.network.http.HttpPathOverrideRequest;
import java.nio.charset.StandardCharsets;
import java.util.regex.Pattern;

@InternalApi
public class EmbraceHttpPathOverride {
    protected static final String PATH_OVERRIDE = "x-emb-path";
    private static final Integer RELATIVE_PATH_MAX_LENGTH = 1024;
    private static final Pattern RELATIVE_PATH_PATTERN = Pattern.compile("[A-Za-z0-9-._~:/\\[\\]@!$&'()*+,;=]+");

    @NonNull
    public static String getURLString(@NonNull HttpPathOverrideRequest request) {
        return EmbraceHttpPathOverride.getURLString(request, request.getHeaderByName(PATH_OVERRIDE));
    }

    @InternalApi
    @NonNull
    public static String getURLString(@NonNull HttpPathOverrideRequest request, @Nullable String pathOverride) {
        String url;
        try {
            url = pathOverride != null && EmbraceHttpPathOverride.validatePathOverride(pathOverride).booleanValue() ? request.getOverriddenURL(pathOverride) : request.getURLString();
        }
        catch (Exception e) {
            url = request.getURLString();
        }
        return url;
    }

    private static Boolean validatePathOverride(String path) {
        if (path == null) {
            return false;
        }
        if (path.isEmpty()) {
            return false;
        }
        if (path.length() > RELATIVE_PATH_MAX_LENGTH) {
            return false;
        }
        if (!StandardCharsets.US_ASCII.newEncoder().canEncode(path)) {
            return false;
        }
        if (!path.startsWith("/")) {
            return false;
        }
        if (!RELATIVE_PATH_PATTERN.matcher(path).matches()) {
            return false;
        }
        return true;
    }
}

