/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk.internal.network.http;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.embrace.android.embracesdk.internal.network.http.HttpPathOverrideRequest;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;

class EmbraceHttpUrlConnectionOverride
implements HttpPathOverrideRequest {
    private final HttpURLConnection connection;

    EmbraceHttpUrlConnectionOverride(HttpURLConnection connection) {
        this.connection = connection;
    }

    @Override
    @Nullable
    public String getHeaderByName(@NonNull String name) {
        return this.connection.getRequestProperty(name);
    }

    @Override
    @NonNull
    public String getOverriddenURL(@NonNull String pathOverride) {
        try {
            return new URL(this.connection.getURL().getProtocol(), this.connection.getURL().getHost(), this.connection.getURL().getPort(), pathOverride + "?" + this.connection.getURL().getQuery()).toString();
        }
        catch (MalformedURLException e) {
            return this.connection.getURL().toString();
        }
    }

    @Override
    @NonNull
    public String getURLString() {
        return this.connection.getURL().toString();
    }
}

