/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk.internal.network.http;

import io.embrace.android.embracesdk.Embrace;
import io.embrace.android.embracesdk.internal.network.http.EmbraceHttpsUrlConnectionImpl;
import io.embrace.android.embracesdk.internal.network.http.EmbraceUrlStreamHandler;
import java.lang.reflect.Method;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import javax.net.ssl.HttpsURLConnection;

final class EmbraceHttpsUrlStreamHandler
extends EmbraceUrlStreamHandler {
    static final int PORT = 443;

    public EmbraceHttpsUrlStreamHandler(URLStreamHandler handler) {
        super(handler);
    }

    EmbraceHttpsUrlStreamHandler(URLStreamHandler handler, Embrace embrace) {
        super(handler, embrace);
    }

    @Override
    public int getDefaultPort() {
        return 443;
    }

    @Override
    protected Method getMethodOpenConnection(Class<URL> url) throws NoSuchMethodException {
        Method method = this.handler.getClass().getSuperclass().getDeclaredMethod("openConnection", url);
        method.setAccessible(true);
        return method;
    }

    @Override
    protected Method getMethodOpenConnection(Class<URL> url, Class<Proxy> proxy) throws NoSuchMethodException {
        Method method = this.handler.getClass().getSuperclass().getDeclaredMethod("openConnection", url, proxy);
        method.setAccessible(true);
        return method;
    }

    @Override
    protected URLConnection wrapUrlConnection(URLConnection connection) {
        if (!(connection instanceof HttpsURLConnection)) {
            return connection;
        }
        this.injectTraceparent(connection);
        if (enableRequestSizeCapture.booleanValue() && !connection.getRequestProperties().containsKey("Accept-Encoding")) {
            connection.setRequestProperty("Accept-Encoding", "gzip");
            return new EmbraceHttpsUrlConnectionImpl<HttpsURLConnection>((HttpsURLConnection)connection, true);
        }
        return new EmbraceHttpsUrlConnectionImpl<HttpsURLConnection>((HttpsURLConnection)connection, false);
    }
}

