/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk.internal.network.http;

import android.annotation.TargetApi;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.embrace.android.embracesdk.Embrace;
import io.embrace.android.embracesdk.annotation.InternalApi;
import io.embrace.android.embracesdk.internal.network.http.CountingInputStreamWithCallback;
import io.embrace.android.embracesdk.internal.network.http.CountingOutputStream;
import io.embrace.android.embracesdk.internal.network.http.EmbraceHttpPathOverride;
import io.embrace.android.embracesdk.internal.network.http.EmbraceHttpUrlConnectionOverride;
import io.embrace.android.embracesdk.internal.network.http.EmbraceHttpsUrlConnection;
import io.embrace.android.embracesdk.internal.network.http.NetworkCaptureData;
import io.embrace.android.embracesdk.network.EmbraceNetworkRequest;
import io.embrace.android.embracesdk.network.http.HttpMethod;
import io.embrace.android.embracesdk.utils.exceptions.function.CheckedSupplier;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLConnection;
import java.security.Permission;
import java.security.Principal;
import java.security.cert.Certificate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSocketFactory;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;

@InternalApi
class EmbraceUrlConnectionDelegate<T extends HttpURLConnection>
implements EmbraceHttpsUrlConnection {
    static final String CONTENT_ENCODING = "Content-Encoding";
    static final String CONTENT_LENGTH = "Content-Length";
    private final T connection;
    private final long createdTime;
    private final boolean enableWrapIoStreams;
    private final Embrace embrace;
    private volatile CountingOutputStream outputStream;
    private volatile boolean didLogNetworkCall = false;
    private volatile Long startTime;
    private volatile String traceId;
    private volatile HashMap<String, String> requestHeaders;
    private volatile Exception inputStreamAccessException;
    private volatile Exception lastConnectionAccessException;
    private final AtomicLong responseSize = new AtomicLong(-1L);
    private final AtomicInteger responseCode = new AtomicInteger(0);
    private final AtomicReference<Map<String, List<String>>> headerFields = new AtomicReference<Object>(null);
    private final AtomicReference<NetworkCaptureData> networkCaptureData = new AtomicReference<Object>(null);
    @Nullable
    private volatile String traceparent = null;
    private final boolean isSDKStarted;

    public EmbraceUrlConnectionDelegate(@NonNull T connection, boolean enableWrapIoStreams) {
        this(connection, enableWrapIoStreams, Embrace.getInstance());
    }

    EmbraceUrlConnectionDelegate(@NonNull T connection, boolean enableWrapIoStreams, @NonNull Embrace embrace) {
        this.connection = connection;
        this.enableWrapIoStreams = enableWrapIoStreams;
        this.embrace = embrace;
        this.createdTime = embrace.getInternalInterface().getSdkCurrentTime();
        this.isSDKStarted = embrace.isStarted();
    }

    @Override
    public void addRequestProperty(@NonNull String key, @Nullable String value) {
        ((URLConnection)this.connection).addRequestProperty(key, value);
    }

    @Override
    public void connect() throws IOException {
        if (this.isSDKStarted) {
            this.identifyTraceId();
            try {
                if (this.embrace.getInternalInterface().isNetworkSpanForwardingEnabled()) {
                    this.traceparent = ((URLConnection)this.connection).getRequestProperty("traceparent");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        ((URLConnection)this.connection).connect();
    }

    @Override
    public void disconnect() {
        this.setStartTime(this.createdTime);
        this.internalLogNetworkCall();
        ((HttpURLConnection)this.connection).disconnect();
    }

    @Override
    public boolean getAllowUserInteraction() {
        return ((URLConnection)this.connection).getAllowUserInteraction();
    }

    @Override
    public void setAllowUserInteraction(boolean allowUserInteraction) {
        ((URLConnection)this.connection).setAllowUserInteraction(allowUserInteraction);
    }

    @Override
    public int getConnectTimeout() {
        return ((URLConnection)this.connection).getConnectTimeout();
    }

    @Override
    public void setConnectTimeout(int timeout) {
        ((URLConnection)this.connection).setConnectTimeout(timeout);
    }

    @Override
    @Nullable
    public Object getContent() throws IOException {
        this.identifyTraceId();
        return ((URLConnection)this.connection).getContent();
    }

    @Override
    @Nullable
    public Object getContent(@NonNull Class<?>[] classes) throws IOException {
        this.identifyTraceId();
        return ((URLConnection)this.connection).getContent(classes);
    }

    @Override
    @Nullable
    public String getContentEncoding() {
        return this.shouldUncompressGzip() ? null : ((URLConnection)this.connection).getContentEncoding();
    }

    @Override
    public int getContentLength() {
        return this.shouldUncompressGzip() ? -1 : ((URLConnection)this.connection).getContentLength();
    }

    @Override
    @TargetApi(value=24)
    public long getContentLengthLong() {
        return this.shouldUncompressGzip() || Build.VERSION.SDK_INT < 24 ? -1L : ((URLConnection)this.connection).getContentLengthLong();
    }

    @Override
    @Nullable
    public String getContentType() {
        return ((URLConnection)this.connection).getContentType();
    }

    @Override
    public long getDate() {
        return ((URLConnection)this.connection).getDate();
    }

    @Override
    public boolean getDefaultUseCaches() {
        return ((URLConnection)this.connection).getDefaultUseCaches();
    }

    @Override
    public void setDefaultUseCaches(boolean defaultUseCaches) {
        ((URLConnection)this.connection).setDefaultUseCaches(defaultUseCaches);
    }

    @Override
    public boolean getDoInput() {
        return ((URLConnection)this.connection).getDoInput();
    }

    @Override
    public void setDoInput(boolean doInput) {
        ((URLConnection)this.connection).setDoInput(doInput);
    }

    @Override
    public boolean getDoOutput() {
        return ((URLConnection)this.connection).getDoOutput();
    }

    @Override
    public void setDoOutput(boolean doOutput) {
        ((URLConnection)this.connection).setDoOutput(doOutput);
    }

    @Override
    @Nullable
    public InputStream getErrorStream() {
        return this.getWrappedInputStream(((HttpURLConnection)this.connection).getErrorStream());
    }

    private boolean shouldInterceptHeaderRetrieval(@Nullable String key) {
        return this.shouldUncompressGzip() && key != null && (key.equalsIgnoreCase(CONTENT_ENCODING) || key.equalsIgnoreCase(CONTENT_LENGTH));
    }

    @Override
    @Nullable
    public String getHeaderField(int n) {
        String key = ((HttpURLConnection)this.connection).getHeaderFieldKey(n);
        return this.retrieveHeaderField(key, null, () -> ((HttpURLConnection)this.connection).getHeaderField(n));
    }

    @Override
    @Nullable
    public String getHeaderField(@Nullable String name) {
        return this.retrieveHeaderField(name, null, () -> ((URLConnection)this.connection).getHeaderField(name));
    }

    @Override
    @Nullable
    public String getHeaderFieldKey(int n) {
        String key = ((HttpURLConnection)this.connection).getHeaderFieldKey(n);
        return this.retrieveHeaderField(key, null, () -> key);
    }

    @Override
    public long getHeaderFieldDate(@NonNull String name, long defaultValue) {
        Long result = this.retrieveHeaderField(name, defaultValue, () -> ((HttpURLConnection)this.connection).getHeaderFieldDate(name, defaultValue));
        return result != null ? result : defaultValue;
    }

    @Override
    public int getHeaderFieldInt(@NonNull String name, int defaultValue) {
        Integer result = this.retrieveHeaderField(name, defaultValue, () -> ((URLConnection)this.connection).getHeaderFieldInt(name, defaultValue));
        return result != null ? result : defaultValue;
    }

    @Override
    @TargetApi(value=24)
    public long getHeaderFieldLong(@NonNull String name, long defaultValue) {
        Long result = this.retrieveHeaderField(name, defaultValue, () -> Build.VERSION.SDK_INT < 24 ? -1L : ((URLConnection)this.connection).getHeaderFieldLong(name, defaultValue));
        return result != null ? result : defaultValue;
    }

    @Override
    @Nullable
    public Map<String, List<String>> getHeaderFields() {
        this.cacheNetworkCallData();
        return this.headerFields.get();
    }

    private <R> R retrieveHeaderField(@Nullable String name, R defaultValue, Function0<R> action2) {
        if (name == null) {
            return null;
        }
        if (this.shouldInterceptHeaderRetrieval(name)) {
            return defaultValue;
        }
        Object result = action2.invoke();
        this.cacheNetworkCallData();
        return (R)result;
    }

    @Override
    public long getIfModifiedSince() {
        return ((URLConnection)this.connection).getIfModifiedSince();
    }

    @Override
    public void setIfModifiedSince(long ifModifiedSince) {
        ((URLConnection)this.connection).setIfModifiedSince(ifModifiedSince);
    }

    @Override
    @Nullable
    public InputStream getInputStream() throws IOException {
        try {
            return this.getWrappedInputStream(((URLConnection)this.connection).getInputStream());
        }
        catch (IOException e) {
            this.inputStreamAccessException = e;
            throw e;
        }
    }

    @Override
    public boolean getInstanceFollowRedirects() {
        return ((HttpURLConnection)this.connection).getInstanceFollowRedirects();
    }

    @Override
    public void setInstanceFollowRedirects(boolean followRedirects) {
        ((HttpURLConnection)this.connection).setInstanceFollowRedirects(followRedirects);
    }

    @Override
    public long getLastModified() {
        return ((URLConnection)this.connection).getLastModified();
    }

    @Override
    @Nullable
    public OutputStream getOutputStream() throws IOException {
        this.identifyTraceId();
        OutputStream out = ((URLConnection)this.connection).getOutputStream();
        if (this.enableWrapIoStreams && this.outputStream == null && out != null) {
            this.outputStream = new CountingOutputStream(out);
            return this.outputStream;
        }
        return out;
    }

    @Override
    @Nullable
    public Permission getPermission() throws IOException {
        return ((HttpURLConnection)this.connection).getPermission();
    }

    @Override
    public int getReadTimeout() {
        return ((URLConnection)this.connection).getReadTimeout();
    }

    @Override
    public void setReadTimeout(int timeout) {
        ((URLConnection)this.connection).setReadTimeout(timeout);
    }

    @Override
    @NonNull
    public String getRequestMethod() {
        return ((HttpURLConnection)this.connection).getRequestMethod();
    }

    @Override
    public void setRequestMethod(@NonNull String method) throws ProtocolException {
        ((HttpURLConnection)this.connection).setRequestMethod(method);
    }

    @Override
    @Nullable
    public Map<String, List<String>> getRequestProperties() {
        return ((URLConnection)this.connection).getRequestProperties();
    }

    @Override
    @Nullable
    public String getRequestProperty(@NonNull String key) {
        return ((URLConnection)this.connection).getRequestProperty(key);
    }

    @Override
    public int getResponseCode() {
        this.identifyTraceId();
        this.cacheNetworkCallData();
        return this.responseCode.get();
    }

    @Override
    @Nullable
    public String getResponseMessage() throws IOException {
        this.identifyTraceId();
        this.cacheNetworkCallData();
        return ((HttpURLConnection)this.connection).getResponseMessage();
    }

    @Override
    @Nullable
    public URL getUrl() {
        return ((URLConnection)this.connection).getURL();
    }

    @Override
    public boolean getUseCaches() {
        return ((URLConnection)this.connection).getUseCaches();
    }

    @Override
    public void setUseCaches(boolean useCaches) {
        ((URLConnection)this.connection).setUseCaches(useCaches);
    }

    @Override
    public void setChunkedStreamingMode(int chunkLen) {
        ((HttpURLConnection)this.connection).setChunkedStreamingMode(chunkLen);
    }

    @Override
    public void setFixedLengthStreamingMode(int contentLength) {
        ((HttpURLConnection)this.connection).setFixedLengthStreamingMode(contentLength);
    }

    @Override
    public void setFixedLengthStreamingMode(long contentLength) {
        ((HttpURLConnection)this.connection).setFixedLengthStreamingMode(contentLength);
    }

    @Override
    public void setRequestProperty(@NonNull String key, @Nullable String value) {
        ((URLConnection)this.connection).setRequestProperty(key, value);
        if (this.hasNetworkCaptureRules()) {
            this.requestHeaders = this.getProcessedHeaders(this.getRequestProperties());
        }
    }

    @Override
    @NonNull
    public String toString() {
        return ((URLConnection)this.connection).toString();
    }

    @Override
    public boolean usingProxy() {
        return ((HttpURLConnection)this.connection).usingProxy();
    }

    synchronized void internalLogNetworkCall() {
        if (this.isSDKStarted && !this.didLogNetworkCall) {
            this.didLogNetworkCall = true;
            long endTime = this.embrace.getInternalInterface().getSdkCurrentTime();
            String url = EmbraceHttpPathOverride.getURLString(new EmbraceHttpUrlConnectionOverride((HttpURLConnection)this.connection));
            try {
                long bytesOut = this.outputStream == null ? 0L : Math.max(this.outputStream.getCount(), 0L);
                long contentLength = Math.max(0L, this.responseSize.get());
                if (this.inputStreamAccessException == null && this.lastConnectionAccessException == null && this.responseCode.get() != 0) {
                    this.embrace.getInternalInterface().recordNetworkRequest(EmbraceNetworkRequest.fromCompletedRequest(url, HttpMethod.fromString(this.getRequestMethod()), this.startTime, endTime, bytesOut, contentLength, this.responseCode.get(), this.traceId, this.traceparent, this.networkCaptureData.get()));
                } else {
                    String exceptionClass = null;
                    String exceptionMessage = null;
                    if (this.inputStreamAccessException != null) {
                        exceptionClass = this.inputStreamAccessException.getClass().getCanonicalName();
                        exceptionMessage = this.inputStreamAccessException.getMessage();
                    } else if (this.lastConnectionAccessException != null) {
                        exceptionClass = this.lastConnectionAccessException.getClass().getCanonicalName();
                        exceptionMessage = this.lastConnectionAccessException.getMessage();
                    }
                    String errorType = exceptionClass != null ? exceptionClass : "UnknownState";
                    String errorMessage = exceptionMessage != null ? exceptionMessage : "HTTP response state unknown";
                    this.embrace.getInternalInterface().recordNetworkRequest(EmbraceNetworkRequest.fromIncompleteRequest(url, HttpMethod.fromString(this.getRequestMethod()), this.startTime, endTime, errorType, errorMessage, this.traceId, this.traceparent, this.networkCaptureData.get()));
                }
            }
            catch (Exception e) {
                this.logError(e);
            }
        }
    }

    @Nullable
    private HashMap<String, String> getProcessedHeaders(@Nullable Map<String, List<String>> properties) {
        if (properties == null) {
            return null;
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        for (Map.Entry<String, List<String>> h : properties.entrySet()) {
            StringBuilder builder = new StringBuilder();
            for (String value : h.getValue()) {
                if (value == null) continue;
                builder.append(value);
            }
            headers.put(h.getKey(), builder.toString());
        }
        return headers;
    }

    private CountingInputStreamWithCallback countingInputStream(InputStream inputStream) {
        return new CountingInputStreamWithCallback(inputStream, this.hasNetworkCaptureRules(), (Function1<byte[], Unit>)((Function1)responseBody -> {
            this.cacheNetworkCallData((byte[])responseBody);
            this.internalLogNetworkCall();
            return null;
        }));
    }

    private boolean shouldUncompressGzip() {
        String contentEncoding = ((URLConnection)this.connection).getContentEncoding();
        return this.enableWrapIoStreams && contentEncoding != null && contentEncoding.equalsIgnoreCase("gzip");
    }

    private void identifyTraceId() {
        if (this.isSDKStarted && this.traceId == null) {
            try {
                this.traceId = this.getRequestProperty(this.embrace.getTraceIdHeader());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    @Nullable
    public String getCipherSuite() {
        if (this.connection instanceof HttpsURLConnection) {
            return ((HttpsURLConnection)this.connection).getCipherSuite();
        }
        return null;
    }

    @Override
    @Nullable
    public Certificate[] getLocalCertificates() {
        if (this.connection instanceof HttpsURLConnection) {
            return ((HttpsURLConnection)this.connection).getLocalCertificates();
        }
        return new Certificate[0];
    }

    @Override
    @Nullable
    public Certificate[] getServerCertificates() throws SSLPeerUnverifiedException {
        if (this.connection instanceof HttpsURLConnection) {
            return ((HttpsURLConnection)this.connection).getServerCertificates();
        }
        return new Certificate[0];
    }

    @Override
    @Nullable
    public SSLSocketFactory getSslSocketFactory() {
        if (this.connection instanceof HttpsURLConnection) {
            return ((HttpsURLConnection)this.connection).getSSLSocketFactory();
        }
        return null;
    }

    @Override
    public void setSslSocketFactory(@NonNull SSLSocketFactory factory) {
        if (this.connection instanceof HttpsURLConnection) {
            ((HttpsURLConnection)this.connection).setSSLSocketFactory(factory);
        }
    }

    @Override
    @Nullable
    public HostnameVerifier getHostnameVerifier() {
        if (this.connection instanceof HttpsURLConnection) {
            return ((HttpsURLConnection)this.connection).getHostnameVerifier();
        }
        return null;
    }

    @Override
    public void setHostnameVerifier(@NonNull HostnameVerifier verifier) {
        if (this.connection instanceof HttpsURLConnection) {
            ((HttpsURLConnection)this.connection).setHostnameVerifier(verifier);
        }
    }

    @Override
    @Nullable
    public Principal getLocalPrincipal() {
        if (this.connection instanceof HttpsURLConnection) {
            return ((HttpsURLConnection)this.connection).getLocalPrincipal();
        }
        return null;
    }

    @Override
    @Nullable
    public Principal getPeerPrincipal() throws SSLPeerUnverifiedException {
        if (this.connection instanceof HttpsURLConnection) {
            return ((HttpsURLConnection)this.connection).getPeerPrincipal();
        }
        return null;
    }

    @Nullable
    private InputStream getWrappedInputStream(InputStream connectionInputStream) {
        this.identifyTraceId();
        this.setStartTime(this.embrace.getInternalInterface().getSdkCurrentTime());
        InputStream in = null;
        if (this.shouldUncompressGzip()) {
            try {
                CheckedSupplier<GZIPInputStream> gzipInputStreamSupplier = () -> new GZIPInputStream(connectionInputStream);
                in = this.countingInputStream(new BufferedInputStream(gzipInputStreamSupplier.get()));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (in == null) {
            in = this.enableWrapIoStreams ? this.countingInputStream(new BufferedInputStream(connectionInputStream)) : connectionInputStream;
        }
        this.cacheNetworkCallData();
        return in;
    }

    private boolean hasNetworkCaptureRules() {
        if (!this.isSDKStarted || ((URLConnection)this.connection).getURL() == null) {
            return false;
        }
        String url = ((URLConnection)this.connection).getURL().toString();
        String method = ((HttpURLConnection)this.connection).getRequestMethod();
        return this.embrace.getInternalInterface().shouldCaptureNetworkBody(url, method);
    }

    private void cacheNetworkCallData() {
        this.cacheNetworkCallData(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheNetworkCallData(@Nullable byte[] responseBody) {
        Serializable serializable;
        if (!this.isSDKStarted) {
            return;
        }
        this.setStartTime(this.embrace.getInternalInterface().getSdkCurrentTime());
        if (this.headerFields.get() == null) {
            serializable = this.headerFields;
            synchronized (serializable) {
                if (this.headerFields.get() == null) {
                    try {
                        Map<String, List<String>> responseHeaders;
                        if (!this.enableWrapIoStreams) {
                            responseHeaders = ((URLConnection)this.connection).getHeaderFields();
                        } else {
                            responseHeaders = new HashMap<String, List<String>>(((URLConnection)this.connection).getHeaderFields());
                            responseHeaders.remove(CONTENT_ENCODING);
                            responseHeaders.remove(CONTENT_LENGTH);
                        }
                        this.headerFields.set(responseHeaders);
                    }
                    catch (Exception e) {
                        this.lastConnectionAccessException = e;
                    }
                }
            }
        }
        if (this.responseCode.get() == 0) {
            serializable = this.responseCode;
            synchronized (serializable) {
                if (this.responseCode.get() == 0) {
                    try {
                        this.responseCode.set(((HttpURLConnection)this.connection).getResponseCode());
                    }
                    catch (Exception e) {
                        this.lastConnectionAccessException = e;
                    }
                }
            }
        }
        if (this.responseSize.get() == -1L) {
            serializable = this.responseSize;
            synchronized (serializable) {
                if (this.responseSize.get() == -1L) {
                    try {
                        this.responseSize.set(((URLConnection)this.connection).getContentLength());
                    }
                    catch (Exception e) {
                        this.lastConnectionAccessException = e;
                    }
                }
            }
        }
        if (!this.enableWrapIoStreams) {
            this.internalLogNetworkCall();
        }
        if (this.shouldCaptureNetworkData()) {
            serializable = this.networkCaptureData;
            synchronized (serializable) {
                if (this.shouldCaptureNetworkData()) {
                    try {
                        NetworkCaptureData existingData = this.networkCaptureData.get();
                        if (existingData == null) {
                            HashMap<String, String> requestHeaders = this.requestHeaders;
                            String requestQueryParams = ((URLConnection)this.connection).getURL().getQuery();
                            byte[] requestBody = this.outputStream != null ? this.outputStream.getRequestBody() : null;
                            HashMap<String, String> responseHeaders = this.getProcessedHeaders(this.headerFields.get());
                            this.networkCaptureData.set(new NetworkCaptureData(requestHeaders, requestQueryParams, requestBody, responseHeaders, responseBody, null));
                        } else if (responseBody != null) {
                            this.networkCaptureData.set(new NetworkCaptureData(existingData.getRequestHeaders(), existingData.getRequestQueryParams(), existingData.getCapturedRequestBody(), existingData.getResponseHeaders(), responseBody, null));
                        }
                    }
                    catch (Exception e) {
                        this.lastConnectionAccessException = e;
                    }
                }
            }
        }
    }

    private boolean shouldCaptureNetworkData() {
        return !(!this.hasNetworkCaptureRules() || !this.enableWrapIoStreams && this.inputStreamAccessException == null || this.networkCaptureData.get() != null && this.networkCaptureData.get().getCapturedResponseBody() != null);
    }

    private void setStartTime(@NonNull Long startTimeMs) {
        if (this.startTime == null) {
            this.startTime = startTimeMs;
        }
    }

    private void logError(@NonNull Throwable t) {
        Embrace.getInstance().getInternalInterface().logInternalError(t);
    }
}

