/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk.internal.network.http;

import androidx.annotation.NonNull;
import io.embrace.android.embracesdk.Embrace;
import io.embrace.android.embracesdk.internal.network.http.EmbraceHttpUrlStreamHandler;
import io.embrace.android.embracesdk.internal.network.http.EmbraceHttpsUrlStreamHandler;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.HashMap;
import java.util.Map;

final class EmbraceUrlStreamHandlerFactory
implements URLStreamHandlerFactory {
    private static final String PROTOCOL_HTTP = "http";
    private static final String PROTOCOL_HTTPS = "https";
    private static final String CLASS_HTTP_OKHTTP_STREAM_HANDLER = "com.android.okhttp.HttpHandler";
    private static final String CLASS_HTTPS_OKHTTP_STREAM_HANDLER = "com.android.okhttp.HttpsHandler";
    private static final Map<String, URLStreamHandler> handlers = new HashMap<String, URLStreamHandler>();

    EmbraceUrlStreamHandlerFactory() {
    }

    static URLStreamHandler newUrlStreamHandler(String className) {
        try {
            return (URLStreamHandler)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            EmbraceUrlStreamHandlerFactory.logError(e);
            return null;
        }
    }

    private static void logError(@NonNull Throwable throwable) {
        Embrace.getInstance().getInternalInterface().logInternalError(throwable);
    }

    @Override
    public URLStreamHandler createURLStreamHandler(String protocol) {
        return protocol != null ? handlers.get(protocol) : null;
    }

    static {
        try {
            handlers.put(PROTOCOL_HTTP, new EmbraceHttpUrlStreamHandler(EmbraceUrlStreamHandlerFactory.newUrlStreamHandler(CLASS_HTTP_OKHTTP_STREAM_HANDLER)));
            handlers.put(PROTOCOL_HTTPS, new EmbraceHttpsUrlStreamHandler(EmbraceUrlStreamHandlerFactory.newUrlStreamHandler(CLASS_HTTPS_OKHTTP_STREAM_HANDLER)));
        }
        catch (Exception ex) {
            EmbraceUrlStreamHandlerFactory.logError(ex);
        }
    }
}

