/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk.internal.network.http;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.embrace.android.embracesdk.Embrace;
import io.embrace.android.embracesdk.internal.network.http.EmbraceHttpUrlConnectionImpl;
import io.embrace.android.embracesdk.internal.network.http.EmbraceHttpsUrlConnectionImpl;
import io.embrace.android.embracesdk.internal.network.http.EmbraceUrlStreamHandler;
import io.embrace.android.embracesdk.internal.network.http.EmbraceUrlStreamHandlerFactory;
import io.embrace.android.embracesdk.utils.exceptions.Unchecked;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import javax.net.ssl.HttpsURLConnection;

class StreamHandlerFactoryInstaller {
    private StreamHandlerFactoryInstaller() {
    }

    static void registerFactory(Boolean enableRequestSizeCapture) {
        EmbraceUrlStreamHandler.setEnableRequestSizeCapture(enableRequestSizeCapture);
        try {
            Object existingFactory = StreamHandlerFactoryInstaller.getFactoryField().get(null);
            if (existingFactory == null) {
                URL.setURLStreamHandlerFactory(new EmbraceUrlStreamHandlerFactory());
            } else {
                WrappingFactory wrappingFactory = new WrappingFactory((URLStreamHandlerFactory)existingFactory, enableRequestSizeCapture);
                StreamHandlerFactoryInstaller.clearFactory();
                URL.setURLStreamHandlerFactory(wrappingFactory);
            }
        }
        catch (Throwable ex) {
            String msg = "Error during wrapping of UrlStreamHandlerFactory. Will attempt to set the default Embrace factory";
            StreamHandlerFactoryInstaller.logError(msg, ex);
            try {
                URL.setURLStreamHandlerFactory(new EmbraceUrlStreamHandlerFactory());
            }
            catch (Throwable ex2) {
                StreamHandlerFactoryInstaller.logError("Failed to register EmbraceUrlStreamHandlerFactory. Network capture disabled.", ex2);
            }
        }
    }

    private static Field getFactoryField() {
        Field[] fields;
        for (Field current : fields = URL.class.getDeclaredFields()) {
            if (!Modifier.isStatic(current.getModifiers()) || !current.getType().equals(URLStreamHandlerFactory.class)) continue;
            current.setAccessible(true);
            return current;
        }
        throw new IllegalStateException("Unable to detect static field in the URL class for the URLStreamHandlerFactory.");
    }

    private static void clearFactory() {
        try {
            Field factoryField = StreamHandlerFactoryInstaller.getFactoryField();
            factoryField.set(null, null);
        }
        catch (Exception ex) {
            throw Unchecked.propagate(ex);
        }
    }

    static void logError(@NonNull String message, @Nullable Throwable throwable) {
        if (throwable != null) {
            Embrace.getInstance().getInternalInterface().logInternalError(throwable);
        }
    }

    private static class WrappingFactory
    implements URLStreamHandlerFactory {
        private final URLStreamHandlerFactory parent;
        final Boolean enableRequestSizeCapture;

        WrappingFactory(@NonNull URLStreamHandlerFactory parent, Boolean enableRequestSizeCapture) {
            this.parent = parent;
            this.enableRequestSizeCapture = enableRequestSizeCapture;
        }

        @Override
        public URLStreamHandler createURLStreamHandler(final String protocol) {
            URLStreamHandler parentHandler;
            try {
                parentHandler = this.parent.createURLStreamHandler(protocol);
            }
            catch (Exception ex) {
                String msg = "Exception when trying to create stream handler with parent factory for protocol: " + protocol;
                StreamHandlerFactoryInstaller.logError(msg, ex);
                return new EmbraceUrlStreamHandlerFactory().createURLStreamHandler(protocol);
            }
            if (parentHandler == null) {
                return new EmbraceUrlStreamHandlerFactory().createURLStreamHandler(protocol);
            }
            return new URLStreamHandler(){

                @Override
                protected URLConnection openConnection(URL url, Proxy proxy) {
                    try {
                        Method method = parentHandler.getClass().getDeclaredMethod("openConnection", URL.class, Proxy.class);
                        method.setAccessible(true);
                        URLConnection parentConnection = (URLConnection)method.invoke((Object)parentHandler, url, proxy);
                        return this.wrapConnection(parentConnection);
                    }
                    catch (Exception ex) {
                        String msg = "Exception when opening connection for protocol: " + protocol + " and URL: " + url;
                        StreamHandlerFactoryInstaller.logError(msg, ex);
                        throw Unchecked.propagate(ex);
                    }
                }

                @Override
                protected URLConnection openConnection(URL url) {
                    try {
                        Method method = parentHandler.getClass().getDeclaredMethod("openConnection", URL.class);
                        method.setAccessible(true);
                        URLConnection parentConnection = (URLConnection)method.invoke((Object)parentHandler, url);
                        return this.wrapConnection(parentConnection);
                    }
                    catch (Exception ex) {
                        String msg = "Exception when opening connection for protocol: " + protocol + " and URL: " + url;
                        StreamHandlerFactoryInstaller.logError(msg, ex);
                        throw Unchecked.propagate(ex);
                    }
                }

                private URLConnection wrapConnection(URLConnection parentConnection) {
                    if (parentConnection instanceof HttpURLConnection) {
                        boolean transparentGzip = false;
                        if (enableRequestSizeCapture.booleanValue() && !parentConnection.getRequestProperties().containsKey("Accept-Encoding")) {
                            parentConnection.setRequestProperty("Accept-Encoding", "gzip");
                            transparentGzip = true;
                        }
                        if (parentConnection instanceof HttpsURLConnection) {
                            return new EmbraceHttpsUrlConnectionImpl<HttpsURLConnection>((HttpsURLConnection)parentConnection, transparentGzip);
                        }
                        return new EmbraceHttpUrlConnectionImpl<HttpURLConnection>((HttpURLConnection)parentConnection, transparentGzip);
                    }
                    StreamHandlerFactoryInstaller.logError("Cannot wrap unsupported protocol: " + protocol, null);
                    return parentConnection;
                }
            };
        }
    }
}

