/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk.internal.spans;

import io.embrace.android.embracesdk.arch.destination.SessionSpanWriter;
import io.embrace.android.embracesdk.arch.destination.SpanAttributeData;
import io.embrace.android.embracesdk.arch.schema.AppTerminationCause;
import io.embrace.android.embracesdk.arch.schema.EmbType;
import io.embrace.android.embracesdk.arch.schema.SchemaType;
import io.embrace.android.embracesdk.internal.clock.ClockKt;
import io.embrace.android.embracesdk.internal.spans.CurrentSessionSpan;
import io.embrace.android.embracesdk.internal.spans.EmbraceExtensionsKt;
import io.embrace.android.embracesdk.internal.spans.EmbraceSpanData;
import io.embrace.android.embracesdk.internal.spans.EmbraceSpanFactory;
import io.embrace.android.embracesdk.internal.spans.SpanRepository;
import io.embrace.android.embracesdk.internal.spans.SpanSink;
import io.embrace.android.embracesdk.internal.utils.Uuid;
import io.embrace.android.embracesdk.opentelemetry.EmbraceAttributeKeysKt;
import io.embrace.android.embracesdk.spans.EmbraceSpan;
import io.embrace.android.embracesdk.spans.ErrorCode;
import io.embrace.android.embracesdk.spans.PersistableEmbraceSpan;
import io.embrace.android.embracesdk.telemetry.TelemetryService;
import io.opentelemetry.sdk.common.Clock;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B=\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0016\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\r0\fj\b\u0012\u0004\u0012\u00020\r`\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0018\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u001a\u0010!\u001a\u00020\u00192\b\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010$\u001a\u00020\u0019H\u0016J\u0018\u0010%\u001a\u00020\u00192\u0006\u0010&\u001a\u00020\u00132\u0006\u0010'\u001a\u00020(H\u0002J \u0010)\u001a\b\u0012\u0004\u0012\u00020+0*2\u0006\u0010,\u001a\u00020\u00192\b\u0010-\u001a\u0004\u0018\u00010.H\u0016J\b\u0010/\u001a\u000200H\u0016J\u0010\u00101\u001a\u0002022\u0006\u00103\u001a\u00020 H\u0016J\b\u0010\u0010\u001a\u00020\u0019H\u0016J\u0010\u00104\u001a\u00020\u00192\u0006\u00105\u001a\u000200H\u0016J\u0010\u00106\u001a\u0002022\u0006\u00107\u001a\u000208H\u0016J\u0010\u00109\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020 H\u0002R\u001e\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\r0\fj\b\u0012\u0004\u0012\u00020\r`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lio/embrace/android/embracesdk/internal/spans/CurrentSessionSpanImpl;", "Lio/embrace/android/embracesdk/internal/spans/CurrentSessionSpan;", "Lio/embrace/android/embracesdk/arch/destination/SessionSpanWriter;", "openTelemetryClock", "Lio/opentelemetry/sdk/common/Clock;", "telemetryService", "Lio/embrace/android/embracesdk/telemetry/TelemetryService;", "spanRepository", "Lio/embrace/android/embracesdk/internal/spans/SpanRepository;", "spanSink", "Lio/embrace/android/embracesdk/internal/spans/SpanSink;", "embraceSpanFactorySupplier", "Lkotlin/Function0;", "Lio/embrace/android/embracesdk/internal/spans/EmbraceSpanFactory;", "Lio/embrace/android/embracesdk/internal/utils/Provider;", "(Lio/opentelemetry/sdk/common/Clock;Lio/embrace/android/embracesdk/telemetry/TelemetryService;Lio/embrace/android/embracesdk/internal/spans/SpanRepository;Lio/embrace/android/embracesdk/internal/spans/SpanSink;Lkotlin/jvm/functions/Function0;)V", "initialized", "Ljava/util/concurrent/atomic/AtomicBoolean;", "internalTraceCount", "Ljava/util/concurrent/atomic/AtomicInteger;", "sessionSpan", "Ljava/util/concurrent/atomic/AtomicReference;", "Lio/embrace/android/embracesdk/spans/PersistableEmbraceSpan;", "traceCount", "addCustomAttribute", "", "attribute", "Lio/embrace/android/embracesdk/arch/destination/SpanAttributeData;", "addEvent", "schemaType", "Lio/embrace/android/embracesdk/arch/schema/SchemaType;", "startTimeMs", "", "canStartNewSpan", "parent", "Lio/embrace/android/embracesdk/spans/EmbraceSpan;", "internal", "checkTraceCount", "counter", "limit", "", "endSession", "", "Lio/embrace/android/embracesdk/internal/spans/EmbraceSpanData;", "startNewSession", "appTerminationCause", "Lio/embrace/android/embracesdk/arch/schema/AppTerminationCause;", "getSessionId", "", "initializeService", "", "sdkInitStartTimeMs", "removeCustomAttribute", "key", "removeEvents", "type", "Lio/embrace/android/embracesdk/arch/schema/EmbType;", "startSessionSpan", "embrace-android-sdk_release"})
public final class CurrentSessionSpanImpl
implements CurrentSessionSpan,
SessionSpanWriter {
    private final AtomicInteger traceCount;
    private final AtomicInteger internalTraceCount;
    private final AtomicBoolean initialized;
    private final AtomicReference<PersistableEmbraceSpan> sessionSpan;
    private final Clock openTelemetryClock;
    private final TelemetryService telemetryService;
    private final SpanRepository spanRepository;
    private final SpanSink spanSink;
    private final Function0<EmbraceSpanFactory> embraceSpanFactorySupplier;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initializeService(long sdkInitStartTimeMs) {
        if (!this.initialized.get()) {
            AtomicReference<PersistableEmbraceSpan> atomicReference = this.sessionSpan;
            synchronized (atomicReference) {
                boolean bl = false;
                if (!this.initialized.get()) {
                    this.sessionSpan.set(this.startSessionSpan(sdkInitStartTimeMs));
                    this.initialized.set(this.sessionSpan.get() != null);
                }
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    @Override
    public boolean initialized() {
        return this.initialized.get();
    }

    @Override
    public boolean canStartNewSpan(@Nullable EmbraceSpan parent, boolean internal) {
        PersistableEmbraceSpan persistableEmbraceSpan = this.sessionSpan.get();
        if (persistableEmbraceSpan == null) {
            return false;
        }
        PersistableEmbraceSpan currentSession = persistableEmbraceSpan;
        if (!currentSession.isRecording() || parent != null && parent.getSpanId() == null) {
            return false;
        }
        return internal ? this.checkTraceCount(this.internalTraceCount, 5000) : this.checkTraceCount(this.traceCount, 500);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean checkTraceCount(AtomicInteger counter, int limit) {
        boolean bl;
        if (counter.get() >= limit) {
            bl = false;
        } else {
            synchronized (counter) {
                boolean bl2 = false;
                boolean bl3 = counter.getAndIncrement() < limit;
                // MONITOREXIT @DISABLED, blocks:[0, 1, 3] lbl9 : MonitorExitStatement: MONITOREXIT : counter
                bl = bl3;
            }
        }
        return bl;
    }

    @Override
    @NotNull
    public String getSessionId() {
        Object object = this.sessionSpan.get();
        if (object == null || (object = object.getSystemAttribute(EmbraceAttributeKeysKt.getEmbSessionId())) == null) {
            object = "";
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<EmbraceSpanData> endSession(boolean startNewSession, @Nullable AppTerminationCause appTerminationCause) {
        AtomicReference<PersistableEmbraceSpan> atomicReference = this.sessionSpan;
        synchronized (atomicReference) {
            List<EmbraceSpanData> list;
            boolean bl = false;
            PersistableEmbraceSpan endingSessionSpan = this.sessionSpan.get();
            if (endingSessionSpan != null && endingSessionSpan.isRecording()) {
                Map<String, String> telemetryAttributes;
                Map<String, String> $this$forEach$iv = telemetryAttributes = this.telemetryService.getAndClearTelemetryAttributes();
                boolean $i$f$forEach = false;
                Map<String, String> map = $this$forEach$iv;
                boolean bl2 = false;
                Iterator<Map.Entry<String, String>> iterator = map.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, String> element$iv;
                    Map.Entry<String, String> it = element$iv = iterator.next();
                    boolean bl3 = false;
                    endingSessionSpan.addAttribute(it.getKey(), it.getValue());
                }
                if (appTerminationCause == null) {
                    endingSessionSpan.stop();
                    this.spanRepository.clearCompletedSpans();
                    PersistableEmbraceSpan newSession = startNewSession ? this.startSessionSpan(ClockKt.nanosToMillis(this.openTelemetryClock.now())) : null;
                    this.sessionSpan.set(newSession);
                } else {
                    long crashTime = ClockKt.nanosToMillis(this.openTelemetryClock.now());
                    this.spanRepository.failActiveSpans(crashTime);
                    endingSessionSpan.setSystemAttribute(appTerminationCause.getKey(), appTerminationCause.getValue());
                    endingSessionSpan.stop(ErrorCode.FAILURE, crashTime);
                }
                list = this.spanSink.flushSpans();
            } else {
                list = CollectionsKt.emptyList();
            }
            List<EmbraceSpanData> list2 = list;
            return list2;
        }
    }

    @Override
    public boolean addEvent(@NotNull SchemaType schemaType, long startTimeMs) {
        Intrinsics.checkNotNullParameter((Object)schemaType, (String)"schemaType");
        PersistableEmbraceSpan persistableEmbraceSpan = this.sessionSpan.get();
        if (persistableEmbraceSpan == null) {
            return false;
        }
        PersistableEmbraceSpan currentSession = persistableEmbraceSpan;
        return currentSession.addEvent(EmbraceExtensionsKt.toEmbraceObjectName(schemaType.getFixedObjectName()), startTimeMs, MapsKt.plus(schemaType.attributes(), schemaType.getTelemetryType().toEmbraceKeyValuePair()));
    }

    @Override
    public void removeEvents(@NotNull EmbType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        PersistableEmbraceSpan persistableEmbraceSpan = this.sessionSpan.get();
        if (persistableEmbraceSpan == null) {
            return;
        }
        PersistableEmbraceSpan currentSession = persistableEmbraceSpan;
        currentSession.removeEvents(type);
    }

    @Override
    public boolean addCustomAttribute(@NotNull SpanAttributeData attribute) {
        Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
        PersistableEmbraceSpan persistableEmbraceSpan = this.sessionSpan.get();
        if (persistableEmbraceSpan == null) {
            return false;
        }
        PersistableEmbraceSpan currentSession = persistableEmbraceSpan;
        return currentSession.addAttribute(attribute.getKey(), attribute.getValue());
    }

    @Override
    public boolean removeCustomAttribute(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        PersistableEmbraceSpan persistableEmbraceSpan = this.sessionSpan.get();
        if (persistableEmbraceSpan == null) {
            return false;
        }
        PersistableEmbraceSpan currentSession = persistableEmbraceSpan;
        return currentSession.removeCustomAttribute(key);
    }

    private final PersistableEmbraceSpan startSessionSpan(long startTimeMs) {
        PersistableEmbraceSpan persistableEmbraceSpan;
        this.traceCount.set(0);
        this.internalTraceCount.set(0);
        PersistableEmbraceSpan $this$apply = persistableEmbraceSpan = EmbraceSpanFactory.DefaultImpls.create$default((EmbraceSpanFactory)this.embraceSpanFactorySupplier.invoke(), "session", EmbType.Ux.Session.INSTANCE, true, false, null, 16, null);
        boolean bl = false;
        $this$apply.start(startTimeMs);
        $this$apply.setSystemAttribute(EmbraceAttributeKeysKt.getEmbSessionId(), Uuid.getEmbUuid$default(null, 1, null));
        return persistableEmbraceSpan;
    }

    public CurrentSessionSpanImpl(@NotNull Clock openTelemetryClock, @NotNull TelemetryService telemetryService2, @NotNull SpanRepository spanRepository2, @NotNull SpanSink spanSink2, @NotNull Function0<? extends EmbraceSpanFactory> embraceSpanFactorySupplier) {
        Intrinsics.checkNotNullParameter((Object)openTelemetryClock, (String)"openTelemetryClock");
        Intrinsics.checkNotNullParameter((Object)telemetryService2, (String)"telemetryService");
        Intrinsics.checkNotNullParameter((Object)spanRepository2, (String)"spanRepository");
        Intrinsics.checkNotNullParameter((Object)spanSink2, (String)"spanSink");
        Intrinsics.checkNotNullParameter(embraceSpanFactorySupplier, (String)"embraceSpanFactorySupplier");
        this.openTelemetryClock = openTelemetryClock;
        this.telemetryService = telemetryService2;
        this.spanRepository = spanRepository2;
        this.spanSink = spanSink2;
        this.embraceSpanFactorySupplier = embraceSpanFactorySupplier;
        this.traceCount = new AtomicInteger(0);
        this.internalTraceCount = new AtomicInteger(0);
        this.initialized = new AtomicBoolean(false);
        this.sessionSpan = new AtomicReference<Object>(null);
    }
}

