/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk.internal.spans;

import io.embrace.android.embracesdk.arch.schema.EmbType;
import io.embrace.android.embracesdk.arch.schema.FixedAttribute;
import io.embrace.android.embracesdk.arch.schema.KeySpan;
import io.embrace.android.embracesdk.arch.schema.PrivateSpan;
import io.embrace.android.embracesdk.arch.schema.TelemetryType;
import io.embrace.android.embracesdk.internal.spans.EmbraceExtensionsKt;
import io.embrace.android.embracesdk.spans.EmbraceSpan;
import io.embrace.android.embracesdk.spans.PersistableEmbraceSpan;
import io.embrace.android.embracesdk.spans.PersistableEmbraceSpanKt;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010$\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010\rJ\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050(J\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00120*J\b\u0010+\u001a\u0004\u0018\u00010\fJ\u0016\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\u00052\u0006\u0010/\u001a\u00020\u0005J\u0006\u00100\u001a\u00020-J\u000e\u00101\u001a\u00020-2\u0006\u00102\u001a\u00020\u0016J\u000e\u00103\u001a\u00020-2\u0006\u00104\u001a\u000205J\u000e\u00106\u001a\u0002072\u0006\u0010 \u001a\u00020!J\b\u00108\u001a\u00020-H\u0002R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001e\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u0016@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0016\u0010\u001a\u001a\n \u001c*\u0004\u0018\u00010\u001b0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001d\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u001e\u0010 \u001a\u0004\u0018\u00010!X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010&\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%\u00a8\u00069"}, d2={"Lio/embrace/android/embracesdk/internal/spans/EmbraceSpanBuilder;", "", "tracer", "Lio/opentelemetry/api/trace/Tracer;", "name", "", "telemetryType", "Lio/embrace/android/embracesdk/arch/schema/TelemetryType;", "internal", "", "private", "parentSpan", "Lio/embrace/android/embracesdk/spans/EmbraceSpan;", "(Lio/opentelemetry/api/trace/Tracer;Ljava/lang/String;Lio/embrace/android/embracesdk/arch/schema/TelemetryType;ZZLio/embrace/android/embracesdk/spans/EmbraceSpan;)V", "customAttributes", "", "fixedAttributes", "", "Lio/embrace/android/embracesdk/arch/schema/FixedAttribute;", "getInternal", "()Z", "<set-?>", "Lio/opentelemetry/context/Context;", "parentContext", "getParentContext", "()Lio/opentelemetry/context/Context;", "sdkSpanBuilder", "Lio/opentelemetry/api/trace/SpanBuilder;", "kotlin.jvm.PlatformType", "spanName", "getSpanName", "()Ljava/lang/String;", "startTimeMs", "", "getStartTimeMs", "()Ljava/lang/Long;", "setStartTimeMs", "(Ljava/lang/Long;)V", "Ljava/lang/Long;", "getCustomAttributes", "", "getFixedAttributes", "", "getParentSpan", "setCustomAttribute", "", "key", "value", "setNoParent", "setParentContext", "context", "setSpanKind", "spanKind", "Lio/opentelemetry/api/trace/SpanKind;", "startSpan", "Lio/opentelemetry/api/trace/Span;", "updateKeySpan", "embrace-android-sdk_release"})
public final class EmbraceSpanBuilder {
    private Context parentContext;
    @NotNull
    private final String spanName;
    @Nullable
    private Long startTimeMs;
    private final SpanBuilder sdkSpanBuilder;
    private final List<FixedAttribute> fixedAttributes;
    private final Map<String, String> customAttributes;
    private final boolean internal;

    @NotNull
    public final Context getParentContext() {
        Context context2 = this.parentContext;
        if (context2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"parentContext");
        }
        return context2;
    }

    @NotNull
    public final String getSpanName() {
        return this.spanName;
    }

    @Nullable
    public final Long getStartTimeMs() {
        return this.startTimeMs;
    }

    public final void setStartTimeMs(@Nullable Long l) {
        this.startTimeMs = l;
    }

    @NotNull
    public final Span startSpan(long startTimeMs) {
        this.sdkSpanBuilder.setStartTimestamp(startTimeMs, TimeUnit.MILLISECONDS);
        Span span = this.sdkSpanBuilder.startSpan();
        Intrinsics.checkNotNullExpressionValue((Object)span, (String)"sdkSpanBuilder.startSpan()");
        return span;
    }

    @NotNull
    public final List<FixedAttribute> getFixedAttributes() {
        return this.fixedAttributes;
    }

    @NotNull
    public final Map<String, String> getCustomAttributes() {
        return this.customAttributes;
    }

    public final void setCustomAttribute(@NotNull String key, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.customAttributes.put(key, value);
    }

    @Nullable
    public final EmbraceSpan getParentSpan() {
        Context context2 = this.parentContext;
        if (context2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"parentContext");
        }
        return PersistableEmbraceSpanKt.getEmbraceSpan(context2);
    }

    public final void setParentContext(@NotNull Context context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Context context3 = this.parentContext = context2;
        if (context3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"parentContext");
        }
        this.sdkSpanBuilder.setParent(context3);
        this.updateKeySpan();
    }

    public final void setNoParent() {
        Context context2 = Context.root();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"Context.root()");
        this.parentContext = context2;
        this.sdkSpanBuilder.setNoParent();
        this.updateKeySpan();
    }

    public final void setSpanKind(@NotNull SpanKind spanKind) {
        Intrinsics.checkNotNullParameter((Object)spanKind, (String)"spanKind");
        this.sdkSpanBuilder.setSpanKind(spanKind);
    }

    private final void updateKeySpan() {
        if (this.fixedAttributes.contains(EmbType.Performance.Default.INSTANCE)) {
            if (this.getParentSpan() == null) {
                this.fixedAttributes.add(KeySpan.INSTANCE);
            } else {
                this.fixedAttributes.remove(KeySpan.INSTANCE);
            }
        }
    }

    public final boolean getInternal() {
        return this.internal;
    }

    public EmbraceSpanBuilder(@NotNull Tracer tracer, @NotNull String name, @NotNull TelemetryType telemetryType, boolean internal, boolean bl, @Nullable EmbraceSpan parentSpan) {
        Intrinsics.checkNotNullParameter((Object)tracer, (String)"tracer");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)telemetryType, (String)"telemetryType");
        this.internal = internal;
        this.spanName = this.internal ? EmbraceExtensionsKt.toEmbraceObjectName(name) : name;
        this.sdkSpanBuilder = tracer.spanBuilder(this.spanName);
        this.fixedAttributes = CollectionsKt.mutableListOf((Object[])new FixedAttribute[]{telemetryType});
        this.customAttributes = new LinkedHashMap();
        if (parentSpan instanceof PersistableEmbraceSpan) {
            Context context2 = ((PersistableEmbraceSpan)parentSpan).asNewContext();
            if (context2 == null) {
                context2 = Context.root();
            }
            Context newParentContext = context2;
            Context context3 = newParentContext.with((ImplicitContextKeyed)parentSpan);
            Intrinsics.checkNotNullExpressionValue((Object)context3, (String)"newParentContext.with(parentSpan)");
            this.setParentContext(context3);
        } else {
            this.setNoParent();
        }
        if (bl) {
            this.fixedAttributes.add(PrivateSpan.INSTANCE);
        }
    }
}

