/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk.internal.spans;

import io.embrace.android.embracesdk.annotation.InternalApi;
import io.embrace.android.embracesdk.internal.spans.EmbraceExtensionsKt;
import io.embrace.android.embracesdk.opentelemetry.EmbraceAttributeKeysKt;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Context;
import io.opentelemetry.sdk.trace.ReadWriteSpan;
import io.opentelemetry.sdk.trace.ReadableSpan;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@InternalApi
@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u0013H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lio/embrace/android/embracesdk/internal/spans/EmbraceSpanProcessor;", "Lio/opentelemetry/sdk/trace/SpanProcessor;", "spanExporter", "Lio/opentelemetry/sdk/trace/export/SpanExporter;", "processIdentifier", "", "(Lio/opentelemetry/sdk/trace/export/SpanExporter;Ljava/lang/String;)V", "counter", "Ljava/util/concurrent/atomic/AtomicLong;", "isEndRequired", "", "isStartRequired", "onEnd", "", "span", "Lio/opentelemetry/sdk/trace/ReadableSpan;", "onStart", "parentContext", "Lio/opentelemetry/context/Context;", "Lio/opentelemetry/sdk/trace/ReadWriteSpan;", "embrace-android-sdk_release"})
public final class EmbraceSpanProcessor
implements SpanProcessor {
    private final AtomicLong counter;
    private final SpanExporter spanExporter;
    private final String processIdentifier;

    public void onStart(@NotNull Context parentContext, @NotNull ReadWriteSpan span) {
        Intrinsics.checkNotNullParameter((Object)parentContext, (String)"parentContext");
        Intrinsics.checkNotNullParameter((Object)span, (String)"span");
        EmbraceExtensionsKt.setEmbraceAttribute((Span)span, EmbraceAttributeKeysKt.getEmbSequenceId(), String.valueOf(this.counter.getAndIncrement()));
        EmbraceExtensionsKt.setEmbraceAttribute((Span)span, EmbraceAttributeKeysKt.getEmbProcessIdentifier(), this.processIdentifier);
    }

    public void onEnd(@NotNull ReadableSpan span) {
        Intrinsics.checkNotNullParameter((Object)span, (String)"span");
        this.spanExporter.export((Collection)CollectionsKt.mutableListOf((Object[])new SpanData[]{span.toSpanData()}));
    }

    public boolean isStartRequired() {
        return true;
    }

    public boolean isEndRequired() {
        return true;
    }

    public EmbraceSpanProcessor(@NotNull SpanExporter spanExporter, @NotNull String processIdentifier) {
        Intrinsics.checkNotNullParameter((Object)spanExporter, (String)"spanExporter");
        Intrinsics.checkNotNullParameter((Object)processIdentifier, (String)"processIdentifier");
        this.spanExporter = spanExporter;
        this.processIdentifier = processIdentifier;
        this.counter = new AtomicLong(1L);
    }
}

