/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk.internal.spans;

import io.embrace.android.embracesdk.annotation.BetaApi;
import io.embrace.android.embracesdk.internal.clock.Clock;
import io.embrace.android.embracesdk.internal.clock.ClockKt;
import io.embrace.android.embracesdk.internal.spans.SpanService;
import io.embrace.android.embracesdk.spans.EmbraceSpan;
import io.embrace.android.embracesdk.spans.EmbraceSpanEvent;
import io.embrace.android.embracesdk.spans.ErrorCode;
import io.embrace.android.embracesdk.spans.TracingApi;
import java.util.List;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001c\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\bH\u0016J\u0006\u0010\f\u001a\u00020\rJ\u0012\u0010\u000e\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000f\u001a\u00020\nH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0017JZ\u0010\u0012\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\r2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\u000b\u001a\u0004\u0018\u00010\b2\u0014\u0010\u0017\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u00182\u000e\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u001b\u0018\u00010\u001aH\u0016JY\u0010\u001c\u001a\u0002H\u001d\"\u0004\b\u0000\u0010\u001d2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\b2\u0014\u0010\u0017\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u00182\u000e\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u001b\u0018\u00010\u001a2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\u001d0\u001fH\u0016\u00a2\u0006\u0002\u0010 J+\u0010!\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\b2\b\u0010\u0013\u001a\u0004\u0018\u00010\rH\u0016\u00a2\u0006\u0002\u0010\"R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lio/embrace/android/embracesdk/internal/spans/EmbraceTracer;", "Lio/embrace/android/embracesdk/spans/TracingApi;", "clock", "Lio/embrace/android/embracesdk/internal/clock/Clock;", "spanService", "Lio/embrace/android/embracesdk/internal/spans/SpanService;", "(Lio/embrace/android/embracesdk/internal/clock/Clock;Lio/embrace/android/embracesdk/internal/spans/SpanService;)V", "createSpan", "Lio/embrace/android/embracesdk/spans/EmbraceSpan;", "name", "", "parent", "getSdkCurrentTimeMs", "", "getSpan", "spanId", "isTracingAvailable", "", "recordCompletedSpan", "startTimeMs", "endTimeMs", "errorCode", "Lio/embrace/android/embracesdk/spans/ErrorCode;", "attributes", "", "events", "", "Lio/embrace/android/embracesdk/spans/EmbraceSpanEvent;", "recordSpan", "T", "code", "Lkotlin/Function0;", "(Ljava/lang/String;Lio/embrace/android/embracesdk/spans/EmbraceSpan;Ljava/util/Map;Ljava/util/List;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "startSpan", "(Ljava/lang/String;Lio/embrace/android/embracesdk/spans/EmbraceSpan;Ljava/lang/Long;)Lio/embrace/android/embracesdk/spans/EmbraceSpan;", "embrace-android-sdk_release"})
public final class EmbraceTracer
implements TracingApi {
    private final Clock clock;
    private final SpanService spanService;

    @Override
    @Nullable
    public EmbraceSpan createSpan(@NotNull String name, @Nullable EmbraceSpan parent) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return SpanService.DefaultImpls.createSpan$default(this.spanService, name, parent, null, false, false, 4, null);
    }

    @Override
    @Nullable
    public EmbraceSpan startSpan(@NotNull String name, @Nullable EmbraceSpan parent, @Nullable Long startTimeMs) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Long l = startTimeMs;
        return SpanService.DefaultImpls.startSpan$default(this.spanService, name, parent, l != null ? Long.valueOf(ClockKt.normalizeTimestampAsMillis(l)) : null, null, false, false, 8, null);
    }

    @Override
    public <T> T recordSpan(@NotNull String name, @Nullable EmbraceSpan parent, @Nullable Map<String, String> attributes, @Nullable List<EmbraceSpanEvent> events, @NotNull Function0<? extends T> code) {
        List list;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(code, (String)"code");
        Map map = attributes;
        if (map == null) {
            map = MapsKt.emptyMap();
        }
        if ((list = events) == null) {
            list = CollectionsKt.emptyList();
        }
        return (T)SpanService.DefaultImpls.recordSpan$default(this.spanService, name, parent, null, false, false, map, list, code, 4, null);
    }

    @Override
    public boolean recordCompletedSpan(@NotNull String name, long startTimeMs, long endTimeMs, @Nullable ErrorCode errorCode, @Nullable EmbraceSpan parent, @Nullable Map<String, String> attributes, @Nullable List<EmbraceSpanEvent> events) {
        List list;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        long l = ClockKt.normalizeTimestampAsMillis(startTimeMs);
        long l2 = ClockKt.normalizeTimestampAsMillis(endTimeMs);
        Map map = attributes;
        if (map == null) {
            map = MapsKt.emptyMap();
        }
        if ((list = events) == null) {
            list = CollectionsKt.emptyList();
        }
        return SpanService.DefaultImpls.recordCompletedSpan$default(this.spanService, name, l, l2, parent, null, false, false, map, list, errorCode, 16, null);
    }

    @Override
    @Nullable
    public EmbraceSpan getSpan(@NotNull String spanId) {
        Intrinsics.checkNotNullParameter((Object)spanId, (String)"spanId");
        return this.spanService.getSpan(spanId);
    }

    public final long getSdkCurrentTimeMs() {
        return this.clock.now();
    }

    @Override
    @Deprecated(message="Not required. Use Embrace.isStarted() to know when the full tracing API is available")
    public boolean isTracingAvailable() {
        return this.spanService.initialized();
    }

    public EmbraceTracer(@NotNull Clock clock, @NotNull SpanService spanService2) {
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)spanService2, (String)"spanService");
        this.clock = clock;
        this.spanService = spanService2;
    }

    @Override
    @BetaApi
    @Nullable
    public EmbraceSpan createSpan(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return TracingApi.DefaultImpls.createSpan(this, name);
    }

    @Override
    @BetaApi
    @Nullable
    public EmbraceSpan startSpan(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return TracingApi.DefaultImpls.startSpan(this, name);
    }

    @Override
    @BetaApi
    @Nullable
    public EmbraceSpan startSpan(@NotNull String name, @Nullable EmbraceSpan parent) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return TracingApi.DefaultImpls.startSpan(this, name, parent);
    }

    @Override
    @BetaApi
    public <T> T recordSpan(@NotNull String name, @NotNull Function0<? extends T> code) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(code, (String)"code");
        return TracingApi.DefaultImpls.recordSpan(this, name, code);
    }

    @Override
    @BetaApi
    public <T> T recordSpan(@NotNull String name, @Nullable EmbraceSpan parent, @NotNull Function0<? extends T> code) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(code, (String)"code");
        return TracingApi.DefaultImpls.recordSpan(this, name, parent, code);
    }

    @Override
    @BetaApi
    public <T> T recordSpan(@NotNull String name, @Nullable Map<String, String> attributes, @Nullable List<EmbraceSpanEvent> events, @NotNull Function0<? extends T> code) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(code, (String)"code");
        return TracingApi.DefaultImpls.recordSpan(this, name, attributes, events, code);
    }

    @Override
    @BetaApi
    public boolean recordCompletedSpan(@NotNull String name, long startTimeMs, long endTimeMs) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return TracingApi.DefaultImpls.recordCompletedSpan(this, name, startTimeMs, endTimeMs);
    }

    @Override
    @BetaApi
    public boolean recordCompletedSpan(@NotNull String name, long startTimeMs, long endTimeMs, @Nullable ErrorCode errorCode) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return TracingApi.DefaultImpls.recordCompletedSpan((TracingApi)this, name, startTimeMs, endTimeMs, errorCode);
    }

    @Override
    @BetaApi
    public boolean recordCompletedSpan(@NotNull String name, long startTimeMs, long endTimeMs, @Nullable EmbraceSpan parent) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return TracingApi.DefaultImpls.recordCompletedSpan((TracingApi)this, name, startTimeMs, endTimeMs, parent);
    }

    @Override
    @BetaApi
    public boolean recordCompletedSpan(@NotNull String name, long startTimeMs, long endTimeMs, @Nullable ErrorCode errorCode, @Nullable EmbraceSpan parent) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return TracingApi.DefaultImpls.recordCompletedSpan((TracingApi)this, name, startTimeMs, endTimeMs, errorCode, parent);
    }

    @Override
    @BetaApi
    public boolean recordCompletedSpan(@NotNull String name, long startTimeMs, long endTimeMs, @Nullable Map<String, String> attributes, @Nullable List<EmbraceSpanEvent> events) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return TracingApi.DefaultImpls.recordCompletedSpan((TracingApi)this, name, startTimeMs, endTimeMs, attributes, events);
    }
}

