/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk.internal.spans;

import io.embrace.android.embracesdk.arch.schema.EmbType;
import io.embrace.android.embracesdk.spans.EmbraceSpan;
import io.embrace.android.embracesdk.spans.ErrorCode;
import io.embrace.android.embracesdk.spans.PersistableEmbraceSpan;
import io.embrace.android.embracesdk.utils.CollectionExtensionsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eJ\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0010J\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u0010J\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0005J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0014\u001a\u00020\u0005H\u0002J\u000e\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u0006J\u000e\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0005R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\t0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lio/embrace/android/embracesdk/internal/spans/SpanRepository;", "", "()V", "activeSpans", "", "", "Lio/embrace/android/embracesdk/spans/PersistableEmbraceSpan;", "completedSpans", "spanIdsInProcess", "Ljava/util/concurrent/atomic/AtomicInteger;", "clearCompletedSpans", "", "failActiveSpans", "failureTimeMs", "", "getActiveSpans", "", "getCompletedSpans", "getSpan", "Lio/embrace/android/embracesdk/spans/EmbraceSpan;", "spanId", "notTracked", "", "trackStartedSpan", "embraceSpan", "trackedSpanStopped", "embrace-android-sdk_release"})
public final class SpanRepository {
    private final Map<String, PersistableEmbraceSpan> activeSpans = new ConcurrentHashMap();
    private final Map<String, PersistableEmbraceSpan> completedSpans = new LinkedHashMap();
    private final Map<String, AtomicInteger> spanIdsInProcess = new ConcurrentHashMap();

    public final void trackStartedSpan(@NotNull PersistableEmbraceSpan embraceSpan) {
        Intrinsics.checkNotNullParameter((Object)embraceSpan, (String)"embraceSpan");
        String string2 = embraceSpan.getSpanId();
        if (string2 == null) {
            return;
        }
        String spanId = string2;
        if (this.notTracked(spanId)) {
            CollectionExtensionsKt.lockAndRun(this.spanIdsInProcess, spanId, (Function0)new Function0<Unit>(this, spanId, embraceSpan){
                final /* synthetic */ SpanRepository this$0;
                final /* synthetic */ String $spanId;
                final /* synthetic */ PersistableEmbraceSpan $embraceSpan;

                public final void invoke() {
                    if (SpanRepository.access$notTracked(this.this$0, this.$spanId)) {
                        if (this.$embraceSpan.isRecording()) {
                            SpanRepository.access$getActiveSpans$p(this.this$0).put(this.$spanId, this.$embraceSpan);
                        } else {
                            SpanRepository.access$getCompletedSpans$p(this.this$0).put(this.$spanId, this.$embraceSpan);
                        }
                    }
                }
                {
                    this.this$0 = spanRepository2;
                    this.$spanId = string2;
                    this.$embraceSpan = persistableEmbraceSpan;
                    super(0);
                }
            });
        }
    }

    public final void trackedSpanStopped(@NotNull String spanId) {
        Intrinsics.checkNotNullParameter((Object)spanId, (String)"spanId");
        CollectionExtensionsKt.lockAndRun(this.spanIdsInProcess, spanId, (Function0)new Function0<Unit>(this, spanId){
            final /* synthetic */ SpanRepository this$0;
            final /* synthetic */ String $spanId;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Unit invoke() {
                PersistableEmbraceSpan persistableEmbraceSpan;
                PersistableEmbraceSpan persistableEmbraceSpan2 = (PersistableEmbraceSpan)SpanRepository.access$getActiveSpans$p(this.this$0).get(this.$spanId);
                PersistableEmbraceSpan persistableEmbraceSpan3 = persistableEmbraceSpan2;
                if (persistableEmbraceSpan2 == null) return null;
                PersistableEmbraceSpan it = persistableEmbraceSpan = persistableEmbraceSpan3;
                boolean bl = false;
                if (it.isRecording()) return null;
                boolean bl2 = true;
                if (!bl2) return null;
                PersistableEmbraceSpan persistableEmbraceSpan4 = persistableEmbraceSpan;
                persistableEmbraceSpan3 = persistableEmbraceSpan4;
                if (persistableEmbraceSpan4 == null) return null;
                it = persistableEmbraceSpan = persistableEmbraceSpan3;
                boolean bl3 = false;
                PersistableEmbraceSpan persistableEmbraceSpan5 = (PersistableEmbraceSpan)SpanRepository.access$getActiveSpans$p(this.this$0).remove(this.$spanId);
                persistableEmbraceSpan3 = persistableEmbraceSpan5;
                if (persistableEmbraceSpan5 == null) return null;
                PersistableEmbraceSpan embraceSpan = persistableEmbraceSpan = persistableEmbraceSpan3;
                boolean bl4 = false;
                SpanRepository.access$getCompletedSpans$p(this.this$0).put(this.$spanId, embraceSpan);
                Unit unit = Unit.INSTANCE;
                return unit;
            }
            {
                this.this$0 = spanRepository2;
                this.$spanId = string2;
                super(0);
            }
        });
    }

    @Nullable
    public final EmbraceSpan getSpan(@NotNull String spanId) {
        Intrinsics.checkNotNullParameter((Object)spanId, (String)"spanId");
        return (EmbraceSpan)CollectionExtensionsKt.lockAndRun(this.spanIdsInProcess, spanId, (Function0)new Function0<PersistableEmbraceSpan>(this, spanId){
            final /* synthetic */ SpanRepository this$0;
            final /* synthetic */ String $spanId;

            @Nullable
            public final PersistableEmbraceSpan invoke() {
                PersistableEmbraceSpan persistableEmbraceSpan = (PersistableEmbraceSpan)SpanRepository.access$getActiveSpans$p(this.this$0).get(this.$spanId);
                if (persistableEmbraceSpan == null) {
                    persistableEmbraceSpan = (PersistableEmbraceSpan)SpanRepository.access$getCompletedSpans$p(this.this$0).get(this.$spanId);
                }
                return persistableEmbraceSpan;
            }
            {
                this.this$0 = spanRepository2;
                this.$spanId = string2;
                super(0);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<PersistableEmbraceSpan> getActiveSpans() {
        List list;
        Map<String, AtomicInteger> map = this.spanIdsInProcess;
        synchronized (map) {
            boolean bl = false;
            list = CollectionsKt.toList((Iterable)this.activeSpans.values());
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<PersistableEmbraceSpan> getCompletedSpans() {
        List list;
        Map<String, AtomicInteger> map = this.spanIdsInProcess;
        synchronized (map) {
            boolean bl = false;
            list = CollectionsKt.toList((Iterable)this.completedSpans.values());
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    public final void failActiveSpans(long failureTimeMs) {
        void $this$filterNotTo$iv$iv;
        Iterable $this$filterNot$iv = this.getActiveSpans();
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            PersistableEmbraceSpan it = (PersistableEmbraceSpan)element$iv$iv;
            boolean bl = false;
            if (it.hasFixedAttribute(EmbType.Ux.Session.INSTANCE)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PersistableEmbraceSpan span = (PersistableEmbraceSpan)element$iv;
            boolean bl = false;
            span.stop(ErrorCode.FAILURE, failureTimeMs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clearCompletedSpans() {
        Map<String, AtomicInteger> map = this.spanIdsInProcess;
        synchronized (map) {
            boolean bl = false;
            this.completedSpans.clear();
            Unit unit = Unit.INSTANCE;
        }
    }

    private final boolean notTracked(String spanId) {
        return this.activeSpans.get(spanId) == null && this.completedSpans.get(spanId) == null;
    }

    public static final /* synthetic */ boolean access$notTracked(SpanRepository $this, String spanId) {
        return $this.notTracked(spanId);
    }

    public static final /* synthetic */ Map access$getActiveSpans$p(SpanRepository $this) {
        return $this.activeSpans;
    }

    public static final /* synthetic */ Map access$getCompletedSpans$p(SpanRepository $this) {
        return $this.completedSpans;
    }
}

