/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk.network;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.embrace.android.embracesdk.internal.network.http.NetworkCaptureData;
import io.embrace.android.embracesdk.network.http.HttpMethod;

public final class EmbraceNetworkRequest {
    @NonNull
    private final String url;
    @NonNull
    private final HttpMethod httpMethod;
    @NonNull
    private final Long startTime;
    @NonNull
    private final Long endTime;
    @Nullable
    private final Long bytesReceived;
    @Nullable
    private final Long bytesSent;
    @Nullable
    private final Integer responseCode;
    @Nullable
    private final Throwable error;
    @Nullable
    private final String errorType;
    @Nullable
    private final String errorMessage;
    @Nullable
    private final String traceId;
    @Nullable
    private final String w3cTraceparent;
    @Nullable
    private final NetworkCaptureData networkCaptureData;

    @NonNull
    public static EmbraceNetworkRequest fromCompletedRequest(@NonNull String url, @NonNull HttpMethod httpMethod, long startTime, long endTime, long bytesSent, long bytesReceived, int statusCode) {
        return EmbraceNetworkRequest.fromCompletedRequest(url, httpMethod, startTime, endTime, bytesSent, bytesReceived, statusCode, null, null);
    }

    @NonNull
    public static EmbraceNetworkRequest fromCompletedRequest(@NonNull String url, @NonNull HttpMethod httpMethod, long startTime, long endTime, long bytesSent, long bytesReceived, int statusCode, @Nullable String traceId) {
        return EmbraceNetworkRequest.fromCompletedRequest(url, httpMethod, startTime, endTime, bytesSent, bytesReceived, statusCode, traceId, null, null);
    }

    @NonNull
    public static EmbraceNetworkRequest fromCompletedRequest(@NonNull String url, @NonNull HttpMethod httpMethod, long startTime, long endTime, long bytesSent, long bytesReceived, int statusCode, @Nullable String traceId, @Nullable NetworkCaptureData networkCaptureData) {
        return EmbraceNetworkRequest.fromCompletedRequest(url, httpMethod, startTime, endTime, bytesSent, bytesReceived, statusCode, traceId, null, networkCaptureData);
    }

    @NonNull
    public static EmbraceNetworkRequest fromCompletedRequest(@NonNull String url, @NonNull HttpMethod httpMethod, long startTime, long endTime, long bytesSent, long bytesReceived, int statusCode, @Nullable String traceId, @Nullable String w3cTraceparent, @Nullable NetworkCaptureData networkCaptureData) {
        return new EmbraceNetworkRequest(url, httpMethod, startTime, endTime, bytesSent, bytesReceived, statusCode, null, null, traceId, w3cTraceparent, networkCaptureData);
    }

    @NonNull
    public static EmbraceNetworkRequest fromIncompleteRequest(@NonNull String url, @NonNull HttpMethod httpMethod, long startTime, long endTime, @NonNull String errorType, @NonNull String errorMessage) {
        return EmbraceNetworkRequest.fromIncompleteRequest(url, httpMethod, startTime, endTime, errorType, errorMessage, null);
    }

    @NonNull
    public static EmbraceNetworkRequest fromIncompleteRequest(@NonNull String url, @NonNull HttpMethod httpMethod, long startTime, long endTime, @NonNull String errorType, @NonNull String errorMessage, @Nullable String traceId) {
        return EmbraceNetworkRequest.fromIncompleteRequest(url, httpMethod, startTime, endTime, errorType, errorMessage, traceId, null, null);
    }

    @NonNull
    public static EmbraceNetworkRequest fromIncompleteRequest(@NonNull String url, @NonNull HttpMethod httpMethod, long startTime, long endTime, @NonNull String errorType, @NonNull String errorMessage, @Nullable String traceId, @Nullable NetworkCaptureData networkCaptureData) {
        return new EmbraceNetworkRequest(url, httpMethod, startTime, endTime, null, null, null, errorType, errorMessage, traceId, null, networkCaptureData);
    }

    @NonNull
    public static EmbraceNetworkRequest fromIncompleteRequest(@NonNull String url, @NonNull HttpMethod httpMethod, long startTime, long endTime, @NonNull String errorType, @NonNull String errorMessage, @Nullable String traceId, @Nullable String w3cTraceparent, @Nullable NetworkCaptureData networkCaptureData) {
        return new EmbraceNetworkRequest(url, httpMethod, startTime, endTime, null, null, null, errorType, errorMessage, traceId, w3cTraceparent, networkCaptureData);
    }

    private EmbraceNetworkRequest(@NonNull String url, @NonNull HttpMethod httpMethod, @NonNull Long startTime, @NonNull Long endTime, @Nullable Long bytesSent, @Nullable Long bytesReceived, @Nullable Integer responseCode, @Nullable String errorType, @Nullable String errorMessage, @Nullable String traceId, @Nullable String w3cTraceparent, @Nullable NetworkCaptureData networkCaptureData) {
        this.url = url;
        this.httpMethod = httpMethod;
        this.startTime = startTime;
        this.endTime = endTime;
        this.bytesSent = bytesSent;
        this.bytesReceived = bytesReceived;
        this.responseCode = responseCode;
        this.errorType = errorType;
        this.errorMessage = errorMessage;
        this.error = null;
        this.traceId = traceId;
        this.w3cTraceparent = w3cTraceparent;
        this.networkCaptureData = networkCaptureData;
    }

    @NonNull
    public String getUrl() {
        return this.url;
    }

    @NonNull
    public String getHttpMethod() {
        return this.httpMethod != null ? this.httpMethod.name().toUpperCase() : null;
    }

    @NonNull
    public Long getStartTime() {
        return this.startTime;
    }

    @NonNull
    public Long getEndTime() {
        return this.endTime;
    }

    @NonNull
    public Long getBytesIn() {
        return this.bytesReceived == null ? 0L : this.bytesReceived;
    }

    @NonNull
    public Long getBytesOut() {
        return this.bytesSent == null ? 0L : this.bytesSent;
    }

    @Nullable
    public Integer getResponseCode() {
        return this.responseCode;
    }

    @Nullable
    public Throwable getError() {
        return this.error;
    }

    @Nullable
    public String getTraceId() {
        return this.traceId;
    }

    @Nullable
    public String getW3cTraceparent() {
        return this.w3cTraceparent;
    }

    @Nullable
    public Long getBytesReceived() {
        return this.bytesReceived;
    }

    @Nullable
    public Long getBytesSent() {
        return this.bytesSent;
    }

    @Nullable
    public NetworkCaptureData getNetworkCaptureData() {
        return this.networkCaptureData;
    }

    @Nullable
    public String getErrorType() {
        return this.errorType;
    }

    @Nullable
    public String getErrorMessage() {
        return this.errorMessage;
    }
}

