/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk.network.logging;

import io.embrace.android.embracesdk.config.ConfigService;
import io.embrace.android.embracesdk.logging.EmbLogger;
import io.embrace.android.embracesdk.network.logging.DomainCountLimiter;
import io.embrace.android.embracesdk.network.logging.DomainSettings;
import io.embrace.android.embracesdk.payload.NetworkSessionV2;
import io.embrace.android.embracesdk.session.MemoryCleanerListener;
import io.embrace.android.embracesdk.utils.NetworkUtils;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\nH\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001bH\u0002J\u0010\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u0019\u001a\u00020\nH\u0002R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\r0\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lio/embrace/android/embracesdk/network/logging/EmbraceDomainCountLimiter;", "Lio/embrace/android/embracesdk/session/MemoryCleanerListener;", "Lio/embrace/android/embracesdk/network/logging/DomainCountLimiter;", "configService", "Lio/embrace/android/embracesdk/config/ConfigService;", "logger", "Lio/embrace/android/embracesdk/logging/EmbLogger;", "(Lio/embrace/android/embracesdk/config/ConfigService;Lio/embrace/android/embracesdk/logging/EmbLogger;)V", "callsPerDomainSuffix", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lio/embrace/android/embracesdk/payload/NetworkSessionV2$DomainCount;", "defaultPerDomainSuffixCallLimit", "", "domainSetting", "Lio/embrace/android/embracesdk/network/logging/DomainSettings;", "domainSuffixCallLimits", "", "ipAddressNetworkCallCount", "Ljava/util/concurrent/atomic/AtomicInteger;", "lock", "", "untrackedNetworkCallCount", "canLogNetworkRequest", "", "domain", "cleanCollections", "", "clearNetworkCalls", "createLimitForDomain", "embrace-android-sdk_release"})
public final class EmbraceDomainCountLimiter
implements MemoryCleanerListener,
DomainCountLimiter {
    private final ConcurrentHashMap<String, DomainSettings> domainSetting;
    private final ConcurrentHashMap<String, NetworkSessionV2.DomainCount> callsPerDomainSuffix;
    private final AtomicInteger ipAddressNetworkCallCount;
    private final AtomicInteger untrackedNetworkCallCount;
    private int defaultPerDomainSuffixCallLimit;
    private Map<String, Integer> domainSuffixCallLimits;
    private final Object lock;
    private final ConfigService configService;
    private final EmbLogger logger;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean canLogNetworkRequest(@NotNull String domain) {
        Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
        Object object = this.lock;
        synchronized (object) {
            block11: {
                DomainSettings settings;
                block10: {
                    block9: {
                        boolean bl = false;
                        if (!NetworkUtils.isIpAddress(domain)) break block9;
                        boolean bl2 = this.ipAddressNetworkCallCount.getAndIncrement() < this.defaultPerDomainSuffixCallLimit;
                        return bl2;
                    }
                    if (!this.domainSetting.containsKey(domain)) {
                        this.createLimitForDomain(domain);
                    }
                    if ((settings = this.domainSetting.get(domain)) != null) break block10;
                    boolean bl = this.untrackedNetworkCallCount.getAndIncrement() < this.defaultPerDomainSuffixCallLimit;
                    return bl;
                }
                String suffix = settings.getSuffix();
                int limit = settings.getLimit();
                Object object2 = this.callsPerDomainSuffix;
                NetworkSessionV2.DomainCount countPerSuffix = (NetworkSessionV2.DomainCount)object2.get(suffix);
                if (countPerSuffix == null) {
                    countPerSuffix = new NetworkSessionV2.DomainCount(0, limit);
                }
                String string2 = suffix;
                if (string2 != null) {
                    Object it = object2 = string2;
                    boolean bl = false;
                    ((Map)this.callsPerDomainSuffix).put(it, new NetworkSessionV2.DomainCount(countPerSuffix.getRequestCount() + 1, limit));
                }
                if (countPerSuffix.getRequestCount() >= limit) break block11;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void createLimitForDomain(String domain) {
        try {
            Object object = this.domainSuffixCallLimits;
            Iterator<Map.Entry<String, Integer>> iterator = object.entrySet().iterator();
            while (iterator.hasNext()) {
                void key;
                Map.Entry<String, Integer> entry;
                Map.Entry<String, Integer> entry2 = entry = iterator.next();
                object = entry2.getKey();
                entry2 = entry;
                int value = ((Number)entry2.getValue()).intValue();
                if (!StringsKt.endsWith$default((String)domain, (String)key, (boolean)false, (int)2, null)) continue;
                ((Map)this.domainSetting).put(domain, new DomainSettings(value, (String)key));
            }
            if (!this.domainSetting.containsKey(domain)) {
                ((Map)this.domainSetting).put(domain, new DomainSettings(this.defaultPerDomainSuffixCallLimit, domain));
            }
        }
        catch (Exception ex) {
            this.logger.logDebug("Failed to determine limits for domain: " + domain, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanCollections() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            this.clearNetworkCalls();
            this.defaultPerDomainSuffixCallLimit = this.configService.getNetworkBehavior().getNetworkCaptureLimit();
            this.domainSuffixCallLimits = this.configService.getNetworkBehavior().getNetworkCallLimitsPerDomainSuffix();
            Unit unit = Unit.INSTANCE;
        }
    }

    private final void clearNetworkCalls() {
        this.domainSetting.clear();
        this.callsPerDomainSuffix.clear();
        this.ipAddressNetworkCallCount.set(0);
        this.untrackedNetworkCallCount.set(0);
    }

    public EmbraceDomainCountLimiter(@NotNull ConfigService configService2, @NotNull EmbLogger logger2) {
        Intrinsics.checkNotNullParameter((Object)configService2, (String)"configService");
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        this.configService = configService2;
        this.logger = logger2;
        this.domainSetting = new ConcurrentHashMap();
        this.callsPerDomainSuffix = new ConcurrentHashMap();
        this.ipAddressNetworkCallCount = new AtomicInteger(0);
        this.untrackedNetworkCallCount = new AtomicInteger(0);
        this.defaultPerDomainSuffixCallLimit = this.configService.getNetworkBehavior().getNetworkCaptureLimit();
        this.domainSuffixCallLimits = this.configService.getNetworkBehavior().getNetworkCallLimitsPerDomainSuffix();
        this.lock = new Object();
    }
}

